/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class FindUtil {
    private FindUtil() {
    }

    private static void prepareSearch(SearchParameters params, List<BIFile> fileList) {
        BIFile[] entries;
        if (params.rootPath == null) {
            entries = params.fileSpace.listFiles();
        } else {
            BIFile rootFile = params.fileSpace.findFile(params.rootPath);
            if (rootFile == null || !rootFile.isDirectory()) {
                return;
            }
            entries = ((BIDirectory)rootFile).listFiles();
        }
        if (entries == null) {
            return;
        }
        Predicate<BIFile> fileFilter = FindUtil.preparePredicate(params);
        FindUtil.matchFiles(entries, fileList, fileFilter, params.recursive, params.maxResults);
    }

    private static void matchFiles(BIFile[] entries, List<BIFile> fileList, Predicate<BIFile> fileFilter, boolean recursive, int maxResults) {
        for (BIFile entry : entries) {
            if (fileList.size() >= maxResults) {
                return;
            }
            if (fileFilter.test(entry)) {
                fileList.add(entry);
            }
            if (!entry.isDirectory() || !recursive) continue;
            FindUtil.matchFiles(((BIDirectory)entry).listFiles(), fileList, fileFilter, recursive, maxResults);
        }
    }

    private static Predicate<BIFile> preparePredicate(SearchParameters params) {
        Predicate<BIFile> predicate = f -> f != null;
        if (!params.includeDirectories) {
            predicate = predicate.and(f -> !f.isDirectory());
        } else if (!params.includeFiles) {
            predicate = predicate.and(f -> f.isDirectory());
        }
        if (params.startsWith != null) {
            predicate = predicate.and(f -> f.getFileName().startsWith(params.startsWith));
        }
        if (params.contains != null) {
            predicate = predicate.and(f -> f.getFileName().contains(params.contains));
        }
        if (params.endsWith != null) {
            predicate = predicate.and(f -> f.getFileName().endsWith(params.endsWith));
        }
        if (params.fileType != null) {
            predicate = predicate.and(f -> Sys.getRegistry().getFileTypeForExtension(f.getExtension()).is(params.fileType));
        }
        return predicate;
    }

    public static SearchParameters filesAndDirectories() {
        SearchParameters find = new SearchParameters();
        find.includeDirectories = true;
        find.includeFiles = true;
        return find;
    }

    public static SearchParameters directories() {
        SearchParameters find = new SearchParameters();
        find.includeDirectories = true;
        return find;
    }

    public static SearchParameters files() {
        SearchParameters find = new SearchParameters();
        find.includeFiles = true;
        return find;
    }

    public static class SearchParameters {
        private int maxResults = 100;
        private boolean includeDirectories;
        private boolean includeFiles;
        private boolean recursive;
        private FilePath rootPath;
        private String startsWith;
        private String contains;
        private String endsWith;
        private Type fileType;
        private BIFileSpace fileSpace;

        private SearchParameters() {
        }

        public SearchParameters recursively() {
            this.recursive = true;
            return this;
        }

        public SearchParameters fromPath(FilePath rootPath) {
            assert (rootPath != null);
            this.rootPath = rootPath;
            return this;
        }

        public SearchParameters nameStartsWith(String startsWith) {
            assert (startsWith != null);
            this.startsWith = startsWith;
            return this;
        }

        public SearchParameters nameContains(String contains) {
            assert (contains != null);
            this.contains = contains;
            return this;
        }

        public SearchParameters nameEndsWith(String endsWith) {
            assert (endsWith != null);
            this.endsWith = endsWith;
            return this;
        }

        public SearchParameters maxResults(int maxResults) {
            assert (maxResults > 0);
            this.maxResults = maxResults;
            return this;
        }

        public SearchParameters ofType(Type fileType) {
            assert (fileType != null);
            this.fileType = fileType;
            return this;
        }

        public List<BIFile> from(BIFileSpace fileSpace) {
            assert (fileSpace != null);
            this.fileSpace = fileSpace;
            ArrayList<BIFile> fileList = new ArrayList<BIFile>();
            FindUtil.prepareSearch(this, fileList);
            return fileList;
        }

        public List<BIFile> from(BZipFile zipFile) {
            assert (zipFile != null);
            return this.from(SearchParameters.getFileSpace((BIFile)zipFile));
        }

        public List<BIFile> from(BDirectory directory) {
            assert (directory != null);
            if (this.rootPath == null) {
                this.rootPath = directory.getFilePath();
            }
            return this.from(SearchParameters.getFileSpace((BIFile)directory));
        }

        public static BIFileSpace getFileSpace(BIFile source) {
            BIFileSpace space;
            assert (source != null);
            if (source instanceof BZipFile) {
                BZipSpace sourceSpace = new BZipSpace((BZipFile)source);
                space = sourceSpace;
            } else if (source instanceof BIFileSpace) {
                space = (BIFileSpace)source;
            } else if (source.isDirectory()) {
                space = source.getFileSpace();
            } else {
                return null;
            }
            return space;
        }
    }
}

