/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.node;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.NodeManagerListener;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.tridium.opcUaServer.BOpcUaNamespace;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpcUaNodeManagerListener
implements NodeManagerListener {
    private final BOpcUaNamespace opcNamespace;
    public static final Logger LOGGER = Logger.getLogger("opcUaServer.nodeManager");

    public OpcUaNodeManagerListener(BOpcUaNamespace bOpcUaNamespace) {
        this.opcNamespace = bOpcUaNamespace;
    }

    public void onAddNode(ServiceContext serviceContext, NodeId parentNodeId, UaNode parent, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, NodeAttributes attributes, UaReferenceType referenceType, ExpandedNodeId typeDefinitionId, UaNode typeDefinition) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to add a node: " + nodeId + " to: " + parentNodeId);
        }
        this.opcNamespace.checkWriteAccess(serviceContext, nodeId);
    }

    public void onAddReference(ServiceContext serviceContext, NodeId nodeId, UaNode sourceNode, ExpandedNodeId targetNodeId, UaNode targetNode, NodeId referenceTypeId, UaReferenceType referenceType, boolean isForward) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to add a reference: " + nodeId);
        }
        this.opcNamespace.checkWriteAccess(serviceContext, nodeId);
    }

    public boolean onBrowseNode(ServiceContext serviceContext, ViewDescription view, NodeId nodeId, UaNode node, UaReference reference) {
        if (serviceContext == null || nodeId == null) {
            return false;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to browse: " + nodeId);
        }
        try {
            this.opcNamespace.checkReadAccess(serviceContext, nodeId);
            return true;
        }
        catch (StatusException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Browse access denied for node: " + nodeId);
            }
            return false;
        }
    }

    public void onDeleteNode(ServiceContext serviceContext, NodeId nodeId, UaNode node, boolean deleteTargetReferences) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to delete a node: " + nodeId);
        }
        this.opcNamespace.checkWriteAccess(serviceContext, nodeId);
    }

    public void onDeleteReference(ServiceContext serviceContext, NodeId nodeId, UaNode sourceNode, ExpandedNodeId targetNodeId, UaNode targetNode, NodeId referenceTypeId, UaReferenceType referenceType, boolean isForward, boolean deleteBidirectional) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to delete a reference: " + nodeId);
        }
        this.opcNamespace.checkWriteAccess(serviceContext, nodeId);
    }

    public void onCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to create a monitor: " + nodeId);
        }
        this.opcNamespace.checkWriteAccess(serviceContext, nodeId);
    }

    public void onModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem item, UaNode node, MonitoringParameters params, MonitoringFilter filter, AggregateFilterResult filterResult) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to modify a monitor on: " + node.getNodeId());
        }
        this.opcNamespace.checkWriteAccess(serviceContext, node.getNodeId());
    }
}

