/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.alarm.monitoring;

import com.tridium.videoDriver.alarm.monitoring.BMonitorNotification;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="sourceToMonitor", type="BOrd", defaultValue="BOrd.DEFAULT"), @NiagaraProperty(name="lastValueSignaled", type="BValue", defaultValue="new BComponent()", flags=4)})
@NiagaraAction(name="signalNotification", parameterType="BValue", defaultValue="new BComponent()", flags=4)
public abstract class BMonitor
extends BComponent
implements BIMixIn {
    @Generated
    public static final Property enabled = BMonitor.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property sourceToMonitor = BMonitor.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Property lastValueSignaled = BMonitor.newProperty((int)4, (BValue)new BComponent(), null);
    @Generated
    public static final Action signalNotification = BMonitor.newAction((int)4, (BValue)new BComponent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMonitor.class);
    private Logger log = Logger.getLogger("monitor");

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BOrd getSourceToMonitor() {
        return (BOrd)this.get(sourceToMonitor);
    }

    @Generated
    public void setSourceToMonitor(BOrd v) {
        this.set(sourceToMonitor, (BValue)v, null);
    }

    @Generated
    public BValue getLastValueSignaled() {
        return this.get(lastValueSignaled);
    }

    @Generated
    public void setLastValueSignaled(BValue v) {
        this.set(lastValueSignaled, v, null);
    }

    @Generated
    public void signalNotification(BValue parameter) {
        this.invoke(signalNotification, parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doSignalNotification(BValue value) {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.monitorSourceValid()) {
            this.log.info("The monitor source type is invalid for use with this monitor (" + this.getType() + ")");
            return;
        }
        this.setLastValueSignaled(value.newCopy());
        this.raiseNotification();
    }

    private boolean monitorSourceValid() {
        BObject source = this.getMonitorSource();
        if (source == null) {
            return false;
        }
        return source.getType().is(this.getMonitorSourceType());
    }

    public BObject getMonitorSource() {
        if (this.getSourceToMonitor().isNull()) {
            return null;
        }
        BObject source = this.getSourceToMonitor().get((BObject)this);
        return source;
    }

    private void raiseNotification() {
        Type notificationType = this.getNotificationType();
        if (!notificationType.is(BMonitorNotification.TYPE)) {
            return;
        }
        BMonitorNotification notification = (BMonitorNotification)notificationType.getInstance();
        notification.setMonitorOrd(this.getHandleOrd());
        notification.raise(true);
    }

    protected abstract Type getMonitorSourceType();

    protected abstract Type getNotificationType();
}

