/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.event;

import com.tridium.videoDriver.event.BIVideoEventDetection;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="enableDetection", type="BStatusBoolean", defaultValue="new BStatusBoolean(true, BStatus.nullStatus)", flags=8)
public class BEventDetectionCtrlExt
extends BPointExtension {
    @Generated
    public static final Property enableDetection = BEventDetectionCtrlExt.newProperty((int)8, (BValue)new BStatusBoolean(true, BStatus.nullStatus), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEventDetectionCtrlExt.class);
    protected BStatus previousStatus;
    protected boolean started;
    protected boolean previousValue;
    public static final Context starting = new BasicContext();

    @Generated
    public BStatusBoolean getEnableDetection() {
        return (BStatusBoolean)this.get(enableDetection);
    }

    @Generated
    public void setEnableDetection(BStatusBoolean v) {
        this.set(enableDetection, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecute(BStatusValue out, Context cx) {
        BStatus newStatus = out.getStatus();
        try {
            BControlPoint parentPoint;
            BAbstractProxyExt driverProxy;
            if (this.previousStatus != null && newStatus.isValid() && (driverProxy = (parentPoint = this.getParentPoint()).getProxyExt()) instanceof BProxyExt) {
                if (this.previousStatus.isDown()) {
                    if (((BProxyExt)driverProxy).getTuningPolicy().getWriteOnUp()) {
                        this.eventDetectionControl(null);
                    }
                } else if (this.previousStatus.isDisabled() && ((BProxyExt)driverProxy).getTuningPolicy().getWriteOnEnabled()) {
                    this.eventDetectionControl(null);
                }
            }
        }
        finally {
            this.previousStatus = newStatus;
        }
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (p.equals(enableDetection)) {
                this.eventDetectionControl(null);
            } else {
                super.changed(p, cx);
            }
        } else {
            super.changed(p, cx);
        }
    }

    public void started() throws Exception {
        if (Sys.atSteadyState() && !this.started) {
            this.atSteadyState();
        }
        super.started();
    }

    public void atSteadyState() throws Exception {
        BTuningPolicy tuningPolicy;
        this.started = true;
        BAbstractProxyExt proxyExt = this.getParentPoint().getProxyExt();
        if (proxyExt instanceof BProxyExt && (tuningPolicy = ((BProxyExt)proxyExt).getTuningPolicy()).getWriteOnStart()) {
            this.eventDetectionControl(starting);
        }
        super.atSteadyState();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint && ((BControlPoint)parent).getProxyExt() instanceof BIVideoEventDetection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventDetectionControl(Context cx) {
        BControlPoint parentPoint;
        BAbstractProxyExt driverProxy;
        BStatusBoolean enableDetectionValue = (BStatusBoolean)this.getEnableDetection().newCopy();
        if (enableDetectionValue.getStatus().isValid() && (driverProxy = (parentPoint = this.getParentPoint()).getProxyExt()) instanceof BIVideoEventDetection) {
            BIVideoEventDetection videoEventDetectionObject = (BIVideoEventDetection)driverProxy;
            boolean newDetectionValue = enableDetectionValue.getBoolean();
            try {
                if (cx == starting || this.started) {
                    if (enableDetectionValue.getBoolean()) {
                        videoEventDetectionObject.enableDetection();
                    } else {
                        videoEventDetectionObject.disableDetection();
                    }
                }
            }
            finally {
                this.previousValue = newDetectionValue;
            }
        }
    }
}

