/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.event;

import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="eventType", type="BVideoEventTypesEnum", defaultValue="BVideoEventTypesEnum.nullEvent"), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="isNormal", type="boolean", defaultValue="true"), @NiagaraProperty(name="icon", type="BIcon", defaultValue="BIcon.std(\"alarm.png\")"), @NiagaraProperty(name="metaData", type="BFacets", defaultValue="BFacets.NULL")})
public class BVideoEvent
extends BStruct {
    @Generated
    public static final Property eventType = BVideoEvent.newProperty((int)0, (BValue)BVideoEventTypesEnum.nullEvent, null);
    @Generated
    public static final Property description = BVideoEvent.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property timestamp = BVideoEvent.newProperty((int)0, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property isNormal = BVideoEvent.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property icon = BVideoEvent.newProperty((int)0, (BValue)BIcon.std((String)"alarm.png"), null);
    @Generated
    public static final Property metaData = BVideoEvent.newProperty((int)0, (BValue)BFacets.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoEvent.class);
    public static final String FACET_VIDEO_EVENT_TYPE = "videoEventType";
    public static final String FACET_VIDEO_EVENT_DESCRIPTION = "videoEventDescription";
    public static final String FACET_VIDEO_EVENT_TIMESTAMP = "videoEventTimestamp";
    public static final BFacets EVENT_TIME_STAMP_TO_STRING_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"showTimeZone", (BIDataValue)BBoolean.TRUE);

    @Generated
    public BVideoEventTypesEnum getEventType() {
        return (BVideoEventTypesEnum)this.get(eventType);
    }

    @Generated
    public void setEventType(BVideoEventTypesEnum v) {
        this.set(eventType, (BValue)v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    @Generated
    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    @Generated
    public boolean getIsNormal() {
        return this.getBoolean(isNormal);
    }

    @Generated
    public void setIsNormal(boolean v) {
        this.setBoolean(isNormal, v, null);
    }

    @Generated
    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    @Generated
    public void setIcon(BIcon v) {
        this.set(icon, (BValue)v, null);
    }

    @Generated
    public BFacets getMetaData() {
        return (BFacets)this.get(metaData);
    }

    @Generated
    public void setMetaData(BFacets v) {
        this.set(metaData, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BVideoEvent makeNoEvent() {
        BVideoEvent noEvent = new BVideoEvent();
        noEvent.setEventType(BVideoEventTypesEnum.nullEvent);
        noEvent.setDescription(BVideoEventTypesEnum.nullEvent.getDisplayTag(null));
        noEvent.setIsNormal(true);
        return noEvent;
    }

    public static BVideoEvent makeMotionStarted() {
        BVideoEvent motionStartedEvent = new BVideoEvent();
        motionStartedEvent.setEventType(BVideoEventTypesEnum.motionStarted);
        motionStartedEvent.setDescription(BVideoEventTypesEnum.motionStarted.getDisplayTag(null));
        motionStartedEvent.setIsNormal(false);
        return motionStartedEvent;
    }

    public static BVideoEvent makeMotionStopped() {
        BVideoEvent motionStoppedEvent = new BVideoEvent();
        motionStoppedEvent.setEventType(BVideoEventTypesEnum.motionStopped);
        motionStoppedEvent.setDescription(BVideoEventTypesEnum.motionStopped.getDisplayTag(null));
        motionStoppedEvent.setIsNormal(true);
        return motionStoppedEvent;
    }

    public static BVideoEvent makeEventExpired() {
        BVideoEvent expiredEvent = new BVideoEvent();
        expiredEvent.setEventType(BVideoEventTypesEnum.eventExpired);
        expiredEvent.setDescription(BVideoEventTypesEnum.eventExpired.getDisplayTag(null));
        expiredEvent.setIsNormal(true);
        return expiredEvent;
    }

    public static BVideoEvent makeNormalEvent() {
        BVideoEvent normalEvent = new BVideoEvent();
        normalEvent.setIsNormal(true);
        return normalEvent;
    }

    public static BVideoEvent makeOffNormalEvent() {
        BVideoEvent offNormalEvent = new BVideoEvent();
        offNormalEvent.setIsNormal(false);
        return offNormalEvent;
    }

    public String toString(Context context) {
        BFacets eventTimeStampToStringFacets = EVENT_TIME_STAMP_TO_STRING_FACETS;
        if (context instanceof BFacets) {
            eventTimeStampToStringFacets = BFacets.make((BFacets)eventTimeStampToStringFacets, (BFacets)((BFacets)context));
        }
        return this.getEventType().toString(context) + " <-> " + this.getTimestamp().toString((Context)eventTimeStampToStringFacets) + " <-> " + this.getDescription();
    }

    public void updateProxyAlarmExt(BProxyExt proxy, BOrd noLongerUsed) {
        BControlPoint ctrlPt = proxy.getParentPoint();
        BPointExtension[] ctrlPtExts = ctrlPt.getExtensions();
        for (int i = 0; i < ctrlPtExts.length; ++i) {
            if (!(ctrlPtExts[i] instanceof BAlarmSourceExt)) continue;
            this.updateAlarmExt((BAlarmSourceExt)ctrlPtExts[i], BOrd.NULL);
        }
    }

    protected void updateAlarmExt(BAlarmSourceExt proxyAlarmExt, BOrd eventHyperlinkOrd) {
        this.updateAlarmExtMetaData(proxyAlarmExt);
    }

    protected void updateAlarmExtHyperlinkOrd(BAlarmSourceExt proxyAlarmExt, BOrd eventHyperlinkOrd) {
        BOrd currentHyperlinkOrd;
        if (eventHyperlinkOrd != null && !eventHyperlinkOrd.equals((Object)BOrd.NULL) && (currentHyperlinkOrd = proxyAlarmExt.getHyperlinkOrd()).equals((Object)BOrd.NULL)) {
            proxyAlarmExt.setHyperlinkOrd(eventHyperlinkOrd);
        }
    }

    protected void updateAlarmExtMetaData(BAlarmSourceExt proxyAlarmExt) {
        BFacets alarmMetaData = proxyAlarmExt.getMetaData();
        BFacets videoEventMetaData = this.makeMetaData();
        BFacets updatedAlarmMetaData = BFacets.make((BFacets)alarmMetaData, (BFacets)videoEventMetaData);
        proxyAlarmExt.setMetaData(updatedAlarmMetaData);
    }

    protected BFacets makeMetaData() {
        BIDataValue[] values;
        String[] keys;
        if (this.getTimestamp().isNull()) {
            keys = new String[]{FACET_VIDEO_EVENT_TYPE, FACET_VIDEO_EVENT_DESCRIPTION, FACET_VIDEO_EVENT_TIMESTAMP};
            values = new BIDataValue[]{BDynamicEnum.make((BEnum)this.getEventType()), BString.make((String)this.getDescription()), BAbsTime.NULL};
        } else {
            keys = new String[]{FACET_VIDEO_EVENT_TYPE, FACET_VIDEO_EVENT_DESCRIPTION, FACET_VIDEO_EVENT_TIMESTAMP};
            values = new BIDataValue[]{BDynamicEnum.make((BEnum)this.getEventType()), BString.make((String)this.getDescription()), this.getTimestamp()};
        }
        BFacets retVal = BFacets.make((String[])keys, (BIDataValue[])values);
        retVal = BFacets.make((BFacets)retVal, (BFacets)this.getMetaData());
        return retVal;
    }
}

