/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AuthHeaderParser {
    private static final String WHITESPACE = new String(" \t\r\n");

    public static Map<String, String> parseWWWAuthHeader(String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        ParseState currentstate = ParseState.PROLOGSPACE;
        char[] valchars = value.toCharArray();
        valchars = Arrays.copyOf(valchars, valchars.length + 1);
        int mark = 0;
        String key = null;
        block10: for (int currentIndex = 0; currentIndex < valchars.length; ++currentIndex) {
            char currentChar = valchars[currentIndex];
            switch (currentstate) {
                case PROLOGSPACE: {
                    if (WHITESPACE.indexOf(currentChar) >= 0) continue block10;
                    mark = currentIndex;
                    currentstate = ParseState.PROLOGWORD;
                    continue block10;
                }
                case PROLOGWORD: {
                    if (WHITESPACE.indexOf(currentChar) < 0) continue block10;
                    result.put(":auth-scheme", new String(valchars, mark, currentIndex - mark));
                    currentstate = ParseState.SEPARATOR;
                    continue block10;
                }
                case SEPARATOR: {
                    if (currentChar == '\u0000') {
                        currentstate = ParseState.COMPLETE;
                        continue block10;
                    }
                    if (currentChar == ',' || WHITESPACE.indexOf(currentChar) >= 0) continue block10;
                    mark = currentIndex;
                    currentstate = ParseState.KEY;
                    continue block10;
                }
                case KEY: {
                    if (currentChar != '=') continue block10;
                    key = new String(valchars, mark, currentIndex - mark);
                    currentstate = ParseState.KEYVALGAP;
                    continue block10;
                }
                case KEYVALGAP: {
                    if (currentChar == '=') continue block10;
                    mark = 0;
                    if (currentChar == '\"') {
                        currentstate = ParseState.QUOTEDVALUE;
                        mark = currentIndex + 1;
                        continue block10;
                    }
                    currentstate = ParseState.VALUE;
                    mark = currentIndex;
                    continue block10;
                }
                case VALUE: {
                    if (currentChar != ',' && currentChar != '\u0000' && WHITESPACE.indexOf(currentChar) < 0) continue block10;
                    result.put(key, new String(valchars, mark, currentIndex - mark));
                    if (currentIndex + 1 == valchars.length) {
                        currentstate = ParseState.COMPLETE;
                        continue block10;
                    }
                    currentstate = ParseState.SEPARATOR;
                    continue block10;
                }
                case QUOTEDVALUE: {
                    if (currentChar != '\"') continue block10;
                    result.put(key, new String(valchars, mark, currentIndex - mark));
                    currentstate = ParseState.SEPARATOR;
                    continue block10;
                }
                case COMPLETE: {
                    throw new IllegalStateException("There should be no characters after COMPLETE");
                }
            }
        }
        if (currentstate != ParseState.COMPLETE) {
            throw new IllegalStateException("Unexpected parse path ended before completion (ended at " + (Object)((Object)currentstate) + ").");
        }
        return result;
    }

    private static enum ParseState {
        PROLOGSPACE,
        PROLOGWORD,
        KEY,
        KEYVALGAP,
        VALUE,
        QUOTEDVALUE,
        SEPARATOR,
        COMPLETE;

    }
}

