/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream;

import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.HttpResponseHeaderUtil;
import com.tridium.videoDriver.videoStream.VideoStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.net.UrlConnection;

public class HttpVideoStream
extends VideoStream {
    public UrlConnection urlVideoStreamConnection;
    public static Logger log = Logger.getLogger("videoDriver.httpVideoStream");

    public HttpVideoStream(BPlaybackParams playbackParams, UrlConnection urlVideoStreamConnection) throws IOException {
        super(HttpResponseHeaderUtil.encodeHttpResponseHeader(playbackParams, urlVideoStreamConnection), urlVideoStreamConnection.getInputStream());
        this.urlVideoStreamConnection = urlVideoStreamConnection;
    }

    @Override
    public void closeVideoStream() throws IOException {
        if (!this.urlVideoStreamConnection.isOpen() && log.isLoggable(Level.FINE)) {
            log.fine("Close: URL Connection Not Open");
        }
        if (this.urlVideoStreamConnection != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("\n  Closing underlying url stream connection.\n  urlVideoStreamConnection.isOpen()=" + this.urlVideoStreamConnection.isOpen());
            }
            this.urlVideoStreamConnection.close();
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("There is no underlying url stream connection to close.");
        }
    }
}

