/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.decoder;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class HttpStatusLineHelper {
    protected InputStream httpIn;
    protected String version;
    protected int statusCode;
    protected String message;

    public HttpStatusLineHelper(InputStream httpIn) throws IOException {
        this.httpIn = httpIn;
        this.readVersion();
        this.readStatusCode();
        this.readMessage();
    }

    protected void readVersion() throws IOException {
        StringBuilder sbuf = new StringBuilder(8);
        int ch = this.httpIn.read();
        while (ch != -1 && ch != 32) {
            sbuf.append((char)ch);
            ch = this.httpIn.read();
        }
        if (ch == -1) {
            throw new EOFException("End of input while reading version.");
        }
        this.version = sbuf.toString();
    }

    public String getVersion() {
        return this.version;
    }

    protected void readStatusCode() throws IOException {
        StringBuilder sbuf = new StringBuilder(3);
        int ch = this.httpIn.read();
        while (ch != -1 && ch != 32) {
            sbuf.append((char)ch);
            ch = this.httpIn.read();
        }
        if (ch == -1) {
            throw new EOFException("End of input while reading status code.");
        }
        this.statusCode = Integer.parseInt(sbuf.toString());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    protected void readMessage() throws IOException {
        StringBuilder sbuf = new StringBuilder(25);
        int ch = this.httpIn.read();
        while (ch != -1 && ch != 13) {
            sbuf.append((char)ch);
            ch = this.httpIn.read();
        }
        if (ch == -1) {
            throw new EOFException("End of input while reading reason phrase.");
        }
        ch = this.httpIn.read();
        this.message = sbuf.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.version + " " + this.statusCode + " " + this.message;
    }
}

