/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.ClientSideVideoReceiver;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComplex;
import javax.baja.util.Queue;

public class ClientVideoInputStream
extends InputStream {
    protected static final int _32K = 32768;
    protected static final int _512K = 524288;
    protected static final int NUM_MOST_RECENT_PACKET_SIZES = 10;
    protected int[] mostRecentPacketSizes = new int[10];
    protected int mostRecentPacketId = 0;
    protected boolean mostRecentPacketAlgorithmWarmedUp = false;
    protected Queue byteArrayQueue;
    protected byte[] buffer;
    protected int bufferPos;
    protected int available;
    protected Logger log = Logger.getLogger("fox.clientInputStream");
    protected Logger readLog = Logger.getLogger("fox.clientInputStream.read");
    protected FoxVideoStream foxVideoStream;
    protected BPlaybackParams updatedPlaybackParams = null;
    protected boolean hasReceivedAnyBytes = false;
    protected ClientSideVideoReceiver videoReceiver;
    protected boolean closed;
    protected int videoStreamId;
    protected volatile Thread threadInReadMethod1;
    protected volatile Thread threadInReadMethod3;
    protected boolean streamPaused;
    protected Object streamPausedMonitor = new Object();
    protected IVideoDestination videoDestination;

    protected ClientVideoInputStream(ClientSideVideoReceiver videoReceiver, int videoStreamId, IVideoDestination videoDestination, FoxVideoStream foxVideoStream) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Opened a fox client video input stream.");
        }
        this.videoReceiver = videoReceiver;
        this.closed = false;
        this.videoStreamId = videoStreamId;
        this.byteArrayQueue = new Queue();
        this.buffer = null;
        this.available = 0;
        this.videoDestination = videoDestination;
        this.foxVideoStream = foxVideoStream;
        this.streamPaused = false;
    }

    protected ClientVideoInputStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reopen() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Re-opened a fox client video input stream.");
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.byteArrayQueue = new Queue();
            this.buffer = null;
            this.bufferPos = 0;
            this.available = 0;
            this.closed = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Closed a fox client video input stream.");
        }
        if (!this.closed) {
            this.closed = true;
            if (this.threadInReadMethod1 != null) {
                try {
                    this.threadInReadMethod1.interrupt();
                }
                catch (NullPointerException npe) {
                    this.log.log(Level.INFO, "Multi-threaded race condition 1", npe);
                }
            }
            if (this.threadInReadMethod3 != null) {
                try {
                    this.threadInReadMethod3.interrupt();
                }
                catch (NullPointerException npe) {
                    this.log.log(Level.INFO, "Multi-threaded race condition 3", npe);
                }
            }
            try {
                this.videoReceiver.clientVideoInputStreamClosed(this);
            }
            catch (Exception e) {
                throw new IOException("Unable to close ClientVideoInputStream: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.readLog.isLoggable(Level.FINE)) {
            this.readLog.fine("Read 1 byte>");
        }
        if (this.closed) {
            throw new IOException("ClientVideoInputStream closed. Stream Id = " + this.getVideoStreamId() + " Client id=" + this.videoReceiver.getVideoClientId());
        }
        Queue queue = this.byteArrayQueue;
        synchronized (queue) {
            int n;
            try {
                this.threadInReadMethod1 = Thread.currentThread();
                while (this.buffer == null || this.bufferPos >= this.buffer.length) {
                    try {
                        this.buffer = (byte[])this.byteArrayQueue.dequeue(-1);
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException(ie.getLocalizedMessage());
                    }
                    this.bufferPos = 0;
                }
                --this.available;
                Object object = this.streamPausedMonitor;
                synchronized (object) {
                    if (this.streamPaused && this.available <= 4096) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Sending request to Niagara video server to RESUME videoStreamId=" + this.videoStreamId);
                        }
                        try {
                            this.videoReceiver.getFoxVideoChannel().resumeVideoStream(this.videoReceiver.getVideoClientId(), this.videoStreamId);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Unable to resume video stream", e);
                            throw new IOException("Unable to resume video stream: " + e);
                        }
                        this.streamPaused = false;
                    }
                }
                n = this.buffer[this.bufferPos++] & 0xFF;
                this.threadInReadMethod1 = null;
            }
            catch (Throwable throwable) {
                this.threadInReadMethod1 = null;
                throw throwable;
            }
            return n;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readLog.isLoggable(Level.FINE)) {
            this.readLog.fine("Read(byte[], " + off + "," + len);
        }
        if (this.closed) {
            throw new IOException("ClientVideoInputStream closed. Stream Id = " + this.getVideoStreamId() + " Client id=" + this.videoReceiver.getVideoClientId());
        }
        Queue queue = this.byteArrayQueue;
        synchronized (queue) {
            int availableBytesInBuffer;
            block34: {
                block33: {
                    Object object;
                    int n;
                    try {
                        this.threadInReadMethod3 = Thread.currentThread();
                        if (this.buffer == null || this.bufferPos >= this.buffer.length) {
                            try {
                                this.buffer = (byte[])this.byteArrayQueue.dequeue(-1);
                            }
                            catch (InterruptedException ie) {
                                throw new InterruptedIOException(ie.getLocalizedMessage());
                            }
                            this.bufferPos = 0;
                        }
                        if ((availableBytesInBuffer = this.buffer.length - this.bufferPos) < len) break block33;
                        System.arraycopy(this.buffer, this.bufferPos, b, off, len);
                        this.bufferPos += len;
                        this.available -= len;
                        if (this.readLog.isLoggable(Level.FINE)) {
                            this.readLog.fine("Returning len=" + len);
                        }
                        n = len;
                        this.threadInReadMethod3 = null;
                        object = this.streamPausedMonitor;
                    }
                    catch (Throwable throwable) {
                        this.threadInReadMethod3 = null;
                        Object object2 = this.streamPausedMonitor;
                        synchronized (object2) {
                            if (!this.streamPaused) throw throwable;
                            if (this.available > 4096) throw throwable;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Sending request to Niagara video server to RESUME videoStreamId=" + this.videoStreamId);
                            }
                            try {
                                this.videoReceiver.getFoxVideoChannel().resumeVideoStream(this.videoReceiver.getVideoClientId(), this.videoStreamId);
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, "Unable to resume video stream", e);
                                throw new IOException("Unable to resume video stream: " + e);
                            }
                            this.streamPaused = false;
                            throw throwable;
                        }
                    }
                    synchronized (object) {
                        if (!this.streamPaused) return n;
                        if (this.available > 4096) return n;
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Sending request to Niagara video server to RESUME videoStreamId=" + this.videoStreamId);
                        }
                        try {
                            this.videoReceiver.getFoxVideoChannel().resumeVideoStream(this.videoReceiver.getVideoClientId(), this.videoStreamId);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Unable to resume video stream", e);
                            throw new IOException("Unable to resume video stream: " + e);
                        }
                        this.streamPaused = false;
                        return n;
                    }
                }
                System.arraycopy(this.buffer, this.bufferPos, b, off, availableBytesInBuffer);
                this.bufferPos += availableBytesInBuffer;
                this.available -= availableBytesInBuffer;
                if (this.byteArrayQueue.size() <= 0) break block34;
                int n = availableBytesInBuffer + this.read(b, off + availableBytesInBuffer, len - availableBytesInBuffer);
                this.threadInReadMethod3 = null;
                Object object = this.streamPausedMonitor;
                synchronized (object) {
                    if (!this.streamPaused) return n;
                    if (this.available > 4096) return n;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Sending request to Niagara video server to RESUME videoStreamId=" + this.videoStreamId);
                    }
                    try {
                        this.videoReceiver.getFoxVideoChannel().resumeVideoStream(this.videoReceiver.getVideoClientId(), this.videoStreamId);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Unable to resume video stream", e);
                        throw new IOException("Unable to resume video stream: " + e);
                    }
                    this.streamPaused = false;
                    return n;
                }
            }
            if (this.readLog.isLoggable(Level.FINE)) {
                this.readLog.fine("Returning availableBytesInBuffer=" + availableBytesInBuffer);
            }
            int n = availableBytesInBuffer;
            this.threadInReadMethod3 = null;
            Object object = this.streamPausedMonitor;
            synchronized (object) {
                if (!this.streamPaused) return n;
                if (this.available > 4096) return n;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Sending request to Niagara video server to RESUME videoStreamId=" + this.videoStreamId);
                }
                try {
                    this.videoReceiver.getFoxVideoChannel().resumeVideoStream(this.videoReceiver.getVideoClientId(), this.videoStreamId);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Unable to resume video stream", e);
                    throw new IOException("Unable to resume video stream: " + e);
                }
                this.streamPaused = false;
                return n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveFromStation(byte[] videoFromStation, BPlaybackParams pbp) {
        if (!this.hasReceivedAnyBytes && this.foxVideoStream != null) {
            try {
                BPlaybackParams updatedPlaybackParams = pbp;
                if (pbp == null) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("{" + this.videoStreamId + "} receiveFromStation() - request updatedPlaybackParams");
                    }
                    updatedPlaybackParams = this.videoReceiver.foxVideoChannel.getPlaybackParamsForStream(this.videoReceiver.videoClientId, this.videoStreamId);
                } else if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("{" + this.videoStreamId + "} receiveFromStation() playBack passed in call ");
                }
                if (updatedPlaybackParams != null) {
                    this.foxVideoStream.getPlaybackParams().copyFrom((BComplex)updatedPlaybackParams);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Caught exception while getting updated playback params.", e);
            }
            finally {
                this.videoDestination.receiveVideoStream(this.foxVideoStream);
                this.hasReceivedAnyBytes = true;
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("ClientVideoInputStream.receiveFromStation.");
            this.log.fine("  log.iclosed=" + this.closed);
            IVideoDecoder videoDecoder = this.videoDestination.getVideoDecoder();
            if (videoDecoder == null) {
                this.log.fine("  videoDecocer is null!!");
            } else {
                this.log.fine("  videoDecocer.isFinished()=" + videoDecoder.isFinished());
            }
        }
        if (videoFromStation != null && videoFromStation.length > 0) {
            Queue queue = this.byteArrayQueue;
            synchronized (queue) {
                this.byteArrayQueue.enqueue((Object)videoFromStation);
                this.available += videoFromStation.length;
            }
            this.updatePacketSizeAvg(videoFromStation.length);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("ClientVideoInputStream.receiveFromStation done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePacketSizeAvg(int newestPacketSize) {
        int[] nArray = this.mostRecentPacketSizes;
        synchronized (this.mostRecentPacketSizes) {
            this.mostRecentPacketSizes[this.mostRecentPacketId] = newestPacketSize;
            ++this.mostRecentPacketId;
            if (this.mostRecentPacketId >= 10) {
                this.mostRecentPacketId = 0;
                this.mostRecentPacketAlgorithmWarmedUp = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected long computeAverageRecentPacketSize() throws TooEarlyException {
        int[] nArray = this.mostRecentPacketSizes;
        synchronized (this.mostRecentPacketSizes) {
            if (this.mostRecentPacketAlgorithmWarmedUp) {
                long sumOfMostRecentPacketSizes = 0L;
                for (int i = 0; i < this.mostRecentPacketSizes.length; ++i) {
                    sumOfMostRecentPacketSizes += (long)this.mostRecentPacketSizes[i];
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sumOfMostRecentPacketSizes / (long)this.mostRecentPacketSizes.length;
            }
            if (this.mostRecentPacketId > 0) {
                long sumOfMostRecentPacketSizes = 0L;
                for (int i = 0; i < this.mostRecentPacketId; ++i) {
                    sumOfMostRecentPacketSizes += (long)this.mostRecentPacketSizes[i];
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sumOfMostRecentPacketSizes / (long)this.mostRecentPacketId;
            }
            throw new TooEarlyException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Queue queue = this.byteArrayQueue;
        synchronized (queue) {
            return this.available;
        }
    }

    public boolean isBackingUp() throws IOException {
        int avail = this.available();
        try {
            boolean retVal;
            long threshold;
            boolean isDecoding;
            long avgFrameSize = this.computeAverageRecentPacketSize();
            avgFrameSize = this.computeAverageRecentPacketSize();
            if (this.videoDestination == null) {
                isDecoding = false;
            } else {
                boolean bl = isDecoding = this.videoDestination.getVideoDecoder() != null;
            }
            if (isDecoding) {
                threshold = avgFrameSize * 100L;
                if (threshold < 524288L) {
                    threshold = 524288L;
                }
            } else {
                threshold = avgFrameSize * 4L;
                if (threshold < 32768L) {
                    threshold = 32768L;
                }
            }
            boolean bl = retVal = (long)avail > threshold;
            if (retVal) {
                System.out.println(">> Avail = " + avail + " avg = " + avgFrameSize + " decoder=" + this.videoDestination.getVideoDecoder());
            }
            return retVal;
        }
        catch (TooEarlyException e) {
            return false;
        }
    }

    public int getVideoStreamId() {
        return this.videoStreamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamPaused() {
        Object object = this.streamPausedMonitor;
        synchronized (object) {
            this.streamPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.streamPausedMonitor;
        synchronized (object) {
            return this.streamPaused;
        }
    }

    public BPlaybackParams getUpdatedPlaybackParams() {
        return this.updatedPlaybackParams;
    }

    public void setUpdatedPlaybackParams(BPlaybackParams updatedPlaybackParams) {
        this.updatedPlaybackParams = updatedPlaybackParams;
    }

    public static class TooEarlyException
    extends Exception {
    }
}

