/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.videoDriver.videoStream.fox.StationSideVideoSession;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Sys;

public class VideoSessionsWatchdog
implements Runnable {
    protected boolean running = true;
    protected Hashtable<StationSideVideoSession, StationSideVideoSession> videoSessionsToWatch = new Hashtable();
    protected Thread watchdogThread;
    public static final int THIRTY_SECONDS_WORTH_OF_TICKS = 30000;
    protected static Logger watchDogLog = Logger.getLogger("fox.stationVideoSessions.watchdog");

    public void stopWatchdog() {
        this.running = false;
        if (this.watchdogThread != null) {
            this.watchdogThread.interrupt();
        }
    }

    public void startWatchdog(String client) {
        if (this.watchdogThread == null || !this.watchdogThread.isAlive()) {
            this.watchdogThread = new Thread((Runnable)this, "Fox:VideoSession:Watchdog:" + client);
            this.watchdogThread.start();
        }
    }

    public void startWatchingSession(StationSideVideoSession videoSession) {
        if (watchDogLog.isLoggable(Level.FINE)) {
            videoSession.trace(watchDogLog, "start watching");
        }
        this.videoSessionsToWatch.put(videoSession, videoSession);
    }

    public void stopWatchingSession(StationSideVideoSession videoSession) {
        if (watchDogLog.isLoggable(Level.FINE)) {
            videoSession.trace(watchDogLog, "stop watching");
        }
        this.videoSessionsToWatch.remove(videoSession);
    }

    @Override
    public void run() {
        if (watchDogLog.isLoggable(Level.FINE)) {
            watchDogLog.fine("run()");
        }
        while (this.running && Sys.getStation().isRunning()) {
            try {
                Thread.sleep(30000L);
                Enumeration<StationSideVideoSession> videoSessionsEnumeration = this.videoSessionsToWatch.elements();
                while (videoSessionsEnumeration.hasMoreElements()) {
                    StationSideVideoSession videoSessionToWatch = videoSessionsEnumeration.nextElement();
                    if (!this.videoSessionsToWatch.containsKey(videoSessionToWatch)) continue;
                    videoSessionToWatch.watchdog(watchDogLog);
                }
            }
            catch (InterruptedException ie) {
                if (!watchDogLog.isLoggable(Level.FINE)) continue;
                watchDogLog.log(Level.FINE, "Interrupted!", ie);
            }
            catch (Exception e) {
                watchDogLog.log(Level.SEVERE, "Exception in VideoSessionsWatchdog.run", e);
            }
        }
    }
}

