/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.authn.BLegacyDigestAuthenticationScheme;
import com.tridium.authn.BSSOConfiguration;
import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.session.AuditInfo;
import com.tridium.session.NiagaraSession;
import com.tridium.session.NiagaraSessionSupplier;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.session.SuperSessionPrincipal;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BIRestrictedComponent;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticationSchemes", type="BAuthenticationSchemeFolder", defaultValue="new BAuthenticationSchemeFolder()"), @NiagaraProperty(name="ssoConfiguration", type="BSSOConfiguration", defaultValue="new BSSOConfiguration()"), @NiagaraProperty(name="debug", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="strictAuthentication", type="boolean", defaultValue="false"), @NiagaraProperty(name="defaultAuthenticationScheme", type="String", defaultValue="DigestScheme", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"wbutil:AuthenticationSchemeFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:AuthenticationSchemeEditor\"))")})})
public final class BAuthenticationService
extends BComponent
implements BIService,
BIRestrictedComponent {
    @Generated
    public static final Property authenticationSchemes = BAuthenticationService.newProperty(0, new BAuthenticationSchemeFolder(), null);
    @Generated
    public static final Property ssoConfiguration = BAuthenticationService.newProperty(0, new BSSOConfiguration(), null);
    @Generated
    public static final Property debug = BAuthenticationService.newProperty(4, false, null);
    @Generated
    public static final Property strictAuthentication = BAuthenticationService.newProperty(0, false, null);
    @Generated
    public static final Property defaultAuthenticationScheme = BAuthenticationService.newProperty(0, "DigestScheme", BFacets.make("fieldEditor", BString.make("wbutil:AuthenticationSchemeFE"), "uxFieldEditor", BString.make("webEditors:AuthenticationSchemeEditor")));
    @Generated
    public static final Type TYPE = Sys.loadType(BAuthenticationService.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std("navOnly/authenticationService.png");

    @Generated
    public BAuthenticationSchemeFolder getAuthenticationSchemes() {
        return (BAuthenticationSchemeFolder)this.get(authenticationSchemes);
    }

    @Generated
    public void setAuthenticationSchemes(BAuthenticationSchemeFolder v) {
        this.set(authenticationSchemes, (BValue)v, null);
    }

    @Generated
    public BSSOConfiguration getSsoConfiguration() {
        return (BSSOConfiguration)this.get(ssoConfiguration);
    }

    @Generated
    public void setSsoConfiguration(BSSOConfiguration v) {
        this.set(ssoConfiguration, (BValue)v, null);
    }

    @Generated
    public boolean getDebug() {
        return this.getBoolean(debug);
    }

    @Generated
    public void setDebug(boolean v) {
        this.setBoolean(debug, v, null);
    }

    @Generated
    public boolean getStrictAuthentication() {
        return this.getBoolean(strictAuthentication);
    }

    @Generated
    public void setStrictAuthentication(boolean v) {
        this.setBoolean(strictAuthentication, v, null);
    }

    @Generated
    public String getDefaultAuthenticationScheme() {
        return this.getString(defaultAuthenticationScheme);
    }

    @Generated
    public void setDefaultAuthenticationScheme(String v) {
        this.setString(defaultAuthenticationScheme, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAuthenticationService() {
        this.getAuthenticationSchemes().add("DigestScheme", new BDigestAuthenticationScheme());
        this.getAuthenticationSchemes().add("AXDigestScheme", new BLegacyDigestAuthenticationScheme());
    }

    @Override
    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    @Override
    public void serviceStarted() throws Exception {
        if (this.getDebug()) {
            String message = "DEBUG mode is enabled. This should only be used for troubleshooting and should be turned off as soon as possible";
            AuthenticationUtil.debug(Level.WARNING, message, null);
        }
        this.setAutoSSO();
    }

    @Override
    public void serviceStopped() throws Exception {
    }

    public static BAuthenticationService getService() {
        return (BAuthenticationService)Sys.getService(TYPE);
    }

    @Override
    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser(this, cx);
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    public BUser authenticate(NiagaraSession session, BUser requestedUser, CallbackHandler handler, BAuthenticationScheme authnScheme) {
        return this.authenticate(new BasicNiagaraSessionSupplier(session), requestedUser, handler, authnScheme);
    }

    public BUser authenticate(NiagaraSessionSupplier sessionSupplier, BUser requestedUser, CallbackHandler handler, BAuthenticationScheme authnScheme) throws AuthenticationException {
        BUserService userService = (BUserService)Sys.getService(BUserService.TYPE);
        NiagaraSession session = sessionSupplier.get(false);
        BAuthenticationScheme scheme = session != null && session.isLegacyConnection() ? new BLegacyDigestAuthenticationScheme() : (authnScheme != null ? authnScheme : userService.getAuthenticationSchemeForUser(requestedUser));
        if (session != null && SessionManager.isAuthenticated(session.getSuperId())) {
            String superSessionId = session.getSuperId();
            return AccessController.doPrivileged(() -> SessionManager.getAuthenticatedUserFromSession(superSessionId));
        }
        try {
            LoginContext lc = scheme.login(handler);
            BUser user = null;
            Subject subject = lc.getSubject();
            if (subject != null) {
                Set<BUser> set = subject.getPrincipals(BUser.class);
                if (!set.isEmpty()) {
                    for (BUser principal : set) {
                        if (principal == null) continue;
                        user = principal;
                        break;
                    }
                }
                if (user != null) {
                    NiagaraSuperSession superSession;
                    if (session == null) {
                        session = sessionSupplier.get(true);
                    }
                    if ((superSession = SessionManager.getNiagaraSuperSession(session)) != null) {
                        AccessController.doPrivileged(() -> {
                            Set<SuperSessionPrincipal> sspSet = subject.getPrincipals(SuperSessionPrincipal.class);
                            if (!sspSet.isEmpty()) {
                                AuthenticationUtil.debug(Level.SEVERE, "an invalid super session principal was found with the subject and is being removed", null);
                                for (SuperSessionPrincipal principal : sspSet) {
                                    subject.getPrincipals().remove(principal);
                                }
                            }
                            subject.getPrincipals().add(new SuperSessionPrincipal(superSession));
                            return null;
                        });
                    }
                }
                AccessController.doPrivileged(() -> {
                    subject.setReadOnly();
                    return null;
                });
            }
            if (user == null) {
                String message = "Authentication failed for scheme <" + scheme.getSchemeName() + ">, butthe corresponding LoginModule did not throw a FailedLoginException. Failed LoginModule logins must *always* throw a FailedLoginException.";
                AuthenticationUtil.debug(Level.SEVERE, message, null);
            }
            NiagaraSession finalSession = session;
            AccessController.doPrivileged(() -> {
                finalSession.setAuthenticated(subject);
                return null;
            });
            BAuthenticationService.processLoginAttempt(true, user, session);
            return user;
        }
        catch (NiagaraFailedLoginException e) {
            String username = e.getUsername();
            BUser user = userService.getUser(SlotPath.unescape(username));
            if (user != null) {
                BAuthenticationService.processLoginAttempt(false, user, sessionSupplier.getAuditInfo());
            }
            AuthenticationUtil.debug(Level.WARNING, "Authentication failed due to invalid user credentials. Cause is: ", e);
            throw new AuthenticationException("Login Failed", e, null);
        }
        catch (Exception e) {
            AuthenticationUtil.debug(Level.SEVERE, "Authentication failed. Cause is: ", e);
            throw new AuthenticationException("Login Failed", e, null);
        }
    }

    public List<BAuthenticationScheme> getSupportedSchemes() {
        return this.getAuthenticationSchemes().getAuthenticationSchemes();
    }

    public List<BAuthenticationScheme> getRemoteSchemes() {
        return this.getSupportedSchemes().stream().filter(BAuthenticationScheme::supportsRemoteUsers).collect(Collectors.toList());
    }

    public BAuthenticationScheme getAuthenticationScheme(String schemeName) {
        BValue scheme = this.getAuthenticationSchemes().get(schemeName);
        if (scheme == null || !scheme.getType().is(BAuthenticationScheme.TYPE)) {
            throw new AuthenticationException("No BAuthenticationScheme corresponding to name <" + schemeName + "> found.");
        }
        return (BAuthenticationScheme)scheme;
    }

    public BSSOAuthenticationScheme getSSOAuthenticationScheme(String schemeName) {
        BValue scheme = this.getAuthenticationSchemes().get(schemeName);
        if (scheme == null || !scheme.getType().is(BSSOAuthenticationScheme.TYPE)) {
            return null;
        }
        return (BSSOAuthenticationScheme)scheme;
    }

    public BAuthenticationScheme getDefaultSchemeWithAgent(Class<? extends BIObject> cls) {
        Property[] properties;
        String defaultSchemeName = this.getDefaultAuthenticationScheme();
        try {
            BAuthenticationScheme scheme = this.getAuthenticationScheme(defaultSchemeName);
            if (scheme.getAgentOn(cls) != null) {
                return scheme;
            }
            AuthenticationUtil.debug(Level.FINE, String.format("Default authentication scheme <%s> does not have requested agent <%s>.", defaultSchemeName, cls.getName()), null);
        }
        catch (Exception e) {
            AuthenticationUtil.debug(Level.WARNING, String.format("Default authentication scheme <%s> not found.", defaultSchemeName), e);
        }
        BAuthenticationScheme firstSchemeWithAgent = null;
        BAuthenticationSchemeFolder schemeFolder = this.getAuthenticationSchemes();
        for (Property property : properties = schemeFolder.getPropertiesArray()) {
            BValue scheme = schemeFolder.get(property);
            if (scheme instanceof BDigestAuthenticationScheme) {
                return (BAuthenticationScheme)scheme;
            }
            if (firstSchemeWithAgent != null || !(scheme instanceof BAuthenticationScheme) || ((BAuthenticationScheme)scheme).getAgentOn(cls) == null) continue;
            firstSchemeWithAgent = (BAuthenticationScheme)scheme;
        }
        return firstSchemeWithAgent;
    }

    public List<BAuthenticationScheme> getSchemesWithAgent(Class<? extends BIObject> cls) {
        Property[] properties;
        ArrayList<BAuthenticationScheme> schemes = new ArrayList<BAuthenticationScheme>();
        BAuthenticationSchemeFolder schemeFolder = this.getAuthenticationSchemes();
        for (Property property : properties = schemeFolder.getPropertiesArray()) {
            BValue scheme = schemeFolder.get(property);
            if (!(scheme instanceof BAuthenticationScheme) || ((BAuthenticationScheme)scheme).getAgentOn(cls) == null) continue;
            schemes.add((BAuthenticationScheme)scheme);
        }
        return schemes;
    }

    void setAutoSSO() {
        BAuthenticationScheme[] schemes = this.getAuthenticationSchemes().getChildren(BSSOAuthenticationScheme.class);
        Property autoSSO = BSSOConfiguration.autoAttemptSingleSignOn;
        if (schemes.length == 1) {
            this.getSsoConfiguration().setFlags(autoSSO, this.getSsoConfiguration().getFlags(autoSSO) & 0xFFFFFFFE);
        } else {
            this.getSsoConfiguration().setAutoAttemptSingleSignOn(false);
            this.getSsoConfiguration().setFlags(autoSSO, this.getSsoConfiguration().getFlags(autoSSO) | 1);
        }
    }

    private static void processLoginAttempt(boolean loginSuccessful, BUser user, AuditInfo auditInfo) {
        BUserService userService = BUserService.getService();
        if (loginSuccessful) {
            user.authenticateOk(userService);
        } else {
            user.authenticateFailed(userService);
        }
        BAuthenticationService.auditLoginAttempt(loginSuccessful, user, auditInfo);
    }

    private static void auditLoginAttempt(boolean loginSuccessful, BUser user, AuditInfo auditInfo) {
        if (auditInfo == null) {
            return;
        }
        try {
            AuditEvent event;
            Auditor auditor = Sys.getAuditor();
            if (auditor != null && (event = auditInfo.makeAuditEvent(loginSuccessful ? "Login" : "Login Failure", user)) != null) {
                auditor.audit(event);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    private static class BasicNiagaraSessionSupplier
    implements NiagaraSessionSupplier {
        NiagaraSession session;

        public BasicNiagaraSessionSupplier(NiagaraSession session) {
            this.session = session;
        }

        @Override
        public NiagaraSession get(boolean create) {
            return this.session;
        }

        @Override
        public AuditInfo getAuditInfo() {
            return this.session;
        }
    }
}

