/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecurityInitializer;
import java.util.Locale;
import javax.baja.util.Lexicon;

public enum LoginFailureCause {
    GENERIC("login.failure.generic"),
    ILLEGAL_NETWORK_USER_RESET("login.failure.passwordReset.illegalNetworkUser"),
    INSECURE_PASSWORD_RESET("login.failure.passwordReset.secureRequired"),
    PASSWORD_RESET_REQUIRED("login.failure.passwordReset.required"),
    SECURE_CONNECTION_REQUIRED("login.failure.secureConnectionRequired"),
    LOGIN_INTERFACE_NOT_SUPPORTED("login.failure.interfaceNotSupported"),
    CONCURRENT_SESSION("login.failure.concurrentSession", "login.failed.sessionDisconnected"),
    INVALID_SSO_SCHEME("login.failure.invalidSSOScheme"),
    SSO_FAILURE("login.failure.ssoFailed"),
    SESSION_TIMEOUT("login.failure.sessionTimeout", "login.failed.sessionDisconnected"),
    CLIENT_CERT_FAILURE("login.failure.clientCert"),
    FIPS_PASSWORD_LENGTH("login.failure.fipsPasswordLength", new Object[]{SecurityInitializer.getInstance().isFips() ? Integer.valueOf(SecurityInitializer.getInstance().getFipsInformation().getFipsVersion()) : "?", SecurityInitializer.getInstance().isFips() ? Integer.valueOf(SecurityInitializer.getInstance().getFipsInformation().getNiagaraVersion()) : "?", PasswordStrength.MINIMUM_ALLOWED_LENGTH});

    private String bajaLexiconKey;
    private String bajaTitleLexiconKey;
    private Object[] lexiconArgs;

    private LoginFailureCause(String bajaLexiconKey) {
        this(bajaLexiconKey, "login.failed");
    }

    private LoginFailureCause(String bajaLexiconKey, String bajaTitleLexiconKey) {
        this(bajaLexiconKey, bajaTitleLexiconKey, new Object[0]);
    }

    private LoginFailureCause(String bajaLexiconKey, Object[] lexiconArgs) {
        this(bajaLexiconKey, "login.failed", lexiconArgs);
    }

    private LoginFailureCause(String bajaLexiconKey, String bajaTitleLexiconKey, Object[] lexiconArgs) {
        this.bajaLexiconKey = bajaLexiconKey;
        this.bajaTitleLexiconKey = bajaTitleLexiconKey;
        this.lexiconArgs = lexiconArgs;
    }

    public String getDefaultFailureMessage(Locale locale) {
        return Lexicon.make("baja", locale).getText(this.bajaLexiconKey, this.lexiconArgs);
    }

    public String getDefaultFailureMessage() {
        return Lexicon.make("baja").getText(this.bajaLexiconKey, this.lexiconArgs);
    }

    public String getDefaultFailureTitle(Locale locale) {
        return Lexicon.make("baja", locale).get(this.bajaTitleLexiconKey);
    }

    public String getDefaultFailureTitle() {
        return Lexicon.make("baja").get(this.bajaTitleLexiconKey);
    }
}

