/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.data;

import com.tridium.data.BDataTable;
import com.tridium.data.DataCodec;
import java.io.DataInput;
import java.io.IOException;
import javax.baja.data.BIDataTable;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataTypes;
import javax.baja.sys.BFacets;
import javax.baja.sys.Type;

public class DataTableDecoder
implements DataCodec {
    public static BIDataTable<?> decode(DataInput in) throws IOException {
        BDataTable table = new BDataTable();
        int start = in.readInt();
        if (start != 497933825) {
            throw new IOException("Invalid start of binary table encoding.");
        }
        boolean hasTableFacets = in.readBoolean();
        if (hasTableFacets) {
            table.setTableFacets((BFacets)BFacets.DEFAULT.decode(in));
        }
        int colCount = in.readInt();
        int[] typeSymbols = new int[colCount];
        Type[] colTypes = new Type[colCount];
        for (int ci = 0; ci < colCount; ++ci) {
            String name = in.readUTF();
            String displayName = in.readUTF();
            typeSymbols[ci] = in.readInt();
            colTypes[ci] = DataTypes.getBySymbol((char)typeSymbols[ci]);
            int flags = in.readInt();
            BFacets colFacets = null;
            boolean hasColumnFacets = in.readBoolean();
            if (hasColumnFacets) {
                colFacets = (BFacets)BFacets.DEFAULT.decode(in);
            }
            table.addColumn(name, displayName, colTypes[ci], flags, colFacets);
        }
        if (colCount == 0) {
            throw new IllegalStateException("Table contains no columns.");
        }
        int rowCount = in.readInt();
        if (rowCount == -1) {
            table.startRows();
        } else {
            table.startRows(rowCount);
        }
        int chunkRows = in.readInt();
        while (chunkRows != 0) {
            for (int i = 0; i < chunkRows; ++i) {
                table.startRow();
                block11: for (int col = 0; col < colCount; ++col) {
                    switch (typeSymbols[col]) {
                        case 102: {
                            table.set(in.readFloat(), (BFacets)null);
                            continue block11;
                        }
                        case 98: {
                            table.set(in.readBoolean(), null);
                            continue block11;
                        }
                        case 115: {
                            table.set(in.readUTF(), null);
                            continue block11;
                        }
                        case 105: {
                            table.set(in.readInt(), (BFacets)null);
                            continue block11;
                        }
                        case 108: {
                            table.set(in.readLong(), (BFacets)null);
                            continue block11;
                        }
                        case 100: {
                            table.set(in.readDouble(), null);
                            continue block11;
                        }
                        default: {
                            BIDataValue di = (BIDataValue)((Object)colTypes[col].getInstance());
                            table.set((BIDataValue)((Object)di.decode(in)), null);
                        }
                    }
                }
                table.endRow();
            }
            chunkRows = in.readInt();
        }
        table.endRows();
        int end = in.readInt();
        if (end != 766369282) {
            throw new IOException("Invalid end of binary table encoding.");
        }
        return table;
    }
}

