/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dataRecovery;

import com.tridium.sys.schema.NSlot;
import com.tridium.util.ArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDataRecoveryComponentEvent
extends BObject
implements BIEncodable {
    @Generated
    public static final Type TYPE = Sys.loadType(BDataRecoveryComponentEvent.class);
    public static final BDataRecoveryComponentEvent DEFAULT = new BDataRecoveryComponentEvent();
    protected static final String[] ID_STRINGS = new String[]{"changed", "added", "removed", "renamed", "reordered", "topicFired", "flagsChanged", "facetsChanged", "knobAdded", "knobRemoved", "recategorized"};
    private int eventId;
    private int[] slotIndex = null;
    private String slotName = null;
    private BComplex comp = null;
    private BOrd ord = null;
    private int hashCode = -1;
    private BValue value = null;
    private int flags = -1;
    private BFacets facets = null;
    private String oldSlotName = null;
    private Property[] properties = null;
    private BCategoryMask oldMask = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BDataRecoveryComponentEvent(int eventId, String slotName, int[] slotIndex, BOrd ord) {
        this.eventId = eventId;
        this.slotName = slotName;
        this.slotIndex = slotIndex;
        this.ord = ord;
    }

    private BDataRecoveryComponentEvent() {
    }

    public static BDataRecoveryComponentEvent makeChangeEvent(BComponent comp, Slot slot, BValue newValue) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 0;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.slotName = slot.getName();
        if (slot.isFrozen()) {
            try {
                int idx = ((NSlot)slot).index;
                event.slotIndex = new int[1];
                event.slotIndex[0] = idx;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        event.value = newValue;
        return event;
    }

    public static BDataRecoveryComponentEvent makeChangeEvent(BComplex complex, BOrd ordInSpace, int[] slotIndex, Slot slot, BValue newValue) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 0;
        event.comp = complex;
        event.slotIndex = slotIndex;
        event.ord = ordInSpace;
        event.slotName = slot.getName();
        event.value = newValue;
        return event;
    }

    public static BDataRecoveryComponentEvent makeAddEvent(BComponent comp, String slotName, BValue value, int flags, BFacets facets) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 1;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.slotName = slotName;
        event.value = value;
        event.flags = flags;
        event.facets = facets;
        return event;
    }

    public static BDataRecoveryComponentEvent makeRemoveEvent(BComponent comp, String slotName) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 2;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.slotName = slotName;
        return event;
    }

    public static BDataRecoveryComponentEvent makeRenameEvent(BComponent comp, String oldSlotName, String newSlotName) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 3;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.slotName = newSlotName;
        event.oldSlotName = oldSlotName;
        return event;
    }

    public static BDataRecoveryComponentEvent makeReorderEvent(BComponent comp, Property[] dynamicProperties) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 4;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.properties = dynamicProperties;
        return event;
    }

    public static BDataRecoveryComponentEvent makeFlagsChangeEvent(BComponent comp, String slotName, int flags) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 6;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.slotName = slotName;
        event.flags = flags;
        return event;
    }

    public static BDataRecoveryComponentEvent makeFacetsChangeEvent(BComponent comp, String slotName, BFacets facets) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 7;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.slotName = slotName;
        event.facets = facets;
        return event;
    }

    public static BDataRecoveryComponentEvent makeRecategorizeEvent(BComponent comp, BCategoryMask newMask, BCategoryMask oldMask) {
        BDataRecoveryComponentEvent event = new BDataRecoveryComponentEvent();
        event.eventId = 10;
        event.comp = comp;
        event.ord = comp.getOrdInSpace();
        event.value = newMask;
        event.oldMask = oldMask;
        return event;
    }

    public int getId() {
        return this.eventId;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public BComponent getComponent(BObject base) {
        return this.getComplex(base).asComponent();
    }

    public BComplex getComplex(BObject base) {
        if (this.comp != null) {
            return this.comp;
        }
        this.comp = (BComplex)this.ord.get(base);
        if (this.slotIndex != null) {
            SlotCursor<Slot> c;
            int len = this.slotIndex.length;
            for (int i = 0; i < len - 1; ++i) {
                c = this.comp.getSlots();
                boolean foundMatch = false;
                while (c.next()) {
                    Slot slot = c.slot();
                    if (!slot.isFrozen() || ((NSlot)slot).index != this.slotIndex[i]) continue;
                    this.comp = c.get().asComplex();
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                throw new IllegalStateException("Could not retrieve complex.");
            }
            int index = this.slotIndex[len - 1];
            if (this.slotName == null && index != -1) {
                c = this.comp.getSlots();
                while (c.next()) {
                    Slot slot = c.slot();
                    if (!slot.isFrozen()) continue;
                    try {
                        if (((NSlot)slot).index != index) continue;
                        this.slotName = slot.getName();
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
        return this.comp;
    }

    public BValue getValue() {
        return this.value;
    }

    public int getFlags() {
        return this.flags;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public String getOldSlotName() {
        return this.oldSlotName;
    }

    public Property[] getDynamicProperties() {
        return this.properties;
    }

    public BCategoryMask getCategoryMask() {
        return (BCategoryMask)this.value;
    }

    public BCategoryMask getOldCategoryMask() {
        return this.oldMask;
    }

    @Override
    public String toString(Context cx) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(ID_STRINGS[this.eventId]).append(" ");
        String displayPrefix = "";
        if (this.comp instanceof BComponent) {
            displayPrefix = ((BComponent)this.comp).toDisplayPathString(cx);
        } else if ((this.comp == null || this.slotIndex == null) && this.ord != null) {
            displayPrefix = this.ord.toString();
        }
        sb.append(displayPrefix);
        int len = 0;
        if (this.slotIndex != null) {
            len = this.slotIndex.length;
            if (this.comp != null) {
                BComplex current;
                int size = this.slotName != null ? len - 1 : len;
                BComponent parent = this.comp.getParentComponent();
                assert (parent != null);
                String parentDisplayString = parent.toDisplayPathString(cx);
                if (!displayPrefix.equals(parentDisplayString)) {
                    sb.append(parentDisplayString);
                }
                int offset = sb.length();
                for (BComplex test = current = (BComplex)this.ord.get(parent); test != null && parent != test; test = test.getParent()) {
                    sb.insert(offset, '/');
                    sb.insert(offset + 1, SlotPath.unescape(test.getPropertyInParent().getName()));
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    SlotCursor<Slot> c = current.getSlots();
                    boolean foundMatch = false;
                    while (c.next()) {
                        Slot slot = c.slot();
                        if (!slot.isFrozen() || ((NSlot)slot).index != this.slotIndex[i2]) continue;
                        sb.append('/').append(SlotPath.unescape(slot.getName()));
                        if (i2 != size - 1) {
                            current = c.get().asComplex();
                        }
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    throw new IllegalStateException("Invalid slot index " + this.slotIndex[i2]);
                }
            }
        }
        if (this.slotName != null) {
            sb.append("/").append(SlotPath.unescape(this.slotName));
        }
        if (len > 0) {
            sb.append("[");
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.slotIndex[i]);
            }
            sb.append("]");
        }
        if (this.value != null) {
            sb.append(", ").append(this.value.toString(cx));
        }
        if (this.flags != -1) {
            sb.append(", flags={").append(Flags.toDisplayString(this.flags, cx)).append("}");
        }
        if (this.facets != null) {
            sb.append(", facets={").append(this.facets.toString(cx)).append("}");
        }
        if (this.oldSlotName != null) {
            sb.append(", oldSlotName=").append(this.oldSlotName);
        }
        if (this.oldMask != null) {
            sb.append(", oldMask=").append(this.oldMask);
        }
        if (this.properties != null) {
            sb.append(": {");
            for (i = 0; i < this.properties.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.properties[i].getName());
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int x = 11;
            x ^= this.eventId;
            if (this.ord != null) {
                x ^= this.ord.hashCode();
            }
            if (this.slotName != null) {
                x ^= this.slotName.hashCode();
            }
            if (this.slotIndex != null) {
                for (int aSlotIndex : this.slotIndex) {
                    x ^= aSlotIndex;
                }
            }
            this.hashCode = x;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BDataRecoveryComponentEvent) {
            BDataRecoveryComponentEvent obj = (BDataRecoveryComponentEvent)o;
            return this.eventId == obj.eventId && (this.ord == obj.ord || this.ord != null && this.ord.equals(obj.ord)) && Arrays.equals(this.slotIndex, obj.slotIndex) && (Objects.equals(this.slotName, obj.slotName) || this.slotName != null && this.slotName.equals(obj.slotName));
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeByte(this.eventId);
        this.ord.encode(out);
        int len = this.slotIndex != null ? this.slotIndex.length : 0;
        boolean includeSlotIndex = false;
        if (len > 0) {
            if (len == 1 && this.slotIndex[0] == -1) {
                out.writeBoolean(false);
            } else {
                includeSlotIndex = true;
                out.writeBoolean(true);
                for (int i = 0; i < len; ++i) {
                    out.writeBoolean(true);
                    out.writeInt(this.slotIndex[i]);
                }
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
        boolean includeSlotName = !includeSlotIndex && this.slotName != null;
        out.writeBoolean(includeSlotName);
        if (includeSlotName) {
            out.writeUTF(this.slotName);
        }
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        byte eId = in.readByte();
        BOrd o = (BOrd)BOrd.DEFAULT.decode(in);
        int[] sIndex = null;
        if (in.readBoolean()) {
            int size = 1;
            int current = 0;
            int[] indexes = new int[size];
            while (in.readBoolean()) {
                if (current >= size) {
                    size += Math.min(size, 10);
                    indexes = ArrayUtil.grow(indexes, size);
                }
                indexes[current] = in.readInt();
                ++current;
            }
            if (current != size) {
                sIndex = new int[current];
                System.arraycopy(indexes, 0, sIndex, 0, current);
            } else {
                sIndex = indexes;
            }
        }
        String sName = null;
        if (in.readBoolean()) {
            sName = in.readUTF();
        }
        return new BDataRecoveryComponentEvent(eId, sName, sIndex, o);
    }

    @Override
    public String encodeToString() throws IOException {
        ByteBuffer buf = new ByteBuffer();
        this.encode((DataOutput)buf);
        return Base64.getEncoder().encodeToString(buf.toByteArray());
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        ByteBuffer buf = new ByteBuffer(Base64.getDecoder().decode(s));
        return this.decode((DataInput)buf);
    }

    int getEncodingLen() {
        int result = 3 + this.numBytesToEncode(this.ord.encodeToString());
        int len = this.slotIndex != null ? this.slotIndex.length : 0;
        boolean includeSlotIndex = false;
        if (len > 0 && (len != 1 || this.slotIndex[0] != -1)) {
            includeSlotIndex = true;
            result += 5 * len + 1;
        }
        if (!includeSlotIndex && this.slotName != null) {
            result += this.numBytesToEncode(this.slotName);
        }
        return result;
    }

    private int numBytesToEncode(String s) {
        int strlen = s.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            return 0;
        }
        return utflen + 2;
    }
}

