/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nav;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import java.io.IOException;
import java.util.function.BiFunction;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BINavSupport
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BINavSupport.class);
    public static final String JSON_KEY_NAV_NAME = "n";
    public static final String JSON_KEY_NAV_DISPLAY_NAME = "d";
    public static final String JSON_KEY_NAV_DESCRIPTION = "e";
    public static final String JSON_KEY_NAV_ORD = "o";
    public static final String JSON_KEY_NAV_ICON = "i";
    public static final String JSON_KEY_NAV_CHILDREN_ARRAY = "k";
    public static final BiFunction<BINavNode, Context, Boolean> ENCODE_ALL_NAV_CHILDREN = (node, cx) -> true;

    public boolean performingRefresh(BINavNode var1);

    public Runnable makeNavTreeWork(BINavNode var1);

    public void runNavTreeWork(Runnable var1);

    public static BINavSupport getNavSupport() {
        return NavSupportTypeHolder.INSTANCE;
    }

    public static JSONObject encodeToJson(BINavNode navNode, BiFunction<BINavNode, Context, Boolean> shouldEncodeChild, Context cx) throws IOException {
        JSONObject obj = new JSONObject();
        obj.put(JSON_KEY_NAV_NAME, (Object)navNode.getNavName());
        obj.put(JSON_KEY_NAV_DISPLAY_NAME, (Object)navNode.getNavDisplayName(cx));
        obj.put(JSON_KEY_NAV_DESCRIPTION, (Object)navNode.getNavDescription(cx));
        obj.put(JSON_KEY_NAV_ORD, (Object)navNode.getNavOrd().toString(cx));
        obj.put(JSON_KEY_NAV_ICON, (Object)navNode.getNavIcon().encodeToString());
        if (navNode.hasNavChildren()) {
            JSONArray kids = new JSONArray();
            for (BINavNode kid : navNode.getNavChildren()) {
                if (!shouldEncodeChild.apply(kid, cx).booleanValue()) continue;
                kids.put((Object)BINavSupport.encodeToJson(kid, shouldEncodeChild, cx));
            }
            obj.put(JSON_KEY_NAV_CHILDREN_ARRAY, (Object)kids);
        }
        return obj;
    }

    public static void encodeToJson(BINavNode navNode, JSONWriter out, BiFunction<BINavNode, Context, Boolean> shouldEncodeChild, Context cx) throws IOException {
        out.object();
        out.key(JSON_KEY_NAV_NAME).value((Object)navNode.getNavName());
        out.key(JSON_KEY_NAV_DISPLAY_NAME).value((Object)navNode.getNavDisplayName(cx));
        out.key(JSON_KEY_NAV_DESCRIPTION).value((Object)navNode.getNavDescription(cx));
        out.key(JSON_KEY_NAV_ORD).value((Object)navNode.getNavOrd().toString(cx));
        out.key(JSON_KEY_NAV_ICON).value((Object)navNode.getNavIcon().encodeToString());
        if (navNode.hasNavChildren()) {
            out.key(JSON_KEY_NAV_CHILDREN_ARRAY).array();
            for (BINavNode kid : navNode.getNavChildren()) {
                if (!shouldEncodeChild.apply(kid, cx).booleanValue()) continue;
                BINavSupport.encodeToJson(kid, out, shouldEncodeChild, cx);
            }
            out.endArray();
        }
        out.endObject();
    }

    public static final class NavSupportTypeHolder {
        static final BINavSupport INSTANCE;

        static {
            BINavSupport navSupport = null;
            try {
                navSupport = (BINavSupport)((Object)Sys.getType("workbench:NavSupport").getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
            INSTANCE = navSupport;
        }
    }
}

