/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.query;

import java.util.NoSuchElementException;
import java.util.Objects;
import javax.baja.naming.BLocalHost;
import javax.baja.security.BIProtected;
import javax.baja.sys.BasicContext;
import javax.baja.tag.Entity;
import javax.baja.user.BUser;
import javax.baja.util.CloseableIterator;

public class QueryPermissionCheckIterator
implements CloseableIterator<Entity> {
    private final CloseableIterator<Entity> baseIterator;
    private final BUser user;
    private Entity nextEntity;

    private QueryPermissionCheckIterator(CloseableIterator<Entity> baseIterator, BUser user) {
        this.baseIterator = baseIterator;
        this.user = user;
    }

    public static QueryPermissionCheckIterator make(CloseableIterator<Entity> baseIterator, BUser user) {
        Objects.requireNonNull(user, "Non-null user required for QueryPermissionCheckIterator");
        Objects.requireNonNull(baseIterator, "Non-null CloseableIterator required for QueryPermissionCheckIterator");
        QueryPermissionCheckIterator iterator = new QueryPermissionCheckIterator(baseIterator, user);
        iterator.findNextEntity();
        return iterator;
    }

    @Override
    public void close() throws Exception {
        this.baseIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntity != null;
    }

    @Override
    public Entity next() {
        if (this.nextEntity == null) {
            throw new NoSuchElementException();
        }
        Entity current = this.nextEntity;
        this.findNextEntity();
        return current;
    }

    private void findNextEntity() {
        do {
            Entity entity = this.nextEntity = this.baseIterator.hasNext() ? (Entity)this.baseIterator.next() : null;
        } while (this.nextEntity != null && !this.userHasPermissionsFor(this.nextEntity));
    }

    private boolean userHasPermissionsFor(Entity entity) {
        try {
            if (entity instanceof BIProtected) {
                return this.user.getPermissionsFor((BIProtected)((Object)entity)).hasOperatorRead();
            }
            entity.getOrdToEntity().get().get(BLocalHost.INSTANCE, new BasicContext(this.user));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

