/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNavMonitorRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BNavMonitorRpc.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void touchOrds(String baseOrdString, List<String> ordStrings, Context cx) {
        BObject base = BOrd.make(baseOrdString).get(null, cx);
        BOrd[] ords = (BOrd[])ordStrings.stream().map(BOrd::make).toArray(BOrd[]::new);
        BatchResolve resolve = new BatchResolve(ords);
        resolve.resolve(base, cx);
        ArrayList<BObject> objs = new ArrayList<BObject>(resolve.size());
        for (int i = 0; i < resolve.size(); ++i) {
            if (!resolve.isResolved(i)) continue;
            objs.add(resolve.get(i));
        }
        BNavMonitorRpc.touchNodes(objs.stream(), cx);
    }

    public static void touchNodes(Stream<? extends BIObject> nodes, Context cx) {
        HashMap spaceMap = new HashMap();
        nodes.forEach(obj -> {
            BISpaceNode node;
            BSpace space;
            BPermissions permissions;
            if (obj instanceof BIProtected && !(permissions = ((BIProtected)obj).getPermissions(cx)).hasOperatorRead()) {
                return;
            }
            if (obj instanceof BISpaceNode && (space = (node = (BISpaceNode)obj).getSpace()) != null) {
                BOrd ord = node.getOrdInSpace();
                spaceMap.computeIfAbsent(space, s -> new ArrayList()).add(ord);
            }
        });
        for (BSpace space : spaceMap.keySet()) {
            Collection ordList = (Collection)spaceMap.get(space);
            space.fw(110, ordList.toArray(new BOrd[0]), null, null, null);
        }
    }
}

