/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.security.AESDecryptFunction;
import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.LegacyStorageUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class AxPasswordUtil {
    public static final String PBK_ENCODING_TYPE_AX = "pbkdf2hmacsha256/text";
    public static final String AES_ENCODING_TYPE_AX = "aes256/text";
    public static final String PLAIN_ENCODING_TYPE_AX = "plain/text";
    private static final String N4_LEGACY_CLIENT_CREDS = "n4LegacyClientCredentials";

    private AxPasswordUtil() {
    }

    public static BPassword decodeAxPassword(String axEncodedValue) throws Exception {
        return AxPasswordUtil.decodeAxPassword(axEncodedValue, null);
    }

    public static BPassword decodeAxPassword(String axEncodedValue, AESDecryptFunction decryptFunction) throws Exception {
        String resultEncodingType;
        String encodedOnce;
        if (axEncodedValue == null || axEncodedValue.isEmpty()) {
            return BPassword.DEFAULT;
        }
        String axEncodingType = null;
        if (axEncodedValue.startsWith("[")) {
            encodedOnce = axEncodedValue;
            resultEncodingType = CryptographicAlgorithmBundle.extractName((String)axEncodedValue);
        } else {
            encodedOnce = LegacyStorageUtil.decode((String)axEncodedValue);
            axEncodingType = AxPasswordUtil.extractEncodingType(encodedOnce);
            if (axEncodingType == null) {
                return BPassword.make(encodedOnce, BAes256PasswordEncoder.ENCODING_TYPE);
            }
            if (PLAIN_ENCODING_TYPE_AX.equals(axEncodingType)) {
                resultEncodingType = BAes256PasswordEncoder.ENCODING_TYPE;
            } else if (AES_ENCODING_TYPE_AX.equals(axEncodingType)) {
                resultEncodingType = BAes256PasswordEncoder.ENCODING_TYPE;
            } else if (PBK_ENCODING_TYPE_AX.equals(axEncodingType)) {
                resultEncodingType = BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE;
            } else {
                throw new IllegalArgumentException("unsupported AX encoding type: " + axEncodingType);
            }
        }
        BAbstractPasswordEncoder resultEncoder = BAbstractPasswordEncoder.make(resultEncodingType);
        try {
            block52: {
                String toParse = AxPasswordUtil.changeEncodingType(encodedOnce);
                if (AES_ENCODING_TYPE_AX.equals(axEncodingType) && decryptFunction != null) {
                    String[] data = AesAlgorithmBundle.getInstance().decode(toParse);
                    Objects.requireNonNull(data);
                    String hexIv = data[0];
                    String hexCipher = data[1];
                    byte[] cipher = ByteArrayUtil.hexStringToBytes((String)hexCipher);
                    byte[] iv = ByteArrayUtil.hexStringToBytes((String)hexIv);
                    try (SecretBytes secretBytes = decryptFunction.decrypt(cipher, iv, "AES/CBC/PKCS5Padding");
                         SecretChars secretChars = SecretChars.fromSecretBytes((SecretBytes)secretBytes, (Charset)StandardCharsets.UTF_8, (boolean)true);){
                        resultEncoder.encode(secretChars);
                        break block52;
                    }
                }
                if (PLAIN_ENCODING_TYPE_AX.equals(axEncodingType)) {
                    try (SecretChars secretChars = SecretChars.fromString((String)toParse);){
                        resultEncoder.encode(secretChars);
                    }
                } else {
                    resultEncoder.parse(toParse);
                }
            }
            BPassword result = BPassword.make(resultEncoder);
            if (BAes256PasswordEncoder.ENCODING_TYPE.equals(resultEncodingType)) {
                AccessController.doPrivileged(result::getValue);
            }
            return result;
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }

    public static BValue unmarshalBog(String xml, ValueDocDecoder.BogTypeResolver typeResolver, Context cx) throws Exception {
        cx = PasswordEncodingContext.updateContext(cx, pcx -> pcx.setDecryptionKey(EncryptionKeySource.none, Optional.empty()));
        ValueDocDecoder.BogDecoderPlugin plugin = new ValueDocDecoder.BogDecoderPlugin(new ByteArrayInputStream(xml.getBytes()), cx);
        AxPasswordBogDecoder decoder = new AxPasswordBogDecoder(plugin, cx);
        decoder.getPlugin().setTypeResolver(typeResolver);
        decoder.getPlugin().next();
        return decoder.decode();
    }

    public static BValue unmarshalBog(String xml, Context cx) throws Exception {
        return AxPasswordUtil.unmarshalBog(xml, new ValueDocDecoder.BogTypeResolver(), cx);
    }

    public static BValue unmarshalBog(String xml) throws Exception {
        return AxPasswordUtil.unmarshalBog(xml, new ValueDocDecoder.BogTypeResolver(), null);
    }

    public static boolean usesPasswordEncodings(BComplex c, String ... encodingTypes) {
        HashSet<String> encodingTypeSet = new HashSet<String>();
        Collections.addAll(encodingTypeSet, encodingTypes);
        return AxPasswordUtil.usesPasswordEncodings(c, encodingTypeSet);
    }

    public static boolean usesPasswordEncodings(BComplex c, Set<String> encodingTypes) {
        for (Property p : c.getProperties()) {
            BValue v = c.get(p);
            if (!(v instanceof BComplex ? AxPasswordUtil.usesPasswordEncodings((BComplex)v, encodingTypes) : v instanceof BPassword && encodingTypes.contains(((BPassword)v).getPasswordEncoder().getEncodingType()))) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getAxPasswordEncodings(File bogFile, String ... limit) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(bogFile);){
            Set<String> set = AxPasswordUtil.getAxPasswordEncodings(inputStream, limit);
            return set;
        }
    }

    public static Set<String> getAxPasswordEncodings(BIFile bogFile, String ... limit) throws Exception {
        try (InputStream inputStream = bogFile.getInputStream();){
            Set<String> set = AxPasswordUtil.getAxPasswordEncodings(inputStream, limit);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getAxPasswordEncodings(InputStream bogFileInput, String ... limit) throws Exception {
        HashSet unusedEncodings = new HashSet();
        if (limit.length == 0) {
            Collections.addAll(unusedEncodings, AES_ENCODING_TYPE_AX, PBK_ENCODING_TYPE_AX, PLAIN_ENCODING_TYPE_AX);
        } else {
            Collections.addAll(unusedEncodings, limit);
        }
        HashSet<String> result = new HashSet<String>();
        try (XParser parser = XParser.make((InputStream)bogFileInput);){
            int nextResult = parser.next();
            while (nextResult != -1) {
                XElem element;
                if (nextResult == 2 && (element = parser.elem()) != null && element.name().equals("p")) {
                    if (element.get("t", "").endsWith(":Password") || element.get("v", "").endsWith("=")) {
                        String encoding;
                        try {
                            if (element.get("v", "").startsWith("[")) {
                                encoding = CryptographicAlgorithmBundle.extractName((String)element.get("v"));
                            } else {
                                String v = LegacyStorageUtil.decode((String)element.get("v"));
                                encoding = AxPasswordUtil.extractEncodingType(v);
                            }
                        }
                        catch (Exception ignored) {
                            encoding = null;
                        }
                        if (encoding == null && element.get("t", "").endsWith(":Password")) {
                            encoding = PLAIN_ENCODING_TYPE_AX;
                        }
                        if (encoding != null && unusedEncodings.contains(encoding)) {
                            result.add(encoding);
                            unusedEncodings.remove(encoding);
                            if (unusedEncodings.isEmpty()) {
                                HashSet<String> hashSet = result;
                                return hashSet;
                            }
                        }
                    } else if (element.get("n", "").equals("encodedCred") && unusedEncodings.contains(N4_LEGACY_CLIENT_CREDS)) {
                        result.add(N4_LEGACY_CLIENT_CREDS);
                        unusedEncodings.remove(N4_LEGACY_CLIENT_CREDS);
                        if (unusedEncodings.isEmpty()) {
                            HashSet<String> hashSet = result;
                            return hashSet;
                        }
                    }
                }
                nextResult = parser.next();
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public static String changeEncodingType(String encodedPassword) {
        if (encodedPassword.startsWith("[")) {
            return encodedPassword;
        }
        int startEncoding = encodedPassword.indexOf("encoded[");
        int endEncoding = encodedPassword.indexOf("]=");
        if (startEncoding == 0 && endEncoding > 0) {
            StringBuilder sb = new StringBuilder();
            String encoding = AxPasswordUtil.extractEncodingType(encodedPassword);
            if (AES_ENCODING_TYPE_AX.equals(encoding)) {
                sb.append("[").append(AesAlgorithmBundle.getInstance().getAlgorithmName()).append("]=");
            } else if (PBK_ENCODING_TYPE_AX.equals(encoding)) {
                sb.append("[").append(NiagaraStationAlgorithmBundle.getInstance().getAlgorithmName()).append("]=");
            }
            sb.append(encodedPassword.substring(endEncoding + 2));
            return sb.toString();
        }
        return encodedPassword;
    }

    public static String extractEncodingType(String value) {
        if (value.startsWith("[")) {
            return CryptographicAlgorithmBundle.extractName((String)value);
        }
        if (value.startsWith("encoded[")) {
            String[] args = TextUtil.split((String)value.substring(8), (char)']');
            if (args.length == 0) {
                throw new BajaRuntimeException("unrecognized AX encoding type");
            }
            return args[0];
        }
        return null;
    }

    public static String encodeAxPassword(BPassword value) throws IOException {
        Objects.requireNonNull(value);
        if (value.isDefault()) {
            return "";
        }
        if (value.getPasswordEncoder() instanceof BPbkdf2HmacSha256PasswordEncoder) {
            BPbkdf2HmacSha256PasswordEncoder encoder = (BPbkdf2HmacSha256PasswordEncoder)value.getPasswordEncoder();
            return LegacyStorageUtil.encode((String)("encoded[pbkdf2hmacsha256/text]=" + encoder.getSalt() + ":" + encoder.getIterationCount() + ":" + ByteArrayUtil.toHexString((byte[])encoder.getKey())), (int)0);
        }
        throw new IllegalArgumentException("Encoding BPassword that uses reversible encoding is unsupported");
    }

    public static String marshalBog(BValue value) throws IOException {
        return AxPasswordUtil.marshalBog(value, null);
    }

    public static String marshalBog(BValue value, Context cx) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        cx = PasswordEncodingContext.updateContext(cx, pcx -> pcx.setEncryptionKey(EncryptionKeySource.none, Optional.empty()));
        AxPasswordBogEncoder encoder = new AxPasswordBogEncoder(new ValueDocEncoder.BogEncoderPlugin(out, cx), cx);
        encoder.encode(value);
        encoder.close();
        return new String(out.toByteArray());
    }

    public static class AxPasswordBogEncoder
    extends ValueDocEncoder {
        public AxPasswordBogEncoder(ValueDocEncoder.BogEncoderPlugin plugin, Context context) throws IOException {
            super(plugin, PasswordEncodingContext.updateContext(context, pcx -> pcx.setEncryptionKey(EncryptionKeySource.none, Optional.empty())));
        }

        @Override
        protected String encodeSimple(BSimple simple) throws IOException {
            Objects.requireNonNull(simple);
            if (simple instanceof BPassword) {
                return AxPasswordUtil.encodeAxPassword((BPassword)simple);
            }
            return super.encodeSimple(simple);
        }
    }

    public static class AxPasswordBogDecoder
    extends ValueDocDecoder {
        public AxPasswordBogDecoder(ValueDocDecoder.BogDecoderPlugin plugin, Context cx) throws Exception {
            super(plugin, PasswordEncodingContext.updateContext(cx, pcx -> pcx.setDecryptionKey(EncryptionKeySource.none, Optional.empty())));
        }

        @Override
        protected BSimple decodeSimple(BObject obj, String value) {
            try {
                Objects.requireNonNull(obj);
                Objects.requireNonNull(value);
                if (obj instanceof BPassword) {
                    return AxPasswordUtil.decodeAxPassword(value);
                }
            }
            catch (Exception e) {
                throw this.plugin.err("Invalid " + obj.getType().getTypeName() + ": '" + value + "'", e);
            }
            return super.decodeSimple(obj, value);
        }
    }
}

