/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.baja.util.Lexicon;

public abstract class BasePermissionGroup
extends NiagaraPermissionGroup {
    private final String NONE_KEY = "permissions.params.none";
    protected final String requestingModuleName;
    protected final String purposeKey;
    protected final String riskDescriptionKey;
    protected final Map<String, String> parameters;
    private static Lexicon bajaLex = null;

    protected BasePermissionGroup(NiagaraPermissionGroup.RiskLevel riskLevel, EnumSet<NiagaraPermissionGroup.Flags> flags, String riskDescriptionKey) {
        super(riskLevel, flags);
        this.requestingModuleName = "";
        this.purposeKey = "";
        this.parameters = null;
        this.riskDescriptionKey = riskDescriptionKey;
    }

    protected BasePermissionGroup(NiagaraPermissionGroup.RiskLevel riskLevel, EnumSet<NiagaraPermissionGroup.Flags> flags, String purposeKey, Map<String, String> parameters, String riskDescriptionKey) {
        super(riskLevel, flags);
        int index = purposeKey.indexOf(58);
        this.requestingModuleName = purposeKey.substring(0, index);
        this.purposeKey = purposeKey.substring(index + 1);
        this.parameters = parameters;
        this.riskDescriptionKey = riskDescriptionKey;
    }

    public String getPurpose() {
        return Lexicon.make(this.requestingModuleName).get(this.purposeKey, this.purposeKey);
    }

    public String getParameters() {
        List<ParameterInfo> parameterInfoList;
        if (bajaLex == null) {
            bajaLex = Lexicon.make("baja");
        }
        if ((parameterInfoList = this.getParameterInfo()) == null) {
            return bajaLex.get("permissions.params.none", "None");
        }
        StringJoiner parameterString = new StringJoiner(" | ", "[ ", " ]");
        boolean i = false;
        for (ParameterInfo parameterInfo : parameterInfoList) {
            parameterString.add(bajaLex.get(parameterInfo.lexiconKey, parameterInfo.defaultText) + ": " + this.parameters.get(parameterInfo.xmlAttribute));
        }
        return parameterString.toString();
    }

    public String getLocalizedRiskLevel() {
        if (bajaLex == null) {
            bajaLex = Lexicon.make("baja");
        }
        String levelString = this.getRiskLevel().toString();
        return bajaLex.get("permissions.riskLevel." + levelString, levelString);
    }

    public String getRiskDescription() {
        if (bajaLex == null) {
            bajaLex = Lexicon.make("baja");
        }
        return bajaLex.get(this.riskDescriptionKey);
    }

    static void initNiagaraPermissionGroupMap(Map<String, NiagaraPermissionGroup> map) {
        BasePermissionGroup.initPermissionGroupMap(map);
    }

    public abstract List<ParameterInfo> getParameterInfo();

    public static class ParameterInfo {
        public String xmlAttribute;
        public String lexiconKey;
        public String defaultText;

        protected ParameterInfo(String xmlAttribute, String lexiconKey, String defaultText) {
            this.xmlAttribute = xmlAttribute;
            this.lexiconKey = lexiconKey;
            this.defaultText = defaultText;
        }
    }
}

