/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Map;
import javax.baja.nre.security.HsmManager;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public class HsmSpy
extends Spy {
    private static DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private HsmManager mgr;

    public HsmSpy(HsmManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public String getTitle() {
        return "HSM Information";
    }

    @Override
    public void write(SpyWriter out) throws Exception {
        if (!"none".equals(this.mgr.getHsmType())) {
            out.startTable(true);
            out.trTitle("HSM Type", 2);
            out.tr("niagara.hsm.type", this.mgr.getHsmType());
            out.endTable();
            out.nbsp();
            out.nl();
        }
        if (this.mgr.hasHsmEngine()) {
            AccessController.doPrivileged(() -> {
                out.startTable(true);
                out.trTitle("HSM Engine", 2);
                out.tr("niagara.hsm.engine", this.mgr.getHsmEngineClassName());
                out.endTable();
                Map props = this.mgr.getProperties();
                if (props != null) {
                    out.nbsp();
                    out.nl();
                    out.startTable(true);
                    out.trTitle("HSM Properties", 2);
                    for (String key : props.keySet()) {
                        out.tr(key, props.get(key));
                    }
                    out.endTable();
                }
                try {
                    KeyStore keyStore = KeyStore.getInstance("NiagaraHsm");
                    keyStore.load(null, null);
                    out.nbsp();
                    out.nl();
                    out.startTable(true);
                    out.trTitle("HSM Keys", 5);
                    out.w("<tr>").th("Alias").th("Type").th("Algorithm").th("Key Size").th("Creation Date").w("</tr>\n");
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        try {
                            String alias = aliases.nextElement();
                            Key key = keyStore.getKey(alias, null);
                            String alg = key.getAlgorithm();
                            String type = key instanceof PublicKey ? "public" : (key instanceof PrivateKey ? "private" : "unknown");
                            String size = Integer.toString(HsmSpy.getKeyLength(key));
                            String creation = DATE_FORMAT.format(keyStore.getCreationDate(alias));
                            out.tr(alias, type, alg, size, creation);
                        }
                        catch (Exception exception) {}
                    }
                    out.endTable();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
        } else {
            out.startTable(true);
            out.trTitle("HSM Engine", 2);
            out.tr("niagara.hsm.engine", "missing");
            out.endTable();
        }
    }

    private static int getKeyLength(Key key) {
        int length = -1;
        if (key instanceof RSAKey) {
            length = ((RSAKey)((Object)key)).getModulus().bitLength();
        } else if (key instanceof DSAKey) {
            length = ((DSAKey)((Object)key)).getParams().getP().bitLength();
        } else if (key instanceof ECKey) {
            length = ((ECKey)((Object)key)).getParams().getOrder().bitLength();
        }
        return length;
    }
}

