/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.nre.util.TextExpander;
import com.tridium.security.BasePermissionGroup;
import java.io.File;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public final class LoadLibraryPermissionGroup
extends BasePermissionGroup {
    protected static final LoadLibraryPermissionGroup DUMMY = new LoadLibraryPermissionGroup();
    public static final String TYPE = "LOAD_LIBRARIES";
    private static final String LIBRARIES_XML = "libraries";
    private static final String LIBRARIES_KEY = "permissions.loadLibrary.libraries";
    private static final String RISK_KEY = "permissions.loadLibrary.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private static final TextExpander expander;
    private final Set<Permission> permissions;

    private LoadLibraryPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected LoadLibraryPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        block6: {
            super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
            String librariesString = parameters.get(LIBRARIES_XML);
            if (librariesString == null) {
                throw new ParsingException("Parameter <libraries> for <LOAD_LIBRARIES> permission group is null");
            }
            this.permissions = new HashSet<Permission>();
            try {
                if (librariesString.contains("${") && librariesString.contains("}")) {
                    librariesString = expander.expand(librariesString);
                    Arrays.asList(librariesString.split(",")).forEach(name -> {
                        if (name != null && !name.isEmpty()) {
                            this.permissions.add(new RuntimePermission("loadLibrary." + name.trim()));
                        }
                    });
                    break block6;
                }
                if (!librariesString.contains("${")) {
                    String[] libraries;
                    for (String library : libraries = librariesString.split(",")) {
                        this.permissions.add(new RuntimePermission("loadLibrary." + library.trim()));
                    }
                    break block6;
                }
                throw new ParsingException("Invalid <libraries> parameter \"" + librariesString + "\" for <" + TYPE + "> permission group");
            }
            catch (IllegalArgumentException | NoSuchElementException e) {
                throw new ParsingException("Could not parse load library path: path could not be expanded: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new LoadLibraryPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    private static String mapper(String key) {
        if ("/".equals(key)) {
            return File.separator;
        }
        if (":".equals(key)) {
            return File.pathSeparator;
        }
        String propertyValue = AccessController.doPrivileged(() -> System.getProperty(key));
        return Optional.ofNullable(propertyValue).orElseThrow(() -> new NoSuchElementException(key + " not found"));
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(LIBRARIES_XML, LIBRARIES_KEY, "Libraries"));
        expander = new TextExpander(LoadLibraryPermissionGroup::mapper);
    }
}

