/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.security.BasePermissionGroup;
import java.io.File;
import java.io.FilePermission;
import java.nio.file.Paths;
import java.security.Permission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.LoggingPermission;
import javax.baja.sys.Sys;

public final class LoggingPermissionGroup
extends BasePermissionGroup {
    protected static final LoggingPermissionGroup DUMMY = new LoggingPermissionGroup();
    public static final String TYPE = "LOGGING";
    private static final String RISK_KEY = "permissions.logging.riskDescription";
    private static final Set<Permission> permissions = new HashSet<Permission>();

    private LoggingPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
    }

    protected LoggingPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags) {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, flags, purposeKey, null, RISK_KEY);
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return permissions;
    }

    protected NiagaraPermissionGroup copy() {
        return new LoggingPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, this.getFlags());
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return null;
    }

    static {
        permissions.add(new FilePermission(Paths.get(Sys.getNiagaraUserHome().getAbsolutePath(), "logging").toString(), "read,write"));
        permissions.add(new FilePermission(Paths.get(Sys.getNiagaraUserHome().getAbsolutePath(), "logging").toString() + File.separator + "-", "read,write"));
        permissions.add(new LoggingPermission("control", null));
    }
}

