/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicyUtil;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ManagedModuleFile;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.util.Set;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public final class PolicySpy
extends Spy {
    Lexicon bajaLex;
    static final String mildIcon = "<img height=\"13px\" width=\"13px\" src=\"module://icons/x16/shapes/circleGreen.png\"/>";
    static final String moderateIcon = "<img height=\"13px\" width=\"13px\" src=\"module://icons/x16/shapes/circleGold.png\"/>";
    static final String severeIcon = "<img height=\"13px\" width=\"13px\" src=\"module://icons/x16/shapes/circleRed.png\"/>";

    public PolicySpy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new NiagaraBasicPermission("VIEW_NIAGARA_POLICY"));
        }
    }

    @Override
    public String getTitle() {
        return "Policy Information";
    }

    @Override
    public void write(SpyWriter out) throws Exception {
        if (this.bajaLex == null) {
            this.bajaLex = Lexicon.make("baja");
        }
        DefaultModulesFileManager.ModuleFileSet modules = DefaultModulesFileManager.get().get().init(false);
        out.w("<style type=\"text/css\">");
        out.w(".table {border-collapse: collapse; border-bottom: 1px solid #adb2b8;}");
        out.w(".table, .th, .tdMod, .td {text-align:left; padding:3px 8px;}");
        out.w(".th, .tdMod {background-color:#848b95; color:white; white-space: nowrap;}");
        out.w(".tdMod {vertical-align:top;}");
        out.w(".topRow {color: #3b3f44; border-top:1px solid #adb2b8;}");
        out.w(".innerRow {color: #3b3f44; border-top:1px solid #e4e5e7;}");
        out.w(".td:hover {background-color: #f1f2f3;}");
        out.w(".moreInfo { display:inline; text-decoration: underline;}");
        out.w(".moreInfoText span { display:none; color: #535960;}");
        out.w(".moreInfoText:hover span { z-index: 1; display:block; position:absolute; width:450px; margin:0px; padding:10px; color:white; font-weight:normal; background:#848b95; text-align:left; border:1px solid #6b727b;}");
        out.w(".innerTableHeader { vertical-align: top; text-align: right; padding: 0px 10px 0px 0px;  white-space: nowrap;}");
        out.w(".innerTableData { vertical-align: top;}");
        out.w("</style>");
        out.w("<table class=\"table\">");
        out.w("<tr class=\"tr\">");
        out.w("<th class=\"th\">").safe(this.bajaLex.get("permissions.policySpy.moduleColumnName")).w("</th>");
        out.w("<th class=\"th\">").safe(this.bajaLex.get("permissions.policySpy.permissionColumn")).w("</th>");
        out.w("</tr>");
        for (ManagedModuleFile module : modules) {
            String moduleUrl;
            if (!module.hasNiagaraPermissions()) continue;
            Sys.loadModule(module.getModuleName());
            try {
                moduleUrl = NiagaraPolicyUtil.canonicalizeCodeSource((String)module.getFile().getPath());
            }
            catch (IOException e) {
                continue;
            }
            Set groups = AccessController.doPrivileged(() -> NiagaraPolicyUtil.getAllPermissionGroups((String)moduleUrl));
            if (groups.isEmpty()) continue;
            boolean firstRow = true;
            out.w("<tr class=\"topRow\">");
            out.w("<td class=\"tdMod\" rowspan=\"" + groups.size() + "\">").safe(module.getModulePartName()).w("</td>");
            for (NiagaraPermissionGroup group : groups) {
                if (!firstRow) {
                    out.w("<tr class=\"innerRow\">");
                }
                firstRow = false;
                out.w("<td class=\"td\">");
                this.writeGroupDescription(out, group);
                out.w("</td>");
                out.w("</tr>");
            }
        }
        out.w("</table>");
        out.flush();
    }

    private void writeGroupDescription(SpyWriter out, NiagaraPermissionGroup group) {
        out.w("<table style=\"padding:0; border-spacing:0;\">");
        out.w("<tr><td class=\"innerTableHeader\">").safe(this.bajaLex.get("permissions.type")).w("</td>");
        out.w("<td class=\"innerTableData\">").safe(group.getType()).w("</td></tr>");
        out.w("<tr><td class=\"innerTableHeader\">").safe(this.bajaLex.get("permissions.purpose")).w("</td>");
        out.w("<td class=\"innerTableData\">").safe(group.getPurpose()).w("</td></tr>");
        out.w("<tr><td class=\"innerTableHeader\">").safe(this.bajaLex.get("permissions.params")).w("</td>");
        out.w("<td class=\"innerTableData\">").safe(group.getParameters()).w("</td></tr>");
        out.w("<tr><td class=\"innerTableHeader\">").safe(this.bajaLex.get("permissions.riskLevel")).w("</td>");
        out.w("<td class=\"innerTableData\">").w(this.getIcon(group.getRiskLevel())).safe(" " + group.getLocalizedRiskLevel());
        out.w(" (<div class=\"moreInfo\">");
        out.w("<span class=\"moreInfoText\">").safe(this.bajaLex.get("permissions.policySpy.moreInfo")).w("<span>").safe(group.getRiskDescription()).w("</span></span>");
        out.w("</div>)");
        out.w("</td></tr>");
        out.w("</table>");
    }

    private String getIcon(NiagaraPermissionGroup.RiskLevel riskLevel) {
        switch (riskLevel) {
            case MILD: {
                return mildIcon;
            }
            case MODERATE: {
                return moderateIcon;
            }
            case SEVERE: {
                return severeIcon;
            }
        }
        return moderateIcon;
    }
}

