/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.security.BasePermissionGroup;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectionPermissionGroup
extends BasePermissionGroup {
    protected static final ReflectionPermissionGroup DUMMY = new ReflectionPermissionGroup();
    public static final String TYPE = "REFLECTION";
    private static final String RISK_KEY = "permissions.reflection.riskDescription";
    private static final Set<Permission> permissions = new HashSet<Permission>();

    public ReflectionPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
    }

    public ReflectionPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags) {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, null, RISK_KEY);
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return permissions;
    }

    protected NiagaraPermissionGroup copy() {
        return new ReflectionPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, this.getFlags());
    }

    public boolean requiresSignature() {
        return true;
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return null;
    }

    static {
        permissions.add(new ReflectPermission("suppressAccessChecks"));
    }
}

