/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.sys.BootEnv;
import com.tridium.sys.Nre;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ModulesFileManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.SecurityUtil;

public class DefaultBootEnv
implements BootEnv {
    private ModulesFileManager modulesFileManager = new DefaultModulesFileManager();

    @Override
    public File getNiagaraHome() {
        return AccessController.doPrivileged(() -> {
            File file;
            String home = System.getProperty("niagara.home");
            if (home == null) {
                Nre.fatal("Missing \"niagara.home\" system property");
            }
            if (!(file = new File(home.replace('/', File.separatorChar))).exists()) {
                Nre.fatal("Invalid dir for 'niagara.home': " + home);
            }
            return file;
        });
    }

    @Override
    public File getNiagaraUserHome() {
        File file;
        String home = AccessController.doPrivileged(() -> System.getProperty("niagara.user.home"));
        if (home == null) {
            Nre.fatal("Missing \"niagara.user.home\" system property");
        }
        if (!(file = new File(home.replace('/', File.separatorChar))).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public ModulesFileManager getModulesFileManager() {
        return this.modulesFileManager;
    }

    @Override
    public File findModuleFile(String moduleName, String profileName) {
        return this.modulesFileManager.findModuleFile(moduleName, RuntimeProfile.valueOf((String)profileName));
    }

    @Override
    public File[] findModuleFiles(String moduleName) {
        return this.modulesFileManager.findModuleFiles(moduleName);
    }

    @Override
    public File findDependency(String modulePartName) {
        return this.modulesFileManager.findDependency(modulePartName);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public InputStream read(String path) throws Exception {
        File target;
        Path base = Paths.get(path, new String[0]).normalize();
        if ((base = base.subpath(0, base.getNameCount())).startsWith("registry")) {
            target = SecurityUtil.resolveChrootPath((File)Nre.niagaraUserHome, (String)base.toString());
        } else if (base.startsWith("lexicon")) {
            target = SecurityUtil.resolveChrootPath((File)Nre.niagaraHome, (String)base.toString());
        } else if (base.startsWith("etc")) {
            target = SecurityUtil.resolveChrootPath((File)Nre.niagaraUserHome, (String)base.toString());
        } else if (base.startsWith("defaults")) {
            target = SecurityUtil.resolveChrootPath((File)Nre.niagaraHome, (String)base.toString());
        } else {
            throw new IllegalArgumentException("Invalid read request: " + path);
        }
        return new BufferedInputStream(new FileInputStream(target));
    }
}

