/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.logging.LogSettings;
import com.tridium.nre.bootstrap.Bootstrap;
import com.tridium.nre.di.IConfiguration;
import com.tridium.nre.di.NreInstantiator;
import com.tridium.nre.di.SingletonSupplier;
import com.tridium.nre.di.TypeSupplier;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.security.DeveloperSecurityManager;
import com.tridium.nre.security.HsmManagerImpl;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ISecurityInitializer;
import com.tridium.nre.security.ISecurityInitializerConfig;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecurityConstants;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.TextFileSignatureVerifier;
import com.tridium.nre.security.policy.AbstractPermissionGroupStore;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicy;
import com.tridium.nre.security.policy.NiagaraPolicyUtil;
import com.tridium.nre.subscription.AccessTokenApi;
import com.tridium.nre.subscription.DeviceCodeApi;
import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.RegistrationApi;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.syslog.SyslogManager;
import com.tridium.nre.util.FileLock;
import com.tridium.nre.util.FileLockException;
import com.tridium.nre.util.LicenseMode;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.nre.util.SecurityManagerUtil;
import com.tridium.nre.util.Version;
import com.tridium.security.GrantAllPermissionGroupStore;
import com.tridium.security.NiagaraPermissionGroupFactory;
import com.tridium.security.SecuritySpyDir;
import com.tridium.sys.BIPlatform;
import com.tridium.sys.BNullPlatform;
import com.tridium.sys.BootEnv;
import com.tridium.sys.Console;
import com.tridium.sys.DefaultBootEnv;
import com.tridium.sys.NreLib;
import com.tridium.sys.diagnostics.DiagnosticSpy;
import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.engine.LeaseManager;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.license.subscription.SubscriptionLicenseManager;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.ModuleManager;
import com.tridium.sys.module.NModule;
import com.tridium.sys.net.NetworkInterfaceManager;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.resource.ResourceManager;
import com.tridium.sys.schema.SchemaManager;
import com.tridium.sys.service.ServiceManager;
import com.tridium.sys.spy.ConsoleSpyDir;
import com.tridium.sys.spy.LogSetupSpy;
import com.tridium.sys.spy.SysInfoSpy;
import com.tridium.sys.spy.SystemPropertiesSpy;
import com.tridium.sys.spy.UtilSpy;
import com.tridium.sys.station.StationManager;
import com.tridium.sys.stdout.StdoutManager;
import com.tridium.sys.test.TestWatcher;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CommandLineArguments;
import com.tridium.util.ThrowableUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.security.HsmManager;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQueryScheme;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.Auditor;
import javax.baja.security.SecurityAuditor;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.spy.BSpySpace;
import javax.baja.spy.ObjectSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.util.UserFileRepositoryCopy;

public class Nre {
    private static final Set<String> testRunnerNames = new HashSet<String>();
    private static final Set<String> smExemptionList = new HashSet<String>();
    public static final long bootTime;
    public static BootEnv bootEnv;
    public static CommandLineArguments args;
    private static RuntimeProfile[] supportedProfiles;
    public static String commandLine;
    public static File niagaraHome;
    public static File niagaraUserHome;
    public static File niagaraSharedUserHome;
    private static File niagaraDevHome;
    public static File credentialsHome;
    public static File stationHome;
    public static File protectedStationHome;
    public static ThreadGroup mainThreadGroup;
    public static SpyDir spySysManagers;
    public static SpyDir securitySpy;
    public static String language;
    public static Auditor auditor;
    public static int unitConversion;
    public static String vmUuid;
    private static ModuleVerificationMode moduleVerificationMode;
    private static JarSignatureRegistry signatureRegistry;
    private static SecurityAuditor securityAuditor;
    private static StdoutManager stdoutManager;
    private static ModuleManager moduleManager;
    private static NRegistry registryManager;
    private static SchemaManager schemaManager;
    private static EngineManager engineManager;
    private static LeaseManager leaseManager;
    private static ServiceManager serviceManager;
    private static NLicenseManager licenseManager;
    private static StationManager stationManager;
    private static ResourceManager resourceManager;
    private static Metrics.Recount metricsRecount;
    private static NetworkInterfaceManager networkInterfaceManager;
    private static HsmManager hsmManager;
    static boolean isBooted;
    static BIPlatform platform;
    static boolean isStation;
    static boolean isRemote;
    static boolean hasBootClass;
    private static final String WB_MAIN = "workbench:com.tridium.workbench.shell.WbMain";
    private static final String NRE_PROP = "cmdline::";
    private static final Logger sysLog;
    private static final NiagaraBasicPermission GET_MANAGER_PERMISSION;
    private static final String[] ALLOWED_SECURITY_OVERRIDES;
    private static final String DEFAULT_COMMAND_LINE_BLACKLIST = "niagara.moduleVerificationMode,program.requireSigning,niagara.export.preventCSVInjection,niagara.webbrowser.disable,niagara.webbrowser.urlWhitelist,niagara.baja.formatBlacklist,niagara.baja.formatBlacklistExclusions,jdk.tls.rejectClientInitiatedRenegotiation";

    static void usage() {
        Nre.println("");
        Nre.println("usage:");
        Nre.println("  nre [options] <class> [args]*");
        Nre.println("parameters:");
        Nre.println("  class        classname or module:classname to execute");
        Nre.println("  args         arguments to pass through to main");
        Nre.println("options:");
        Nre.println("  -version     print nre version");
        Nre.println("  -modules:<x> print modules which match specified pattern");
        Nre.println("  -hostid      print system host id");
        Nre.println("  -licenses    print licensing summary");
        Nre.println("  -props       dump system properties");
        Nre.println("  -locale:<x>  set the default locale (en_US)");
        Nre.println("  -@<option>   pass option to Java VM");
        Nre.println("  -testheap    test max heap size");
        Nre.println("  -buildreg    force rebuild of the registry");
        Nre.println("  -rp:<profileKey>[,<profileKey>]* use given runtime profiles");
        Nre.println("     <profileKey>: ux|wb|se|doc");
        if (SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.SUBSCRIPTION) {
            Nre.println("  -register          register with the subscription license system");
            Nre.println("  -checksub          check the subscription registration state of this host");
            Nre.println("  -rotatekeys        rotates subscription license keys");
            if ("cloned".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                Nre.println("  -regenerate  resets subscription information and regenerates host id");
            }
        }
        Nre.println("");
    }

    public static void bootstrap(String[] rawArgs) {
        Nre.main(rawArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] rawArgs) {
        boolean showLoadingSplash = false;
        try {
            StringBuilder s = new StringBuilder("nre");
            for (String rawArg : rawArgs) {
                s.append(' ').append(rawArg);
            }
            commandLine = s.toString();
            args = new CommandLineArguments(rawArgs);
            if (args.hasOption("rp")) {
                supportedProfiles = Nre.parseSupportedProfiles(args.getOption("rp"));
            }
            if (args.hasOption("version")) {
                Nre.version();
                return;
            }
            if (args.hasOption("modules")) {
                Nre.modules(args.getOption("modules"));
                return;
            }
            if (args.hasOption("hostid")) {
                Nre.hostId();
                return;
            }
            if (args.hasOption("km")) {
                Nre.initKm();
                return;
            }
            if (args.hasOption("licenses")) {
                Nre.licenses();
                return;
            }
            if (args.hasOption("props")) {
                Nre.dumpProps();
                return;
            }
            if (args.hasOption("testheap")) {
                Nre.testheap();
                return;
            }
            if (args.hasOption("buildreg")) {
                Nre.buildreg();
                return;
            }
            if (args.hasOption("watch")) {
                Nre.watch(rawArgs);
                return;
            }
            Nre.initNiagaraHomeForLicense();
            if (SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.SUBSCRIPTION) {
                SubscriptionLicenseManager slm = new SubscriptionLicenseManager();
                DeviceCodeApi deviceCodeApi = new DeviceCodeApi();
                RegistrationApi registrationApi = new RegistrationApi();
                if (args.hasOption("register")) {
                    if (Nre.args.parameters.length == 1 && SubscriptionLicenseUtil.isKeyValid((String)Nre.args.parameters[0])) {
                        String subscriptionKey = Nre.args.parameters[0];
                        Nre.initForLicenses();
                        EntitlementApi.EntitlementStatus deviceCodeStatus = deviceCodeApi.getDeviceCode();
                        if (!deviceCodeStatus.isSuccess()) {
                            sysLog.log(Level.WARNING, "Device code fetch failed with error: " + deviceCodeStatus.getMessage());
                            sysLog.log(Level.SEVERE, "Cannot proceed with registration");
                            return;
                        }
                        Nre.println("****************************************************************************");
                        Nre.println("**** Please go to the Verification URL and enter the User Code to approve ");
                        Nre.println("**** the subscription for this Niagara instance");
                        Nre.println("****");
                        Nre.println("**** Verification URL: " + deviceCodeStatus.getVerificationUri());
                        Nre.println("**** User Code:        " + deviceCodeStatus.getUserCode());
                        Nre.println("****************************************************************************");
                        AccessTokenApi.Poll.start((String)deviceCodeStatus.getDeviceCode(), (int)deviceCodeStatus.getInterval());
                        while (!AccessTokenApi.isAccessTokenPollComplete()) {
                            sysLog.log(Level.FINE, "Waiting for access token polling to complete...");
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                sysLog.log(Level.FINE, "Failed to make the thread sleep till the next poll.", e);
                            }
                        }
                        if (AccessTokenApi.getAccessTokenPollStatus().isFailure()) {
                            sysLog.log(Level.SEVERE, "Access token poll failed with error: " + AccessTokenApi.getAccessTokenPollStatus().getMessage());
                            sysLog.log(Level.SEVERE, "Cannot proceed with registration");
                            return;
                        }
                        EntitlementApi.EntitlementStatus status = registrationApi.register(AccessTokenApi.getAccessTokenPollStatus(), subscriptionKey);
                        if (!status.isSuccess()) {
                            sysLog.log(Level.SEVERE, "Registration failed: " + status.getMessage());
                        }
                    } else {
                        sysLog.log(Level.INFO, "Please provide a valid Subscription Key as the only parameter.");
                    }
                    return;
                }
                if (args.hasOption("checksub")) {
                    Nre.initForLicenses();
                    slm.checkSubscription();
                    return;
                }
                if (args.hasOption("rotatekeys")) {
                    Nre.initForLicenses();
                    slm.rotateKeysApi();
                    return;
                }
                if (args.hasOption("updateLicenses")) {
                    Nre.initForLicenses();
                    Nre.updateSubscriptionLicenses(slm);
                    return;
                }
                if (args.hasOption("regenerate")) {
                    if ("cloned".equals(SubscriptionLicenseUtil.getHostIdStatus()) || "unregistered".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                        slm.regenerateNreId();
                    } else {
                        sysLog.info("Cannot regenerate Host Id when it is not cloned or unregistered.");
                    }
                    return;
                }
            }
            if (Nre.args.parameters.length < 1) {
                Nre.usage();
                return;
            }
            if (rawArgs.length > 0 && WB_MAIN.equals(rawArgs[0])) {
                showLoadingSplash = true;
                Nre.showLoadingSplashScreen();
            }
            Nre.boot();
            if (isStation && SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.SUBSCRIPTION) {
                Nre.printSubscriptionStationInstructions(SubscriptionLicenseUtil.getHostIdStatus());
            }
            sysLog.info("Niagara runtime booted (\"" + niagaraHome + "\") on " + NreLib.getHostId() + " (" + (System.currentTimeMillis() - Bootstrap.bootTime) + "ms)");
            String locale = args.getOption("locale");
            if (locale != null) {
                Nre.setDefaultLocale(locale);
            } else {
                Nre.setDefaultLocale(Locale.getDefault());
            }
            NModule module = null;
            String className = Nre.args.parameters[0];
            int colon = className.indexOf(58);
            if (colon > 0) {
                String moduleName = className.substring(0, colon);
                className = className.substring(colon + 1);
                try {
                    for (NModule m : moduleManager.loadModuleParts(moduleName)) {
                        try {
                            m.loadClass(className);
                            module = m;
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                }
                catch (ModuleNotFoundException e) {
                    Nre.fatal("FATAL: Module not found: " + moduleName);
                }
            }
            String[] mainArgs = new String[rawArgs.length - 1];
            System.arraycopy(rawArgs, 1, mainArgs, 0, mainArgs.length);
            Nre.runClass(module, className, mainArgs);
        }
        catch (FatalException e) {
            System.exit(-7);
        }
        catch (Throwable e) {
            sysLog.log(Level.SEVERE, "Cannot boot", e);
            if (e instanceof LicenseException) {
                System.exit(-3);
            }
            System.exit(-7);
        }
        finally {
            if (showLoadingSplash) {
                Nre.hideLoadingSplashScreen();
            }
        }
    }

    private static void printSubscriptionStationInstructions(String hostIdStatus) {
        String model = NreLib.getHostModel();
        switch (hostIdStatus) {
            case "unregistered": {
                Nre.println("*******************************************************");
                Nre.println("**** This is an unregistered subscription instance!");
                if ("Workstation".equals(model)) {
                    Nre.println("**** Register your station instance using command:");
                    Nre.println("**** nre -register <yourSubscriptionKey>");
                    Nre.println("**** Generate a new Host ID using command:");
                    Nre.println("**** nre -regenerate");
                } else {
                    Nre.println("**** Register your station instance or generate a");
                    Nre.println("**** new Host ID using the License Manager");
                }
                Nre.println("*******************************************************");
                break;
            }
            case "cloned": {
                Nre.println("*******************************************************");
                Nre.println("**** This is a cloned subscription instance!");
                if ("Workstation".equals(model)) {
                    Nre.println("**** Generate a new Host ID using command:");
                    Nre.println("**** nre -regenerate");
                } else {
                    Nre.println("**** Generate a new Host ID using the");
                    Nre.println("**** License Manager");
                }
                Nre.println("*******************************************************");
                break;
            }
        }
    }

    private static RuntimeProfile[] parseSupportedProfiles(String toParse) {
        TreeSet<RuntimeProfile> accum = new TreeSet<RuntimeProfile>();
        accum.add(RuntimeProfile.rt);
        for (String value : toParse.split(",")) {
            RuntimeProfile p = RuntimeProfile.valueOf((String)value, null);
            if (p != null) {
                accum.add(p);
                continue;
            }
            sysLog.log(Level.WARNING, String.format("%s is not a valid runtime profile", value));
        }
        return accum.toArray(new RuntimeProfile[0]);
    }

    private static boolean shouldCheckNreLicense(NModule module, String className) {
        if (module != null) {
            if ("workbench".equals(module.getModuleName()) && "com.tridium.workbench.shell.WbMain".equals(className)) {
                return false;
            }
            if ("portalApi".equals(module.getModuleName()) && "com.tridium.portal.util.LicenseDownload".equals(className)) {
                return false;
            }
        }
        return true;
    }

    private static void showLoadingSplashScreen() {
        Nre.loadingSplashScreen("show");
    }

    private static void hideLoadingSplashScreen() {
        Nre.loadingSplashScreen("hide");
    }

    private static void loadingSplashScreen(String cmd) {
        try {
            Class<?> cls = Class.forName("com.tridium.splash.ui.LoadingSplashScreen");
            Method getInstance = cls.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = getInstance.invoke(null, new Object[0]);
            Method toInvoke = cls.getDeclaredMethod(cmd, new Class[0]);
            toInvoke.invoke(instance, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void runClass(NModule module, String className, String[] mainArgs) {
        if (Nre.shouldCheckNreLicense(module, className)) {
            licenseManager.checkFeature("tridium", "nre");
        }
        Class<?> cls = null;
        try {
            cls = module != null ? module.loadClass(className) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Nre.fatal("FATAL: Cannot find class: " + className);
        }
        Method main = null;
        try {
            Class[] params = new Class[]{String[].class};
            assert (cls != null);
            main = cls.getMethod("main", params);
            if (!main.getReturnType().equals(Void.TYPE)) {
                Nre.fatal("FATAL: Main must return void: " + className);
            }
            if (!Modifier.isPublic(main.getModifiers())) {
                Nre.fatal("FATAL: Main must be public: " + className);
            }
            if (!Modifier.isStatic(main.getModifiers())) {
                Nre.fatal("FATAL: Main must be static: " + className);
            }
        }
        catch (Exception e) {
            Nre.fatal("FATAL: No main: " + className);
        }
        try {
            Object[] invokeArgs = new Object[]{mainArgs};
            assert (main != null);
            main.invoke(null, invokeArgs);
        }
        catch (InvocationTargetException e) {
            sysLog.log(Level.SEVERE, "Cannot boot", e.getTargetException());
            System.exit(-7);
        }
        catch (Throwable e) {
            sysLog.log(Level.SEVERE, "Cannot boot", e);
            System.exit(-7);
        }
    }

    public static File getNiagaraHome() {
        return niagaraHome;
    }

    public static void setDefaultLocale(String locale) {
        try {
            StringTokenizer st = new StringTokenizer(locale, "_");
            String lang = st.nextToken();
            String country = "";
            if (st.hasMoreTokens()) {
                country = st.nextToken();
            }
            String variant = "";
            if (st.hasMoreTokens()) {
                variant = st.nextToken(" \t\n\r\f").substring(1);
            }
            Nre.setDefaultLocale(new Locale(lang, country, variant));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDefaultLocale(Locale locale) {
        Locale.setDefault(locale);
        language = Locale.getDefault().getLanguage();
    }

    public static void setDefaultTimeZone(String id) {
        try {
            TimeZone tz = TimeZone.getTimeZone(id);
            if (tz != null && tz.getID().equalsIgnoreCase(id)) {
                TimeZone.setDefault(tz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void dumpProps() {
        Nre.boot();
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> e = AccessController.doPrivileged(() -> System.getProperties()).propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = AccessController.doPrivileged(() -> System.getProperty(key));
            list.add(key + " = " + value);
        }
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            System.out.println((String)list.get(i));
        }
    }

    public static boolean boot() {
        return Nre.boot(new DefaultBootEnv());
    }

    public static synchronized boolean boot(BootEnv bootEnv) {
        String[] params;
        if (isBooted) {
            return false;
        }
        isBooted = true;
        Nre.bootEnv = bootEnv;
        isRemote = bootEnv.isRemote();
        niagaraHome = bootEnv.getNiagaraHome();
        niagaraUserHome = bootEnv.getNiagaraUserHome();
        stdoutManager = new StdoutManager();
        LogSettings.bootstrap(niagaraUserHome);
        if (!Nre.bootEnv.isRemote()) {
            SyslogManager.getInstance().reloadProperties();
        }
        sysLog.log(Level.INFO, "Logging initialized");
        niagaraSharedUserHome = new File(niagaraUserHome, "shared");
        if (!niagaraSharedUserHome.exists()) {
            try {
                if (!niagaraSharedUserHome.mkdir()) {
                    sysLog.log(Level.SEVERE, "Failed to create shared user home directory");
                }
            }
            catch (SecurityException se) {
                sysLog.log(Level.SEVERE, "Failed to create shared user home directory", se);
            }
        }
        NiagaraFiles.unpackDefaults();
        ISecurityInitializer securityInitializer = SecurityInitializer.getInstance();
        if (!SecurityConstants.canCheckTpk()) {
            sysLog.log(Level.WARNING, "**** DEVELOPER BUILD FOR INTERNAL TRIDIUM USE ONLY ****");
        }
        Nre.verifyPolicyFiles();
        boolean doBuildCredentialsHome = false;
        String[] stringArray = params = args != null ? Nre.args.parameters : new String[]{};
        if (params.length >= 2 && params[0].equals("com.tridium.sys.station.Station")) {
            String project = params[1];
            protectedStationHome = new File(niagaraUserHome, "stations" + File.separator + project);
            stationHome = new File(protectedStationHome, "shared");
            if (protectedStationHome.exists() && !stationHome.exists()) {
                try {
                    if (!stationHome.mkdir()) {
                        sysLog.log(Level.SEVERE, "Failed to create shared station home directory");
                    }
                }
                catch (SecurityException se) {
                    sysLog.log(Level.SEVERE, "Failed to create shared station home directory", se);
                }
            }
            isStation = true;
            hasBootClass = true;
        } else if (params.length >= 1) {
            hasBootClass = true;
            if (!niagaraUserHome.exists() && !niagaraUserHome.mkdirs()) {
                Nre.fatal("Could not create user home directory");
            }
            doBuildCredentialsHome = true;
        }
        DefaultModulesFileManager.get().ifPresent(manager -> manager.init(true));
        NiagaraPermissionGroupFactory.init();
        NiagaraPolicy.PolicyType policyType = NiagaraPolicy.PolicyType.WORKBENCH;
        if (isStation) {
            policyType = NiagaraPolicy.PolicyType.STATION;
        }
        if (Nre.isTest()) {
            policyType = NiagaraPolicy.PolicyType.STATION;
        }
        NiagaraPolicyUtil.init((AbstractPermissionGroupStore)new GrantAllPermissionGroupStore(), (NiagaraPolicy.PolicyType)policyType);
        if (args != null && args.hasOption("version")) {
            Logger.getLogger("").setLevel(Level.SEVERE);
            Logger.getLogger("sys.registry").setLevel(Level.SEVERE);
        }
        if (doBuildCredentialsHome) {
            Nre.buildCredentialsHome();
        }
        AccessController.doPrivileged(() -> System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", "com.tridium.nre.util.NreForkJoinWorkerThreadFactory"));
        Nre.loadSystemProperties();
        Nre.overrideSecurityProperties();
        DiagnosticUtil.checkDiagnosticSecurityManager();
        Nre.checkSystemTimeWorkaround();
        String lang = AccessController.doPrivileged(() -> System.getProperty("niagara.lang", null));
        if (lang != null) {
            Nre.setDefaultLocale(lang);
        }
        mainThreadGroup = Nre.findMainThreadGroup(Thread.currentThread().getThreadGroup());
        UserFileRepositoryCopy.copyFileRepo();
        registryManager = new NRegistry();
        schemaManager = new SchemaManager();
        moduleManager = new ModuleManager();
        engineManager = new EngineManager();
        leaseManager = new LeaseManager();
        serviceManager = new ServiceManager();
        licenseManager = NLicenseManager.make();
        stationManager = new StationManager();
        resourceManager = new ResourceManager();
        metricsRecount = new Metrics.Recount();
        networkInterfaceManager = new NetworkInterfaceManager();
        hsmManager = HsmManagerImpl.make((ClassLoader)Nre.class.getClassLoader());
        Spy.ROOT.add("sysInfo", new SysInfoSpy());
        Spy.ROOT.add("stdout", new StdoutManager.SpyPage(stdoutManager));
        Spy.ROOT.add("console", new ConsoleSpyDir());
        Spy.ROOT.add("systemProperties", new SystemPropertiesSpy());
        spySysManagers = new SpyDir();
        Spy.ROOT.add("sysManagers", spySysManagers);
        Spy.ROOT.add("util", new UtilSpy());
        Spy.ROOT.add("classLoaders", new ModuleClassLoader.LoaderSpy());
        Spy.ROOT.add("metrics", new Metrics.MetricSpy());
        Spy.ROOT.add("logSetup", new LogSetupSpy());
        securitySpy = new SecuritySpyDir();
        Spy.ROOT.add("securityInfo", securitySpy);
        stdoutManager.postInit();
        boolean registryRebuilt = registryManager.postInit();
        moduleManager.initSystemJars();
        if (registryRebuilt) {
            moduleManager.registerOnLoadCallback(new PermissionGroupLoggingCallback());
        }
        schemaManager.postInit();
        licenseManager.postInit();
        moduleManager.postInit();
        engineManager.postInit();
        leaseManager.postInit();
        serviceManager.postInit();
        stationManager.postInit();
        resourceManager.postInit();
        DiagnosticSpy.postInit();
        BQueryScheme.postInit();
        networkInterfaceManager.postInit();
        Nre.verifyFipsLicense();
        Nre.checkSecurityManagerDisable();
        ModuleVerificationMode sysPropertiesPref = ModuleVerificationMode.noPreference;
        String verificationProp = AccessController.doPrivileged(() -> System.getProperty("niagara.moduleVerificationMode"));
        if (verificationProp != null) {
            try {
                sysPropertiesPref = ModuleVerificationMode.valueOf((String)verificationProp);
            }
            catch (IllegalArgumentException e) {
                sysLog.warning("Invalid argument provided for niagara.moduleVerificationMode property: " + verificationProp);
            }
        }
        NModule baja = moduleManager.loadModule("baja", RuntimeProfile.rt);
        moduleVerificationMode = ModuleVerificationMode.make((ModuleVerificationMode)sysPropertiesPref, (Version)new Version(baja.getVendorVersion().toString()));
        if (sysLog.isLoggable(Level.FINE)) {
            sysLog.fine("Module verification mode set to " + moduleVerificationMode.toString());
        }
        signatureRegistry = JarSignatureRegistry.buildSignatureRegistry();
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.unitTestMode")).booleanValue()) {
            sysLog.warning("System is running unit test mode. This may have unexpected effects in a production setting.");
        }
        Spy.ROOT.add("nav", new ObjectSpy(BNavRoot.INSTANCE));
        BModuleSpace.INSTANCE.getNavName();
        BFileSystem.INSTANCE.getNavName();
        BSpySpace.INSTANCE.getNavName();
        vmUuid = BUuid.make().toString();
        try {
            Class<?> CryptoPlatformPageClass;
            if (stationHome == null) {
                CertManagerFactory.getInstance();
            }
            if ((CryptoPlatformPageClass = Sys.loadClass("platCrypto", "com.tridium.platcrypto.spy.CryptoPlatformPage")) != null) {
                securitySpy.add("Cryptography Info", (Spy)CryptoPlatformPageClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (ModuleNotFoundException m) {
            sysLog.fine("Platform cryptography module is not installed, skipping cryptography initialization");
        }
        catch (Exception e) {
            sysLog.log(Level.WARNING, "Failed to initialize the platform cryptography manager: ", e);
        }
        Nre.initDevEnvironment();
        ThreadLocalRandom.current();
        DefaultModulesFileManager.get().ifPresent(manager -> manager.clearCachedManifests());
        return true;
    }

    public static ThreadGroup findMainThreadGroup(ThreadGroup baseGroup) {
        NiagaraBasicPermission findThreadGroupPermission = new NiagaraBasicPermission("FIND_MAIN_THREAD_GROUP");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)findThreadGroupPermission);
        }
        return AccessController.doPrivileged(new FindMainThreadGroupPrivilegedAction(baseGroup));
    }

    static void buildCredentialsHome() {
        if (credentialsHome == null && !(credentialsHome = new File(niagaraUserHome, "etc" + File.separator + "credentials")).exists()) {
            sysLog.fine("creating user credentials directory");
            if (!credentialsHome.mkdirs()) {
                Nre.fatal("could not create user credentials directory");
            }
        }
    }

    static void loadSystemProperties() {
        Nre.loadSystemProperties(NiagaraFiles.getSystemPropertiesPath());
    }

    static void loadSystemProperties(File systemPropertiesFile) {
        if (systemPropertiesFile.exists()) {
            try (FileInputStream in = new FileInputStream(systemPropertiesFile);){
                Properties sysProps = new Properties();
                sysProps.load(in);
                Nre.addToSystemProperties(systemPropertiesFile, sysProps);
            }
            catch (Exception e) {
                System.out.println("ERROR: Cannot load " + systemPropertiesFile + ": " + e);
            }
        }
    }

    private static void addToSystemProperties(File systemPropertiesFile, Properties props) {
        boolean hasSystemPropsWriteAccess = Nre.hasWritePermissionsToSystemPropertiesFile(systemPropertiesFile);
        if (!hasSystemPropsWriteAccess) {
            String[] blacklistedProps;
            String blacklistProperty = props.getProperty("niagara.commandLinePropertyBlacklist", DEFAULT_COMMAND_LINE_BLACKLIST);
            System.setProperty("niagara.commandLinePropertyBlacklist", blacklistProperty);
            for (String blacklistedProp : blacklistedProps = blacklistProperty.split(",")) {
                String trimmedBlacklistedProp = blacklistedProp.trim();
                if (trimmedBlacklistedProp.isEmpty() || System.getProperty(trimmedBlacklistedProp) == null && System.getProperty(NRE_PROP + trimmedBlacklistedProp) == null) continue;
                AccessController.doPrivileged(() -> System.clearProperty(trimmedBlacklistedProp));
                AccessController.doPrivileged(() -> System.clearProperty(NRE_PROP + trimmedBlacklistedProp));
                sysLog.warning("Ignoring command line property <" + trimmedBlacklistedProp + ">. User does not have permissions to override system.properties");
            }
        }
        for (String key : props.stringPropertyNames()) {
            if (AccessController.doPrivileged(() -> System.getProperty(key)) != null && AccessController.doPrivileged(() -> System.getProperty(NRE_PROP + key)) != null) {
                if (hasSystemPropsWriteAccess) continue;
                sysLog.warning("Ignoring command line property <" + key + ">. User does not have permissions to override system.properties");
            }
            AccessController.doPrivileged(() -> System.getProperties().setProperty(key, props.getProperty(key).trim()));
        }
    }

    private static boolean hasWritePermissionsToSystemPropertiesFile(File systemPropertiesFile) {
        FileLock fileLock = null;
        try {
            fileLock = FileLock.lock((File)systemPropertiesFile);
            boolean bl = true;
            return bl;
        }
        catch (FileLockException | IOException throwable) {
        }
        finally {
            if (fileLock != null) {
                fileLock.unlock();
            }
        }
        return false;
    }

    private static void overrideSecurityProperties() {
        for (String overrideProperty : ALLOWED_SECURITY_OVERRIDES) {
            String override = System.getProperty("niagara.securityOverride." + overrideProperty);
            if (override == null) continue;
            sysLog.info("Overriding security property " + overrideProperty + " to " + override);
            Security.setProperty(overrideProperty, override);
        }
    }

    private static void verifyPolicyFiles() {
        String securityFileName = new File(NiagaraFiles.getSecurityPolicyPath(), "java.security").getAbsolutePath();
        try {
            TextFileSignatureVerifier.verifyFile((String)securityFileName, (TextFileSignatureVerifier.CommentLine)TextFileSignatureVerifier.CommentLine.SECURITY, (ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
        }
        catch (Exception e) {
            Nre.fatal("Security file verification failed. Security files may have been tampered with. Cause is: [" + e.getMessage() + "]");
        }
        String bootstrapPolicyName = new File(NiagaraFiles.getSecurityPolicyPath(), "java.policy").getAbsolutePath();
        try {
            TextFileSignatureVerifier.verifyFile((String)bootstrapPolicyName, (TextFileSignatureVerifier.CommentLine)TextFileSignatureVerifier.CommentLine.POLICY, (ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
        }
        catch (Exception e) {
            Nre.fatal("Policy file verification failed. Policy files may have been tampered with. Cause is: [" + e.getMessage() + "]");
        }
    }

    private static void verifyFipsLicense() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "fips140-2");
            if (!SecurityInitializer.getInstance().isFips()) {
                throw new Exception();
            }
        }
        catch (FeatureNotLicensedException e) {
            if (SecurityInitializer.getInstance().isFips()) {
                Nre.fatal("FIPS mode is enabled but FIPS is not licensed: [" + e.getMessage() + "]");
            }
        }
        catch (Exception e) {
            sysLog.log(Level.SEVERE, Nre.getFipsLicensedButDisabledBanner());
        }
    }

    private static String getFipsLicensedButDisabledBanner() {
        String stars = "*******************************************************";
        String warning = Lexicon.make("baja").getText("fips.warning.licensedButDisabled");
        int starsLength = Math.max((stars.length() - warning.length() - 2) / 2, 0);
        int extraStar = (stars.length() - warning.length()) % 2;
        char[] starArray = new char[starsLength + extraStar];
        Arrays.fill(starArray, '*');
        String shortStarsAfter = new String(starArray);
        String shortStarsBefore = shortStarsAfter.substring(0, starsLength);
        return "\n" + stars + "\n" + stars + "\n" + shortStarsBefore + " " + warning + " " + shortStarsAfter + "\n" + stars + "\n" + stars;
    }

    public static void checkSystemTimeWorkaround() {
        if ("true".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.forceTimeHighResolution", "false")))) {
            sysLog.info("Forcing time to use 1ms resolution");
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(Integer.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    private static void checkSecurityManagerDisable() {
        if (Nre.hasSecurityManagerExemption()) {
            SecurityManagerUtil.disableSecurityManager();
            return;
        }
        String disable = AccessController.doPrivileged(() -> System.getProperty("niagara.security.manager.disable"));
        if (disable != null) {
            try {
                licenseManager.checkFeature("tridium", "smDeveloperMode");
                String logFileName = DeveloperSecurityManager.enableDeveloperSecurityManager((NiagaraPolicy.PolicyType)(isStation ? NiagaraPolicy.PolicyType.STATION : NiagaraPolicy.PolicyType.WORKBENCH));
                System.err.println("*******************************************************************************");
                sysLog.severe("Security Manager developer mode enabled. It is recommended to switch off this mode as soon as possible.");
                sysLog.severe("Security Manager Exceptions are being written to " + logFileName);
                System.err.println("*******************************************************************************");
            }
            catch (FeatureNotLicensedException ignore) {
                sysLog.warning("A request was made to run in Security Manager developer mode, but the system is not licensed for it.");
            }
        }
    }

    private static final boolean hasSecurityManagerExemption() {
        return args != null && Nre.args.parameters != null && Nre.args.parameters.length > 0 ? smExemptionList.contains(Nre.args.parameters[0]) : false;
    }

    private static boolean isTest() {
        return args != null && Nre.args.parameters != null && Nre.args.parameters.length > 0 ? testRunnerNames.contains(Nre.args.parameters[0]) : false;
    }

    private static void initDevEnvironment() {
        if (System.getenv("niagara_dev_home") != null) {
            niagaraDevHome = new File(System.getenv("niagara_dev_home"));
        } else if (AccessController.doPrivileged(() -> System.getProperty("niagara.dev.home")) != null) {
            niagaraDevHome = new File(AccessController.doPrivileged(() -> System.getProperty("niagara.dev.home")));
        }
    }

    public static BIPlatform getPlatform() {
        if (platform == null) {
            platform = new BNullPlatform();
        }
        return platform;
    }

    public static void loadPlatform() {
        if (platform != null && !(platform instanceof BNullPlatform)) {
            return;
        }
        try {
            TypeInfo[] platTypes = registryManager.getConcreteTypes(BIPlatform.TYPE.getTypeInfo());
            if (platTypes.length == 1 || platTypes.length > 1 && !platTypes[0].equals(BNullPlatform.TYPE.getTypeInfo())) {
                platform = (BIPlatform)((Object)platTypes[0].getInstance());
            } else if (platTypes.length > 1 && platTypes[0].equals(BNullPlatform.TYPE.getTypeInfo())) {
                platform = (BIPlatform)((Object)platTypes[1].getInstance());
            }
            platform.initPlatform();
        }
        catch (Throwable e) {
            sysLog.log(Level.SEVERE, "Cannot load platform", e);
            platform = new BNullPlatform();
        }
    }

    public static void clearPlatform() {
        platform = null;
    }

    public static void version() {
        Nre.println("");
        Nre.println("Niagara Runtime Environment");
        Nre.println("  java.version:              " + AccessController.doPrivileged(() -> System.getProperty("java.version")));
        Nre.println("  java.vendor:               " + AccessController.doPrivileged(() -> System.getProperty("java.vendor")));
        Nre.println("  java.vm.name:              " + AccessController.doPrivileged(() -> System.getProperty("java.vm.name")));
        Nre.println("  java.vm.version:           " + AccessController.doPrivileged(() -> System.getProperty("java.vm.version")));
        Nre.println("  java.home:                 " + AccessController.doPrivileged(() -> System.getProperty("java.home")));
        Nre.println("  niagara.home:              " + AccessController.doPrivileged(() -> System.getProperty("niagara.home")));
        Nre.println("  niagara.user.home:         " + AccessController.doPrivileged(() -> System.getProperty("niagara.user.home")));
        Nre.println("  niagara.platform.provider: " + AccessController.doPrivileged(() -> System.getProperty("niagara.platform.provider")));
        Nre.println("  nre.hostId:                " + Nre.getHostId());
        Nre.println("  nre.hostModel:             " + Nre.getHostModel());
        Nre.println("  nre.hostModelVersion:      " + Nre.getHostModelVersion());
        Nre.println("  nre.hostProduct:           " + Nre.getHostProduct());
        Nre.boot();
        NModule baja = moduleManager.loadModule("baja", RuntimeProfile.rt);
        Nre.println("  nre.bajaVersion:   " + baja.getBajaVersion());
        Nre.println("  nre.vendor:        " + baja.getVendor());
        Nre.println("  nre.vendorVersion: " + baja.getVendorVersion());
    }

    public static void modules(String arg) {
        Nre.boot();
        if (arg == null || arg.isEmpty()) {
            arg = "*";
        }
        arg = arg.toLowerCase();
        PatternFilter pattern = new PatternFilter(arg);
        ModuleInfo[] modules = Sys.getRegistry().getModules();
        ArrayList<ModuleInfo> acc = new ArrayList<ModuleInfo>();
        for (ModuleInfo m : modules) {
            if (!pattern.accept(m.getModuleName().toLowerCase())) continue;
            acc.add(m);
        }
        ModuleInfo[] result = acc.toArray(new ModuleInfo[0]);
        int maxName = 0;
        int maxVendor = 0;
        for (ModuleInfo m : result) {
            maxName = Math.max(m.getModulePartName().length(), maxName);
            maxVendor = Math.max(m.getVendor().length(), maxVendor);
        }
        for (ModuleInfo m : result) {
            Nre.println(TextUtil.pad((String)m.getModulePartName(), (int)maxName) + "  " + TextUtil.pad((String)m.getVendor(), (int)maxVendor) + "  " + m.getVendorVersion());
        }
    }

    public static void hostId() {
        Nre.println("HostId: " + Nre.getHostId());
    }

    public static void licenses() {
        Nre.initForLicenses();
        licenseManager.reload();
        licenseManager.dump();
    }

    private static void initForLicenses() {
        Nre.initNiagaraHomeForLicense();
        String bajaProp = AccessController.doPrivileged(() -> System.getProperty("niagara.user.home"));
        if (bajaProp == null) {
            System.out.println("ERROR:  niagara.user.home not defined");
            return;
        }
        niagaraUserHome = new File(bajaProp);
        bootEnv = new DefaultBootEnv();
        NiagaraPolicyUtil.init((AbstractPermissionGroupStore)new GrantAllPermissionGroupStore(), (NiagaraPolicy.PolicyType)NiagaraPolicy.PolicyType.STATION);
        registryManager = new NRegistry();
        schemaManager = new SchemaManager();
        moduleManager = new ModuleManager();
        licenseManager = NLicenseManager.make();
        LogSettings.bootstrap(niagaraUserHome);
        if (!registryManager.isRegistryUpToDate()) {
            registryManager.rebuild();
        }
    }

    private static void updateSubscriptionLicenses(SubscriptionLicenseManager slm) {
        Nre.initForLicenses();
        slm.getLicenseUpdate();
    }

    public static void rebootLicenseManager() {
        if (!isBooted) {
            return;
        }
        if (licenseManager != null) {
            licenseManager.shutdown();
        }
        licenseManager = NLicenseManager.make();
        licenseManager.postInit();
    }

    public static void initNiagaraHomeForLicense() {
        if (niagaraHome == null) {
            String bajaProp = AccessController.doPrivileged(() -> System.getProperty("niagara.home"));
            if (bajaProp == null) {
                sysLog.severe("ERROR: niagara.home not defined");
                return;
            }
            niagaraHome = new File(bajaProp);
        }
    }

    public static void licenseFailure() {
        Nre.licenseFailure(true);
    }

    public static void licenseFailure(boolean isPeriodicCheck) {
        if (Nre.isTest()) {
            return;
        }
        if (args != null) {
            for (String parameter : Nre.args.parameters) {
                if (!WB_MAIN.equals(parameter) || isPeriodicCheck) continue;
                try {
                    licenseManager.checkFeature("tridium", "workbenchAzul");
                    licenseManager.checkFeature("tridium", "nre");
                }
                catch (FeatureNotLicensedException e) {
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.exit(-3);
    }

    public static void buildreg() {
        NRegistry.forceRebuild = true;
        Nre.boot();
    }

    public static void watch(String[] rawArgs) {
        AccessController.doPrivileged(() -> System.setProperty("niagara.unitTestMode", "true"));
        String excludeKey = "niagara.intern.excludeTypes";
        String excludeTypes = AccessController.doPrivileged(() -> System.getProperty(excludeKey));
        if (excludeTypes != null && !excludeTypes.matches("baja:TypeSpec")) {
            AccessController.doPrivileged(() -> System.setProperty(excludeKey, excludeTypes + ";baja:TypeSpec"));
        } else {
            AccessController.doPrivileged(() -> System.setProperty(excludeKey, "baja:TypeSpec"));
        }
        Nre.boot();
        try {
            licenseManager.checkFeature("tridium", "developer");
        }
        catch (FeatureNotLicensedException notLicensed) {
            Nre.fatal("A developer license is required to run the NRE in watch mode");
        }
        String[] mainArgs = new String[rawArgs.length - 1];
        System.arraycopy(rawArgs, 1, mainArgs, 0, mainArgs.length);
        int watchIndex = -1;
        for (int i = 0; i < mainArgs.length; ++i) {
            if (!"-watch".equalsIgnoreCase(mainArgs[i])) continue;
            watchIndex = i;
            break;
        }
        if (watchIndex > -1) {
            mainArgs = ArrayUtil.removeOne(mainArgs, watchIndex);
        }
        CommandLineArguments args = new CommandLineArguments(mainArgs);
        Console console = new Console();
        console.start();
        TestWatcher watcher = TestWatcher.getInstance();
        watcher.setTestArgs(args);
        watcher.start();
    }

    private static void initKm() throws Exception {
        if (Nre.args.parameters.length < 2) {
            throw new Exception("invalid parameters for km");
        }
        if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
            throw new Exception("invalid platform for km");
        }
        NreInstantiator instantiator = new NreInstantiator();
        SingletonSupplier secIntSupplier = new SingletonSupplier(ISecurityInitializer.class, SecurityInitializer.class, (IConfiguration)new ISecurityInitializerConfig(){

            public File getSecDir() {
                return new File(niagaraUserHome, "security");
            }

            public String getKmName() {
                return ".km";
            }
        });
        instantiator.addSupplier((TypeSupplier)secIntSupplier);
        ISecurityInitializer instance = (ISecurityInitializer)instantiator.instance(ISecurityInitializer.class);
        try {
            instance.initSecurityInfo(false);
        }
        catch (SecurityException se) {
            instance.initSecurityInfo(true);
        }
    }

    public static void testheap() {
        Nre.println("Test Heap");
        Nre.dumpheap("Start");
        byte[][] buffers = new byte[1000][];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new byte[0x100000];
            Nre.dumpheap("Alloc " + i + "MB");
        }
    }

    public static void dumpheap(String msg) {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        System.out.println(msg + " [Total=" + Nre.mem(total) + " Used=" + Nre.mem(used) + "]");
    }

    public static String mem(long mem) {
        if (mem < 0x100000L) {
            return mem / 1024L + "KB";
        }
        return mem / 0x100000L + "MB";
    }

    static void println(String s) {
        System.out.println(s);
    }

    static void print(Throwable e) {
        Nre.println("  " + e);
    }

    static void fatal(String s) {
        System.out.println(s);
        throw new FatalException();
    }

    static void fatal(String s, Throwable e) {
        Nre.println(s);
        if (e != null) {
            ThrowableUtil.dump(System.out, e);
        }
        throw new FatalException();
    }

    public static void dumpThreads() {
        NreLib.dumpThreads();
    }

    public static String getHostId() {
        return NreLib.getHostId();
    }

    public static String getHostModel() {
        return NreLib.getHostModel();
    }

    public static String getHostModelVersion() {
        return NreLib.getHostModelVersion();
    }

    public static String getHostProduct() {
        return NreLib.getHostProduct();
    }

    public static RuntimeProfile[] getSupportedProfiles() {
        return Arrays.copyOf(supportedProfiles, supportedProfiles.length);
    }

    public static boolean supportsProfile(RuntimeProfile profile) {
        for (RuntimeProfile supportedProfile : supportedProfiles) {
            if (profile != supportedProfile) continue;
            return true;
        }
        return false;
    }

    public static File getNiagaraDevHome() {
        return niagaraDevHome;
    }

    public static StdoutManager getStdoutManager() {
        return stdoutManager;
    }

    public static ModuleManager getModuleManager() {
        return moduleManager;
    }

    public static NRegistry getRegistryManager() {
        return registryManager;
    }

    public static SchemaManager getSchemaManager() {
        return schemaManager;
    }

    public static EngineManager getEngineManager() {
        return engineManager;
    }

    public static LeaseManager getLeaseManager() {
        return leaseManager;
    }

    public static ServiceManager getServiceManager() {
        return serviceManager;
    }

    public static NLicenseManager getLicenseManager() {
        return licenseManager;
    }

    public static StationManager getStationManager() {
        return stationManager;
    }

    public static ResourceManager getResourceManager() {
        return resourceManager;
    }

    public static Metrics.Recount getMetricsRecount() {
        return metricsRecount;
    }

    public static NetworkInterfaceManager getNetworkInterfaceManager() {
        return networkInterfaceManager;
    }

    public static HsmManager getHsmManager() {
        return hsmManager;
    }

    public static ModuleVerificationMode getModuleVerificationMode() {
        return moduleVerificationMode;
    }

    public static JarSignatureRegistry getJarSignatureRegistry() {
        return signatureRegistry;
    }

    public static SecurityAuditor getSecurityAuditor() {
        return securityAuditor;
    }

    public static void setSecurityAuditor(SecurityAuditor securityAuditor) {
        NiagaraBasicPermission setSecurityAuditorPermission = new NiagaraBasicPermission("SET_SECURITY_AUDITOR");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)setSecurityAuditorPermission);
        }
        Nre.securityAuditor = securityAuditor;
    }

    static {
        testRunnerNames.add("test:javax.baja.test.TestRunner");
        testRunnerNames.add("javax.baja.test.TestRunner");
        smExemptionList.addAll(testRunnerNames);
        smExemptionList.add("migrator:com.tridium.migrator.Migrate");
        smExemptionList.add("com.tridium.migrator.Migrate");
        bootTime = System.currentTimeMillis();
        supportedProfiles = new RuntimeProfile[]{RuntimeProfile.rt, RuntimeProfile.ux, RuntimeProfile.wb, RuntimeProfile.se, RuntimeProfile.doc};
        niagaraDevHome = null;
        credentialsHome = null;
        stationHome = null;
        protectedStationHome = null;
        language = "en";
        unitConversion = 0;
        moduleVerificationMode = ModuleVerificationMode.low;
        signatureRegistry = null;
        isStation = false;
        isRemote = false;
        hasBootClass = false;
        sysLog = Logger.getLogger("sys");
        GET_MANAGER_PERMISSION = new NiagaraBasicPermission("GET_MANAGER");
        ALLOWED_SECURITY_OVERRIDES = new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"};
    }

    static class FatalException
    extends RuntimeException {
        FatalException() {
        }
    }

    private static class PermissionGroupLoggingCallback
    implements Consumer<NModule[]> {
        private final boolean skip;

        public PermissionGroupLoggingCallback() {
            boolean skip = false;
            if ("false".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.security.logPermissionGroups", "true")))) {
                try {
                    Sys.getLicenseManager().checkFeature("tridium", "developer");
                    skip = true;
                }
                catch (FeatureNotLicensedException featureNotLicensedException) {
                    // empty catch block
                }
            }
            this.skip = skip;
            if (!this.skip) {
                sysLog.info("Registry has changed. Modules will be checked for additional permissions on load.");
            }
        }

        @Override
        public void accept(NModule[] modules) {
            if (this.skip) {
                return;
            }
            for (NModule m : modules) {
                String moduleUrl;
                if (!m.hasRequestedPermissions()) continue;
                try {
                    moduleUrl = NiagaraPolicyUtil.canonicalizeCodeSource((String)m.moduleFile.getFile().getPath());
                }
                catch (IOException e) {
                    if (!sysLog.isLoggable(Level.FINE)) continue;
                    sysLog.log(Level.FINE, "Could not map URL for module " + m.getModulePartName(), e);
                    continue;
                }
                Set permissionGroups = AccessController.doPrivileged(() -> NiagaraPolicyUtil.getAllPermissionGroups((String)moduleUrl));
                if (permissionGroups.isEmpty() || !sysLog.isLoggable(Level.INFO)) continue;
                for (NiagaraPermissionGroup group : permissionGroups) {
                    StringJoiner message = new StringJoiner(System.lineSeparator());
                    message.add("Additional permission found for module <" + moduleUrl + ">:");
                    message.add("Type: " + group.getType());
                    message.add(" Purpose: " + group.getPurpose());
                    message.add(" Parameters: " + group.getParameters());
                    message.add(" Risk Level: " + group.getRiskLevel());
                    sysLog.log(Level.INFO, message.toString());
                }
            }
        }
    }

    private static class FindMainThreadGroupPrivilegedAction
    implements PrivilegedAction<ThreadGroup> {
        private final ThreadGroup baseGroup;

        protected FindMainThreadGroupPrivilegedAction(ThreadGroup baseGroup) {
            this.baseGroup = baseGroup;
        }

        @Override
        public ThreadGroup run() {
            ThreadGroup mainGroup = null;
            ThreadGroup group = this.baseGroup;
            while (group.getParent() != null) {
                if (group.getName().equals("main")) {
                    mainGroup = group;
                    break;
                }
                group = group.getParent();
            }
            if (mainGroup == null) {
                group = mainGroup = this.baseGroup;
                while (group.getParent() != null) {
                    mainGroup = group;
                    group = group.getParent();
                }
            }
            return mainGroup;
        }
    }
}

