/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.ExpiredTicketException;

public final class NClockTicket
implements Clock.Ticket {
    long nextUpdate;
    long period;
    BComponent component;
    Action action;
    BValue arg;
    NClockTicket next;

    public NClockTicket(BComponent component, Action action, BValue arg) {
        this.component = component;
        this.action = action;
        this.arg = arg;
    }

    @Override
    public final void cancel() {
        this.nextUpdate = 0L;
        this.period = -1L;
        this.component = null;
        this.action = null;
        this.arg = null;
    }

    @Override
    public final boolean isExpired() {
        return this.component == null;
    }

    @Override
    public final BComponent getComponent() {
        if (this.isExpired()) {
            throw new ExpiredTicketException();
        }
        return this.component;
    }

    @Override
    public final Action getAction() {
        if (this.isExpired()) {
            throw new ExpiredTicketException();
        }
        return this.action;
    }

    @Override
    public final BValue getActionArgument() {
        if (this.isExpired()) {
            throw new ExpiredTicketException();
        }
        return this.arg;
    }

    public String toString() {
        if (this.isExpired()) {
            return "Ticket: expired";
        }
        BFacets facets = BFacets.make("showMilliseconds", BBoolean.TRUE);
        return "Ticket nextUpdate=" + BAbsTime.make(Clock.millis() + this.millisLeft()).toString(facets) + " period=" + this.period;
    }

    public final long millisLeft() {
        if (this.nextUpdate < 0L) {
            return -this.nextUpdate - Clock.ticks();
        }
        return this.nextUpdate - Clock.millis();
    }

    final long process(long curTicks, long curMillis) {
        BComponent component = this.component;
        Action action = this.action;
        BValue arg = this.arg;
        if (component == null) {
            return Long.MIN_VALUE;
        }
        if (!component.isRunning()) {
            return Long.MIN_VALUE;
        }
        if (this.nextUpdate < 0L) {
            if (curTicks >= -this.nextUpdate) {
                if (this.period == 0L) {
                    this.cancel();
                } else {
                    this.nextUpdate = -(curTicks + this.period);
                }
                EngineUtil.invoke(component, action, arg, null);
            }
        } else if (curMillis >= this.nextUpdate) {
            if (this.period == 0L) {
                this.cancel();
            } else {
                this.nextUpdate += this.period;
            }
            EngineUtil.invoke(component, action, arg, null);
        }
        if (this.component == null || this.nextUpdate == 0L) {
            return Long.MIN_VALUE;
        }
        if (this.nextUpdate < 0L) {
            return -this.nextUpdate - curTicks;
        }
        return this.nextUpdate - curMillis;
    }
}

