/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.subscription;

import com.tridium.json.JSONObject;
import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.EntitlementException;
import com.tridium.nre.subscription.EntitlementStatusListener;
import com.tridium.nre.subscription.EntitlementUtil;
import com.tridium.nre.subscription.JwtSignatureKeys;
import com.tridium.nre.subscription.LicenseRefreshToken;
import com.tridium.nre.subscription.RequestCertificates;
import com.tridium.nre.subscription.RetrieveEntitlements;
import com.tridium.nre.subscription.RotateKeys;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.util.LicenseMode;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.sys.Nre;
import com.tridium.sys.license.CertificateFile;
import com.tridium.sys.license.LicenseFile;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.sys.license.subscription.EntitlementCheck;
import com.tridium.sys.license.subscription.KeyRotationCheck;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.nre.util.FileUtil;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class SubscriptionLicenseManager
extends NLicenseManager {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> keyRotation;
    private ScheduledFuture<?> entitlementCheck;
    private static final File SUBSCRIPTION_DIRECTORY = NiagaraFiles.getSubscriptionPath();
    private static final File CERTIFICATE_DIRECTORY = new File(SUBSCRIPTION_DIRECTORY, "certificates");
    private static final File LICENSE_DIRECTORY = new File(SUBSCRIPTION_DIRECTORY, "licenses");
    private static final File CLONED_FILE = new File(SUBSCRIPTION_DIRECTORY, ".cloned");
    private static final RotateKeys ROTATE_KEYS = new RotateKeys();
    private static final TemporalAmount ROTATE_KEYS_CHECK_FREQ = Duration.ofDays(1L);
    private static final TemporalAmount KEY_ROTATION_FREQUENCY = Period.ofDays(90);
    private static final long ROTATE_KEYS_RETRY_DELAY_MS = 100L;
    private int periodicCheckFailureCount;
    private int periodicFailureLimit = Integer.parseInt("3");
    private TemporalAmount entitlementCheckFrequency = Duration.ofHours(Integer.parseInt("6"));
    static final long THIRTY_MINUTES = Duration.ofMinutes(30L).getSeconds();
    static final int ENTITLEMENT_ADDITIONAL_RANDOM_SECONDS_BOUND = 900;
    static final long ENTITLEMENT_RETRY_DELAY_MS = 100L;
    private final Set<EntitlementStatusListener> listeners = new HashSet<EntitlementStatusListener>();
    private static final LicenseFile[] EMPTY_LICENSE_FILE_ARRAY = new LicenseFile[0];
    private static final Logger logger = Logger.getLogger("sys.license");
    private static final String SUBSCRIPTION_FEATURE_VENDOR = "tridium";
    private static final String SUBSCRIPTION_CHECK_RETRY_LIMIT_DEFAULT = "3";
    private static final String SUBSCRIPTION_CHECK_FREQUENCY_DEFAULT = "6";
    public static final String SUBSCRIPTION_FEATURE_NAME = "subscriptionMode";
    private static final String SUBSCRIPTION_CHECK_RETRY_LIMIT = "validCheckRetry.limit";
    private static final String SUBSCRIPTION_CHECK_FREQUENCY = "validCheckFreq";

    public SubscriptionLicenseManager() {
        if (!SUBSCRIPTION_DIRECTORY.exists()) {
            try {
                if (!SUBSCRIPTION_DIRECTORY.mkdir()) {
                    throw new RuntimeException("Unable to create the subscription license folder");
                }
            }
            catch (Exception e) {
                SubscriptionLicenseManager.exit("Failed to create the subscription license folder", e);
            }
        }
        this.initializeLrt();
    }

    public void initializeLrt() {
        LrtHolder.lrt.setNreId(Nre.getHostId());
        String productId = "station";
        if (Nre.args != null) {
            for (String parameter : Nre.args.parameters) {
                if (!"workbench:com.tridium.workbench.shell.WbMain".equals(parameter)) continue;
                productId = "workbench";
                break;
            }
        }
        if (Nre.args != null && Nre.args.parameters.length >= 2 && "station".equals(Nre.args.parameters[0])) {
            productId = productId + '_' + Nre.args.parameters[1];
        }
        LrtHolder.lrt.setProductId(productId);
    }

    @Override
    public void postInit() {
        if (SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.SUBSCRIPTION) {
            if (!"ok".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                try {
                    this.deleteLicensesAndCertificatesFile();
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.SEVERE, "Failed to delete entitlements when Host ID is not registered.", e);
                    }
                    logger.log(Level.SEVERE, "Failed to delete entitlements when Host ID is not registered: " + e.getMessage());
                }
                super.postInit();
                return;
            }
            this.load();
            if (this.getLicenses().length == 0) {
                RetrieveEntitlements re = new RetrieveEntitlements(LrtHolder.lrt);
                this.checkEntitlement(re, 100L, false);
            }
        }
        super.postInit();
        this.initPeriodicEntitlementCheck();
        this.initPeriodicKeyRotation();
    }

    public EntitlementApi.EntitlementStatus updateCertificates(RequestCertificates rc, String vendor) {
        String[] certificateVendors = new String[]{vendor};
        String certificateVersion = rc.getCertificateVersion();
        EntitlementApi.EntitlementStatus status = rc.getCertificates(LrtHolder.lrt.getNreId(), certificateVendors, certificateVersion);
        if (!status.isSuccess()) {
            logger.warning("No certificates retrieved from the entitlement system - attempt to use existing certificates.");
            return status;
        }
        if (rc.isCertificateUpdated() || this.getCertificates() == null || this.getCertificates().length == 0) {
            this.setCertificates(this.loadCertificates());
        }
        if (this.getCertificates() == null || this.getCertificates().length == 0) {
            logger.warning("No certificates were found during update.");
        }
        return status;
    }

    private void initPeriodicKeyRotation() {
        if (this.keyRotation != null) {
            this.keyRotation.cancel(false);
        }
        this.keyRotation = this.scheduler.scheduleAtFixedRate(new KeyRotationCheck(this), 0L, ROTATE_KEYS_CHECK_FREQ.get(ChronoUnit.SECONDS), TimeUnit.SECONDS);
    }

    private void initPeriodicEntitlementCheck() {
        if (this.entitlementCheck != null) {
            this.entitlementCheck.cancel(false);
        }
        try {
            Feature subscriptionFeature = this.checkFeature(SUBSCRIPTION_FEATURE_VENDOR, SUBSCRIPTION_FEATURE_NAME);
            String retryLimit = subscriptionFeature.get(SUBSCRIPTION_CHECK_RETRY_LIMIT, SUBSCRIPTION_CHECK_RETRY_LIMIT_DEFAULT);
            this.periodicFailureLimit = Integer.parseInt(retryLimit);
            String checkFrequency = subscriptionFeature.get(SUBSCRIPTION_CHECK_FREQUENCY, SUBSCRIPTION_CHECK_FREQUENCY_DEFAULT);
            int checkFrequencyHours = Integer.parseInt(checkFrequency);
            this.entitlementCheckFrequency = Duration.ofHours(checkFrequencyHours);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "License feature was not found for \"subscriptionMode\".", e);
            }
            logger.log(Level.WARNING, "License feature was not found for \"subscriptionMode\": " + e.getMessage());
        }
        long additionalRandomSeconds = Duration.ofSeconds(SubscriptionLicenseUtil.SECURE_RANDOM.nextInt(900)).getSeconds();
        this.entitlementCheck = this.scheduler.scheduleAtFixedRate(new EntitlementCheck(this), this.entitlementCheckFrequency.get(ChronoUnit.SECONDS) + THIRTY_MINUTES + additionalRandomSeconds, this.entitlementCheckFrequency.get(ChronoUnit.SECONDS) + additionalRandomSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        if (this.entitlementCheck != null) {
            this.entitlementCheck.cancel(true);
        }
        if (this.keyRotation != null) {
            this.keyRotation.cancel(true);
        }
        this.scheduler.shutdownNow();
        super.shutdown();
    }

    public boolean isKeyRotationNeeded() {
        Instant keysGenerationTime = JwtSignatureKeys.getInstance().getGenerationTime();
        return !keysGenerationTime.equals(Instant.EPOCH) && keysGenerationTime.plus(KEY_ROTATION_FREQUENCY).isBefore(Instant.now());
    }

    LicenseRefreshToken getLicenseRefreshToken() {
        return LrtHolder.lrt;
    }

    public void refreshLrtIfNreIdChanged() {
        if (!this.getLicenseRefreshToken().getNreId().equals(Nre.getHostId())) {
            this.initializeLrt();
        }
    }

    private static void exit(String reason, Exception e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.SEVERE, reason, e);
        } else {
            logger.log(Level.SEVERE, reason);
        }
        System.exit(-3);
    }

    public void checkSubscription() {
        Nre.initNiagaraHomeForLicense();
        String hostId = Nre.getHostId();
        if (SubscriptionLicenseUtil.getLicenseMode() != LicenseMode.SUBSCRIPTION) {
            logger.info("This Host Id " + hostId + " is not configured for subscription licensing.");
            return;
        }
        if (EntitlementUtil.isRegistered()) {
            logger.info("This Host Id " + hostId + " has been registered with the entitlement system.");
        } else {
            logger.info("The registration process has not yet been initiated for Host Id " + hostId);
        }
    }

    public void checkEntitlementPeriodically() {
        RetrieveEntitlements re = new RetrieveEntitlements(LrtHolder.lrt);
        this.checkEntitlement(re, 100L, true);
    }

    public void checkEntitlement() {
        RetrieveEntitlements re = new RetrieveEntitlements(LrtHolder.lrt);
        this.checkEntitlement(re, 100L, false);
    }

    public void checkEntitlement(RetrieveEntitlements re, long retryDelay, boolean isPeriodicCheck) {
        if (!EntitlementUtil.isRegistered()) {
            logger.severe("Host Id " + Nre.getHostId() + " has not been registered with the entitlement system, so the entitlement check cannot proceed.");
            Nre.licenseFailure();
        }
        EntitlementApi.EntitlementStatus entitlementStatus = re.retrieveEntitlements(retryDelay);
        this.updateEntitlementStatus(entitlementStatus);
        if (!entitlementStatus.isSuccess()) {
            if (isPeriodicCheck && entitlementStatus.isFailure() && RetrieveEntitlements.isRetryableError((int)entitlementStatus.getCode())) {
                ++this.periodicCheckFailureCount;
                logger.warning("Entitlement check failed (" + entitlementStatus.getCode() + "). " + (this.periodicFailureLimit - this.periodicCheckFailureCount) + " attempts remaining.");
                if (this.periodicCheckFailureCount >= this.periodicFailureLimit) {
                    logger.severe("The entitlement check failed for Host Id " + Nre.getHostId() + ". Failed " + this.periodicCheckFailureCount + " check-ins.");
                    Nre.licenseFailure();
                }
                return;
            }
            if (entitlementStatus.isRestore()) {
                logger.warning("Restore workflow is not yet supported - manual recovery is required.");
                Nre.licenseFailure(isPeriodicCheck);
                return;
            }
            if (entitlementStatus.isInvalidRefreshToken()) {
                if (!"cloned".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                    try {
                        this.createClonedFile();
                        this.deleteLicensesAndCertificatesFile();
                    }
                    catch (Exception e) {
                        logger.severe("Failed to generate cloned file or delete licenses/certificates: " + e.getMessage());
                    }
                    Nre.licenseFailure(isPeriodicCheck);
                }
                logger.severe("This instance has been cloned. Please regenerate Host Id and register.");
                return;
            }
            logger.severe("The entitlement check failed for Host Id " + Nre.getHostId() + '.');
            Nre.licenseFailure(isPeriodicCheck);
            return;
        }
        if (entitlementStatus.isSuccess()) {
            this.periodicCheckFailureCount = 0;
        }
        if (entitlementStatus.isSuccess() && isPeriodicCheck && re.isLicenseUpdated()) {
            this.reload();
        }
        logger.info("Entitlement check succeeded.");
        try {
            this.deleteClonedFile();
        }
        catch (IOException e) {
            logger.severe("Failed to delete cloned file: " + e.getMessage());
        }
    }

    void updateEntitlementStatus(EntitlementApi.EntitlementStatus status) {
        for (EntitlementStatusListener listener : this.listeners) {
            listener.entitlementCheckin(status);
        }
    }

    public void addEntitlementStatusListener(EntitlementStatusListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntitlementStatusListener(EntitlementStatusListener listener) {
        this.listeners.remove(listener);
    }

    public EntitlementApi.EntitlementStatus getLicenseUpdate() {
        LrtHolder.lrt.updateRefreshIncrement();
        JSONObject requestBody = new JSONObject().put("nreId", (Object)LrtHolder.lrt.getNreId()).put("productId", (Object)LrtHolder.lrt.getProductId()).put("refreshIncrement", LrtHolder.lrt.getRefreshIncrement()).put("restoreId", (Object)LrtHolder.lrt.getRestoreId()).put("nonce", LrtHolder.lrt.getNonce());
        RetrieveEntitlements re = new RetrieveEntitlements(LrtHolder.lrt);
        EntitlementApi.EntitlementStatus status = this.getLicenseUpdate(requestBody, re);
        this.updateEntitlementStatus(status);
        return status;
    }

    public EntitlementApi.EntitlementStatus getLicenseUpdate(JSONObject requestBody, RetrieveEntitlements re) {
        try {
            XElem[] licenseElems;
            ArrayList<XElem> licenseList = new ArrayList<XElem>();
            EntitlementApi.EntitlementStatus es = re.entitlementsApi(requestBody, false);
            if (!es.isSuccess()) {
                logger.warning("Subscription license update failed: " + es.getMessage());
                return es;
            }
            for (XElem elem : licenseElems = es.getLicenses().elems("license")) {
                SubscriptionLicenseUtil slu = SubscriptionLicenseUtil.getInstance();
                if (!slu.writeLicense(elem)) continue;
                VendorLicense license = VendorLicense.make("entitlement", elem);
                logger.info("Subscription license updated for vendor: " + license.getVendor());
                licenseList.add(elem);
            }
            if (licenseList.isEmpty()) {
                logger.warning("Subscription license update request did not find any updates");
                return new EntitlementApi.EntitlementStatus(EntitlementApi.EntitlementState.SUCCESS, es.getCode(), es.getMessage());
            }
            EntitlementApi.EntitlementStatus response = new EntitlementApi.EntitlementStatus(EntitlementApi.EntitlementState.SUCCESS, 200, "");
            for (XElem license : licenseList) {
                response.addEntitlement(license);
            }
            return response;
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "Subscription license update exception", e);
            } else {
                logger.log(Level.WARNING, "Subscription license update exception: " + e.getMessage());
            }
            return new EntitlementApi.EntitlementStatus(EntitlementApi.EntitlementState.FAILURE, 500, e.getMessage());
        }
    }

    public static boolean isLicenseSignatureValid(XElem licenseElem, File certificateFile) {
        CertificateFile cert = new CertificateFile(certificateFile);
        cert.load(null);
        if (!cert.isValid()) {
            logger.log(Level.WARNING, "License signature verification failed: supplied certificate not valid");
            return false;
        }
        XElem sigElem = licenseElem.elem("signature");
        if (sigElem == null) {
            logger.log(Level.WARNING, "License signature verification failed: no license signature found");
            return false;
        }
        String signatureAlgorithm = sigElem.get("algorithm", null);
        if (signatureAlgorithm == null) {
            logger.log(Level.WARNING, "License signature verification failed: no license signature algorithm defined");
            return false;
        }
        PublicKey publicKey = cert.getPublicKey();
        byte[] sig = Base64.getMimeDecoder().decode(sigElem.string());
        licenseElem.removeContent((XContent)sigElem);
        try {
            byte[] xml = LicenseUtil.encode(licenseElem);
            if (!LicenseUtil.verify(xml, sig, publicKey, signatureAlgorithm)) {
                logger.log(Level.WARNING, "License signature verification failed: signature could not be not validated against public key");
                return false;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "License signature validation caused exception", e);
            } else {
                logger.log(Level.WARNING, "License signature validation caused exception: " + e.getMessage());
            }
            return false;
        }
        logger.log(Level.FINE, "License signature verification succeeded.");
        return true;
    }

    @Override
    protected LicenseFile[] loadLicenses() {
        ArrayList<SubscriptionLicense> v = new ArrayList<SubscriptionLicense>();
        File srcDir = SubscriptionLicenseManager.getSubscriptionLicenseDirectory();
        File[] list = srcDir.listFiles();
        if (list != null) {
            for (File file : list) {
                if (!file.getName().toLowerCase().endsWith(".license")) continue;
                SubscriptionLicense lic = new SubscriptionLicense(file);
                lic.load(this);
                v.add(lic);
            }
        }
        return v.toArray(EMPTY_LICENSE_FILE_ARRAY);
    }

    @Override
    protected File getLicensingDirectory() {
        return SubscriptionLicenseManager.getSubscriptionDirectory();
    }

    public static File getSubscriptionDirectory() {
        if (!SUBSCRIPTION_DIRECTORY.exists()) {
            try {
                Files.createDirectory(SUBSCRIPTION_DIRECTORY.toPath(), new FileAttribute[0]);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create the subscription license folder " + SUBSCRIPTION_DIRECTORY, ioe);
            }
        }
        return SUBSCRIPTION_DIRECTORY;
    }

    public static File getSubscriptionCertificateDirectory() {
        if (!CERTIFICATE_DIRECTORY.exists() && !CERTIFICATE_DIRECTORY.mkdir()) {
            throw new RuntimeException("Unable to create the certificate folder");
        }
        return CERTIFICATE_DIRECTORY;
    }

    public static File getSubscriptionLicenseDirectory() {
        if (!LICENSE_DIRECTORY.exists() && !LICENSE_DIRECTORY.mkdir()) {
            throw new RuntimeException("Unable to create the subscription licenses folder");
        }
        return LICENSE_DIRECTORY;
    }

    public CertificateFile getCertificateForVendor(String vendor) {
        CertificateFile cert = null;
        NLicenseManager licenseManager = Nre.getLicenseManager();
        try {
            cert = licenseManager.getCertificate(vendor);
        }
        catch (Exception e) {
            RequestCertificates rc = new RequestCertificates();
            this.updateCertificates(rc, vendor);
            try {
                cert = licenseManager.getCertificate(vendor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cert;
    }

    public void rotateKeysApi() {
        Nre.initNiagaraHomeForLicense();
        if (SubscriptionLicenseUtil.getLicenseMode() != LicenseMode.SUBSCRIPTION) {
            logger.info("This Host Id " + Nre.getHostId() + " is not configured for subscription licensing.");
            return;
        }
        try {
            EntitlementApi.EntitlementStatus keyRotationResult = new RotateKeys().rotateKeysApi();
            if (!keyRotationResult.isSuccess()) {
                logger.log(Level.WARNING, "Key rotation failed: " + keyRotationResult.getMessage());
            } else {
                logger.log(Level.FINE, "Key rotation successful");
            }
        }
        catch (EntitlementException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Key rotation failed", e);
            }
            logger.log(Level.SEVERE, "Key rotation failed");
        }
    }

    public void rotateKeys() {
        this.rotateKeys(100L);
    }

    public void rotateKeys(long retryDelay) {
        block9: {
            try {
                EntitlementApi.EntitlementStatus keyRotationResult = ROTATE_KEYS.rotateKeysApi();
                if (!keyRotationResult.isSuccess()) {
                    logger.log(Level.WARNING, "Key rotation failed: " + keyRotationResult.getMessage());
                } else {
                    logger.log(Level.FINE, "Key rotation successful");
                }
            }
            catch (EntitlementException e) {
                String message = "Key rotation failure \"" + e.getMessage() + "\", retrying in " + retryDelay + "ms";
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, message, e);
                } else {
                    logger.log(Level.WARNING, message);
                }
                long nextAttempt = retryDelay * 2L;
                long nextRotationCheck = Long.MAX_VALUE;
                if (this.keyRotation != null) {
                    nextRotationCheck = this.keyRotation.getDelay(TimeUnit.MILLISECONDS) + ROTATE_KEYS_CHECK_FREQ.get(ChronoUnit.SECONDS) * 1000L;
                }
                if (nextRotationCheck <= nextAttempt) break block9;
                try {
                    Thread.sleep(retryDelay);
                    this.rotateKeys(nextAttempt);
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
        }
    }

    public void regenerateNreId() {
        try {
            String hostId = SubscriptionLicenseUtil.regenerateNreId();
            logger.info("Successfully regenerated Host Id. New Host Id: " + hostId);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Failed to regenerate Host Id: " + e.getMessage(), e);
            }
            logger.severe("Failed to regenerate Host Id: " + e.getMessage());
        }
    }

    @Override
    public void dump(PrintWriter out) {
        super.dump(out);
        AccessController.doPrivileged(() -> {
            out.println("");
            out.println("Subscription License");
            if (EntitlementUtil.isRegistered()) {
                out.println("  Registered at " + EntitlementUtil.getRegistrationTime());
                out.println("  Last subscription license check: " + EntitlementCheck.getLastRunInstant().toString());
                if (this.entitlementCheck != null) {
                    long delaySecondsLeft = this.entitlementCheck.getDelay(TimeUnit.SECONDS);
                    out.println("  Next subscription license check: " + Instant.now().plusSeconds(delaySecondsLeft).toString());
                }
            } else {
                out.println("  Not Registered");
            }
            return null;
        });
    }

    private synchronized void createClonedFile() throws IOException {
        if (CLONED_FILE.createNewFile()) {
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(CLONED_FILE.toPath(), new OpenOption[0]));){
                out.writeUTF(Instant.now().toString());
            }
        }
    }

    private synchronized void deleteClonedFile() throws IOException {
        FileUtil.delete((File)CLONED_FILE);
    }

    private synchronized void deleteLicensesAndCertificatesFile() throws IOException {
        if (LICENSE_DIRECTORY.exists()) {
            SubscriptionLicenseManager.deleteDirectoryContents(LICENSE_DIRECTORY);
        }
        if (CERTIFICATE_DIRECTORY.exists()) {
            SubscriptionLicenseManager.deleteDirectoryContents(CERTIFICATE_DIRECTORY);
        }
    }

    private static void deleteDirectoryContents(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    SubscriptionLicenseManager.deleteDirectoryContents(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new IOException("Unable to delete file: " + file.getName());
            }
        }
        if (!directory.delete()) {
            throw new IOException("Unable to delete directory: " + directory.getName());
        }
    }

    public static class SubscriptionLicense
    extends LicenseFile {
        File file;

        public SubscriptionLicense(File file) {
            this.file = file;
        }

        @Override
        protected String getLicenseName() {
            return this.file.getName();
        }

        @Override
        protected XElem getRoot() throws Exception {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));){
                XElem xElem = XParser.make((InputStream)bufferedInputStream).parse(false);
                return xElem;
            }
        }

        @Override
        protected boolean isLicenseHostIdValid() {
            return this.hostId.equals(Nre.getHostId());
        }
    }

    private static final class LrtHolder {
        static final LicenseRefreshToken lrt = new LicenseRefreshToken();

        private LrtHolder() {
        }
    }
}

