/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.metrics;

import com.tridium.sys.metrics.Group;
import java.util.StringTokenizer;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;

class GlobalGroup
extends Group {
    boolean isGlobalEnabled = false;
    static final String FEATURE_NAME = "globalCapacity";
    final Group.Count links = new Group.Count();
    final Group.Count histories = new Group.Count();
    final Group.Count schedules = new Group.Count();
    final Array<String> excludedNetworks = new Array(String.class);
    final Array<String> excludedDevices = new Array(String.class);
    final Array<String> excludedPoints = new Array(String.class);

    GlobalGroup() {
        super(FEATURE_NAME);
        try {
            Feature feature = Sys.getLicenseManager().getFeature("tridium", FEATURE_NAME);
            try {
                feature.check();
                this.networks.limit = GlobalGroup.parseLimit(feature, "network.limit");
                this.devices.limit = GlobalGroup.parseLimit(feature, "device.limit");
                this.points.limit = GlobalGroup.parseLimit(feature, "point.limit");
                this.links.limit = GlobalGroup.parseLimit(feature, "link.limit");
                this.histories.limit = GlobalGroup.parseLimit(feature, "history.limit");
                this.schedules.limit = GlobalGroup.parseLimit(feature, "schedule.limit");
                GlobalGroup.parseModules(feature, "excludedNetworks", this.excludedNetworks);
                GlobalGroup.parseModules(feature, "excludedDevices", this.excludedDevices);
                GlobalGroup.parseModules(feature, "excludedPoints", this.excludedPoints);
                this.isGlobalEnabled = true;
            }
            catch (FeatureNotLicensedException e) {
                e.printStackTrace();
            }
        }
        catch (FeatureNotLicensedException e) {
            this.networks.limit = Integer.MAX_VALUE;
            this.devices.limit = Integer.MAX_VALUE;
            this.points.limit = Integer.MAX_VALUE;
            this.links.limit = Integer.MAX_VALUE;
            this.histories.limit = Integer.MAX_VALUE;
            this.schedules.limit = Integer.MAX_VALUE;
        }
    }

    @Override
    boolean isGlobal() {
        return true;
    }

    protected static void parseModules(Feature feature, String key, Array<String> modules) {
        String val = feature.get(key);
        if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
            StringTokenizer st = new StringTokenizer(val, ",;");
            while (st.hasMoreTokens()) {
                modules.add((Object)st.nextToken());
            }
        }
    }
}

