/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.metrics;

import javax.baja.license.Feature;
import javax.baja.nre.util.TextUtil;

abstract class Group
implements Comparable<Group> {
    final String featureName;
    final Count networks = new Count();
    final Count devices = new Count();
    final Count points = new Count();

    Group(String featureName) {
        this.featureName = featureName;
    }

    protected static int parseLimit(Feature feature, String key) {
        String val = feature.get(key);
        int limit = Integer.MAX_VALUE;
        if (val != null && !TextUtil.toLowerCase((String)val).equals("none")) {
            limit = Integer.parseInt(val);
        }
        return limit;
    }

    public String toString() {
        return String.format("[Group %s]", this.featureName);
    }

    @Override
    public int compareTo(Group group) {
        return this.featureName.compareTo(group.featureName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Group)) {
            return false;
        }
        Group that = (Group)obj;
        return this.featureName.equals(that.featureName);
    }

    public int hashCode() {
        return this.featureName.hashCode();
    }

    abstract boolean isGlobal();

    static class Count {
        int limit = 0;
        int used = 0;

        Count() {
        }
    }
}

