/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.asm.Buffer;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.ValidationException;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.SecurityConstants;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicyUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.module.Dependency;
import com.tridium.sys.module.ModuleExtClassLoader;
import com.tridium.sys.module.ModuleExtJar;
import com.tridium.sys.module.NModule;
import com.tridium.util.jar.ModuleEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.security.Timestamp;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import javax.security.auth.x500.X500Principal;

public class ModuleClassLoader
extends SecureClassLoader {
    private static final DecimalFormat DF = new DecimalFormat("###,###,###");
    static final boolean legacyExtClassLoader = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.classLoader.ext"));
    private ClassCache cache = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.classLoader.useSharedCache")) != false ? new SharedClassCache() : new PerModuleClassCache();
    private static final Map<String, int[]> SPY_MAP;
    public static final Logger log;
    private static final String COM_TRIDIUM = "com/tridium/";
    private static final String JAVAX_BAJA = "javax/baja/";
    private static final boolean AGGRESSIVE_CACHING_ENABLED;
    public final NModule module;
    private volatile NModule lastModuleScanned;
    private final ClassLoader parent;
    private final boolean validateCertChain;
    protected CodeSource codeSource;
    private Buffer buffer;
    private Permissions permissions;
    private final Map<String, List<ModuleExtClassLoader>> extClassLoadersByResourcePath;
    private boolean loggedWarning = false;
    private Set<Dependency> dependencies;
    private static final String UNSIGNED = "No code signers for entry %s in module %s. Signed modules will be required in a future release.";
    private static final String SIGNER_SELF_SIGNED = "Entry %s in module %s is signed with a self-signed certificate. Self-signed signing certificates will not be allowed by default in a future release.";
    private static final String TIMESTAMP_SELF_SIGNED = "Entry %s in module %s is timestamped self-signed certificate. Self-signed timestamp certificates will not be allowed by default in a future release.";
    private static final String NO_TIMESTAMP = "Signature for entry %s in module %s is not timestamped. This signature will fail to validate when the signing certificate expires.";
    private static final String CERT_VALIDATION_FAILURE = "Could not validate certificate path for entry %s in module %s: %s";

    ModuleClassLoader(NModule module) {
        super(module.getClass().getClassLoader());
        this.parent = module.getClass().getClassLoader();
        this.module = module;
        URL url = null;
        if (module.moduleFile != null) {
            url = module.moduleFile.getFileURL();
        }
        boolean requiresSignature = false;
        if (module.hasRequestedPermissions()) {
            requiresSignature = module.getRequestedNiagaraPermissions().stream().anyMatch(NiagaraPermissionGroup::requiresSignature);
        }
        boolean bl = this.validateCertChain = requiresSignature && SkipModuleValidationHolder.SKIP_MODULE_VALIDATION == false;
        if (requiresSignature && !this.validateCertChain) {
            log.warning("[" + module.getModulePartName() + "]: module validation is disabled");
        }
        this.codeSource = new CodeSource(url, (Certificate[])null);
        this.permissions = new Permissions();
        if (!module.getRequestedNiagaraPermissions().isEmpty()) {
            try {
                NiagaraPolicyUtil.requestPermissions((String)NiagaraPolicyUtil.canonicalizeCodeSource((URL)url), module.getRequestedNiagaraPermissions());
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Unable to request permissions for " + this.module.moduleName);
                log.log(Level.FINE, "Caused by: ", e);
            }
        }
        HashMap<String, ArrayList<ModuleExtClassLoader>> extClassLoaders = null;
        if (module.extJars != null) {
            for (ModuleExtJar extJar : module.extJars) {
                ModuleExtClassLoader loader = new ModuleExtClassLoader(this, extJar, this.codeSource);
                for (String path : extJar.resourcePaths) {
                    ArrayList<ModuleExtClassLoader> loaders;
                    if (extClassLoaders == null) {
                        extClassLoaders = new HashMap<String, ArrayList<ModuleExtClassLoader>>();
                    }
                    if ((loaders = (ArrayList<ModuleExtClassLoader>)extClassLoaders.get(path)) == null) {
                        loaders = new ArrayList<ModuleExtClassLoader>();
                        extClassLoaders.put(path, loaders);
                    }
                    loaders.add(loader);
                }
            }
        }
        this.extClassLoadersByResourcePath = extClassLoaders;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.nload(name, resolve);
        if (c == null) {
            throw new ClassNotFoundException(this.module.modulePartName + ":" + name);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> nload(String name, boolean resolve) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Object obj = this.cache.get(name);
            if (obj == ClassCache.notPreviouslyFound) {
                return null;
            }
            Class<?> cls = (Class<?>)obj;
            if (cls == null) {
                cls = this.nfind(name, resolve);
                this.cache.put(name, cls);
            }
            if (cls != null && resolve) {
                this.resolveClass(cls);
            }
            return cls;
        }
    }

    Object getLoadClassLock(String name) {
        return this.getClassLoadingLock(name);
    }

    Class<?> defineExtClass(String name, byte[] buf, int off, int len, CodeSource codeSource) {
        return this.doDefineClass(name, buf, off, len, codeSource);
    }

    private Class<?> doDefineClass(String name, byte[] buf, int off, int len, CodeSource codeSource) {
        String packageName;
        int i = name.lastIndexOf(46);
        if (i != -1 && this.getPackage(packageName = name.substring(0, i)) == null) {
            try {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.defineClass(name, buf, off, len, codeSource);
    }

    protected Class<?> nfind(String name, boolean resolve) {
        boolean doCache = AGGRESSIVE_CACHING_ENABLED;
        return AccessController.doPrivileged(() -> {
            List<ModuleExtClassLoader> loaders;
            if (name.startsWith("auto.")) {
                ModuleClassLoader.addClassToSpy(this.module.modulePartName, this.buffer.count);
                return this.doDefineClass(name, this.buffer.bytes, 0, this.buffer.count, this.codeSource);
            }
            try {
                if (this.parent != null) {
                    return this.parent.loadClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            String path = name.replace('.', '/') + ".class";
            List<ModuleExtClassLoader> list = loaders = this.extClassLoadersByResourcePath != null ? this.extClassLoadersByResourcePath.get(path) : null;
            if (loaders != null) {
                return loaders.get(0).nfind(name, resolve, false);
            }
            if (!this.module.isSynthetic()) {
                ModuleEntry entry = this.module.moduleFile.getJarEntry(path);
                if (entry != null) {
                    try {
                        byte[] buf;
                        int len = (int)entry.getSize();
                        try (InputStream in = entry.getInputStream();){
                            int n;
                            buf = new byte[len];
                            for (int count = 0; count < len; count += n) {
                                n = in.read(buf, count, len - count);
                                if (n >= 0) continue;
                                throw new IOException("Unexpected EOF");
                            }
                        }
                        if (!this.verifyJarEntrySignature(entry)) {
                            return null;
                        }
                        ModuleClassLoader.addClassToSpy(this.module.modulePartName, buf.length);
                        return this.doDefineClass(name, buf, 0, buf.length, this.codeSource);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            } else if (this.module.getTypeClassName(name.substring(name.lastIndexOf(46) + 2)) != null) {
                ModuleClassLoader.addClassToSpy(this.module.modulePartName, this.buffer.count);
                Class<?> synthClass = this.doDefineClass(name, this.buffer.bytes, 0, this.buffer.count, this.codeSource);
                try {
                    Class.forName(synthClass.getName(), true, synthClass.getClassLoader());
                }
                catch (ClassNotFoundException buf) {
                    // empty catch block
                }
                return synthClass;
            }
            if (this.module.depends != null) {
                Class<?> cls;
                NModule d;
                NModule lastModule;
                int lastIndexOfDot = name.lastIndexOf(46);
                String classPackage = lastIndexOfDot == -1 ? "" : name.substring(0, lastIndexOfDot);
                NModule nModule = lastModule = doCache ? this.lastModuleScanned : null;
                if (lastModule != null && lastModule.classLoader != null) {
                    Class<?> cls2;
                    if (lastModule.containsPackage(classPackage) && (cls2 = lastModule.classLoader.nload(name, resolve)) != null) {
                        return cls2;
                    }
                    cls2 = lastModule.classLoader.nload(name, resolve);
                    if (cls2 != null) {
                        return cls2;
                    }
                }
                for (Dependency dependency : this.module.depends) {
                    d = dependency.resolution;
                    if (d.isSystemJar || lastModule == d || !d.containsPackage(classPackage) || (cls = d.classLoader.nload(name, resolve)) == null) continue;
                    this.lastModuleScanned = d;
                    return cls;
                }
                for (Dependency dependency : this.module.depends) {
                    d = dependency.resolution;
                    if (d.isSystemJar || lastModule == d || (cls = d.classLoader.nload(name, resolve)) == null) continue;
                    this.lastModuleScanned = d;
                    return cls;
                }
            }
            return null;
        });
    }

    @Override
    public URL findResource(String path) {
        return AccessController.doPrivileged(() -> this.getResourceImpl(path));
    }

    private URL getResourceImpl(String path) {
        URL url = this.getResourceDirect(path);
        if (url != null) {
            return url;
        }
        for (Dependency dependency : this.getDependencies()) {
            NModule d = dependency.resolution;
            if (d.isSystemJar || (url = d.classLoader.getResourceDirect(path)) == null) continue;
            return url;
        }
        return null;
    }

    private URL getResourceDirect(String path) {
        List<ModuleExtClassLoader> loaders;
        List<ModuleExtClassLoader> list = loaders = this.extClassLoadersByResourcePath != null ? this.extClassLoadersByResourcePath.get(path) : null;
        if (loaders != null) {
            return loaders.get(0).getResourceImpl(path);
        }
        ModuleEntry entry = this.module.moduleFile.getJarEntry(path);
        if (entry != null) {
            return entry.getURL();
        }
        return null;
    }

    private synchronized Set<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<Dependency>();
            if (this.module.depends != null) {
                for (Dependency dependency : this.module.depends) {
                    this.dependencies.add(dependency);
                    NModule d = dependency.resolution;
                    if (d.isSystemJar) continue;
                    this.dependencies.addAll(dependency.resolution.classLoader.getDependencies());
                }
            }
        }
        return this.dependencies;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                URLConnection c = url.openConnection();
                c.connect();
                return c.getInputStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String path) throws IOException {
        List<ModuleExtClassLoader> loaders;
        List<ModuleExtClassLoader> list = loaders = this.extClassLoadersByResourcePath != null ? this.extClassLoadersByResourcePath.get(path) : null;
        if (loaders != null) {
            return Collections.enumeration(loaders.stream().map(loader -> loader.getResourceImpl(path)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        URL res = this.getResourceImpl(path);
        return res == null ? Collections.emptyEnumeration() : Collections.enumeration(Collections.singletonList(res));
    }

    boolean verifyJarEntrySignature(JarEntry entry) {
        if (entry.isDirectory()) {
            return true;
        }
        String name = entry.getName();
        if (name.startsWith("META-INF")) {
            return true;
        }
        boolean shouldCheckTpk = name.startsWith(COM_TRIDIUM) || name.startsWith(JAVAX_BAJA) || this.module.getCheckTpk();
        ModuleVerificationMode verificationMode = Nre.getModuleVerificationMode();
        boolean canCheckTpk = SecurityConstants.canCheckTpk();
        boolean verificationRequired = verificationMode != ModuleVerificationMode.low || (shouldCheckTpk || this.validateCertChain) && canCheckTpk;
        try {
            CoreCryptoManager mgr = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
            CodeSigner[] codeSigners = entry.getCodeSigners();
            if (codeSigners == null || codeSigners.length == 0) {
                Level level;
                if (verificationRequired) {
                    throw new ValidationException("Error validating cert path: No code signers found.");
                }
                Level level2 = level = this.loggedWarning || !canCheckTpk ? Level.FINEST : Level.WARNING;
                if (log.isLoggable(level)) {
                    log.log(level, String.format(UNSIGNED, entry.getName(), this.module.getModulePartName()));
                }
                this.loggedWarning = true;
                return true;
            }
            StringBuilder failCause = new StringBuilder();
            boolean foundValid = false;
            ValidationException exception = null;
            for (CodeSigner codeSigner : codeSigners) {
                try {
                    Level level;
                    Timestamp ts;
                    mgr.validateCertChain(codeSigner, shouldCheckTpk);
                    List<? extends Certificate> certificates = codeSigner.getSignerCertPath().getCertificates();
                    X509Certificate certificate = (X509Certificate)certificates.get(0);
                    if (certificates.size() == 1 && CertUtils.checkDnEquality((X500Principal)certificate.getSubjectX500Principal(), (X500Principal)certificate.getIssuerX500Principal())) {
                        Level level3;
                        if (verificationMode == ModuleVerificationMode.high) {
                            if (failCause.length() != 0) {
                                failCause.append(", ");
                            }
                            failCause.append("Self signed signing certificate not permitted by current module verification mode.");
                            continue;
                        }
                        Level level4 = level3 = this.loggedWarning || !canCheckTpk ? Level.FINEST : Level.WARNING;
                        if (log.isLoggable(level3)) {
                            log.log(level3, String.format(SIGNER_SELF_SIGNED, entry.getName(), this.module.getModulePartName()));
                        }
                        this.loggedWarning = true;
                    }
                    if ((ts = codeSigner.getTimestamp()) != null) {
                        certificates = ts.getSignerCertPath().getCertificates();
                        certificate = (X509Certificate)certificates.get(0);
                        if (certificates.size() == 1 && CertUtils.checkDnEquality((X500Principal)certificate.getSubjectX500Principal(), (X500Principal)certificate.getIssuerX500Principal())) {
                            if (verificationMode == ModuleVerificationMode.high) {
                                if (failCause.length() != 0) {
                                    failCause.append(", ");
                                }
                                failCause.append("Self signed timestamp certificate not permitted by current module verification mode.");
                                continue;
                            }
                            Level level5 = level = this.loggedWarning || !canCheckTpk ? Level.FINEST : Level.WARNING;
                            if (log.isLoggable(level)) {
                                log.log(level, String.format(TIMESTAMP_SELF_SIGNED, entry.getName(), this.module.getModulePartName()));
                            }
                            this.loggedWarning = true;
                        }
                    } else {
                        Level level6 = level = this.loggedWarning || !canCheckTpk ? Level.FINEST : Level.WARNING;
                        if (log.isLoggable(level)) {
                            log.log(level, String.format(NO_TIMESTAMP, entry.getName(), this.module.getModulePartName()));
                        }
                        this.loggedWarning = true;
                    }
                    foundValid = true;
                }
                catch (ValidationException e) {
                    Level level;
                    if (failCause.length() != 0) {
                        failCause.append(", ");
                    }
                    failCause.append(e.getMessage());
                    exception = e;
                    if (verificationRequired) continue;
                    Level level7 = level = this.loggedWarning || !canCheckTpk ? Level.FINEST : Level.WARNING;
                    if (log.isLoggable(level)) {
                        log.log(level, String.format(CERT_VALIDATION_FAILURE, entry.getName(), this.module.getModulePartName(), e.getMessage()));
                    }
                    log.log(Level.FINEST, "Caused by", e);
                    this.loggedWarning = true;
                }
            }
            if (!foundValid && verificationRequired) {
                throw new ValidationException("Error validating cert path: " + failCause, exception);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to load " + entry.getName() + ": " + e.getLocalizedMessage(), e);
            System.exit(-6);
        }
        return true;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        if (cs.equals(this.codeSource)) {
            return this.module.getModuleJavaPermissions();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.codeSource.toString() + ": Not providing permissions for " + cs);
        }
        return this.permissions;
    }

    private static boolean loadSkipModuleValidation() {
        boolean skipModuleValidation = false;
        boolean skipModuleValidationRequested = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.classLoader.skipModuleValidation"));
        if (!skipModuleValidationRequested) {
            skipModuleValidation = false;
        } else {
            try {
                Feature feature = Sys.getLicenseManager().checkFeature("tridium", "developer");
                skipModuleValidation = feature.getb("skipModuleValidation", false);
                if (!skipModuleValidation) {
                    throw new FeatureNotLicensedException("feature 'developer' missing 'skipModuleValidation' attribute");
                }
            }
            catch (FeatureNotLicensedException | LicenseDatabaseException e) {
                log.warning("A request to disable module validation was made, but the system is not licensed for it: " + e.getLocalizedMessage());
                skipModuleValidation = false;
            }
        }
        if (skipModuleValidation) {
            log.warning("*********************************************");
            log.warning("**** Module validation has been DISABLED ****");
            log.warning("*********************************************");
        }
        return skipModuleValidation;
    }

    Class<?> loadAutoClass(String classname, Buffer buffer) throws ClassNotFoundException {
        this.buffer = buffer;
        Class<?> c = this.loadClass(classname);
        this.buffer = null;
        return c;
    }

    protected static void addClassToSpy(String moduleName, int bytes) {
        int[] counts = SPY_MAP.get(moduleName);
        if (counts == null) {
            counts = new int[2];
            SPY_MAP.put(moduleName, counts);
        }
        counts[0] = counts[0] + 1;
        counts[1] = counts[1] + bytes;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.module + " [" + Integer.toString(System.identityHashCode(this), 36) + "]";
    }

    static /* synthetic */ boolean access$000() {
        return ModuleClassLoader.loadSkipModuleValidation();
    }

    static {
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.classLoader.parallelCapable")).booleanValue()) {
            ModuleClassLoader.registerAsParallelCapable();
        }
        SPY_MAP = new HashMap<String, int[]>();
        log = Logger.getLogger("loader");
        AGGRESSIVE_CACHING_ENABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.unitTestMode")) == false;
    }

    private static final class SharedClassCache
    implements ClassCache {
        private static Map<String, Class<?>> cache = new ConcurrentHashMap(1000);
        private Set<String> notFoundCache = new HashSet<String>();

        private SharedClassCache() {
        }

        @Override
        public Object get(String name) {
            Class<?> cls = cache.get(name);
            return cls == null && this.notFoundCache.contains(name) ? notPreviouslyFound : cls;
        }

        @Override
        public void put(String name, Class<?> cls) {
            if (cls == null) {
                this.notFoundCache.add(name);
            } else {
                cache.put(name, cls);
            }
        }
    }

    private static final class PerModuleClassCache
    implements ClassCache {
        private Map<String, Object> cache = new HashMap<String, Object>();

        private PerModuleClassCache() {
        }

        @Override
        public Object get(String name) {
            return this.cache.get(name);
        }

        @Override
        public void put(String name, Class<?> cls) {
            this.cache.put(name, cls == null ? notPreviouslyFound : cls);
        }
    }

    private static interface ClassCache {
        public static final Object notPreviouslyFound = new Object();

        public Object get(String var1);

        public void put(String var1, Class<?> var2);
    }

    public static final class LoaderSpy
    extends Spy {
        private void row(SpyWriter out, String module, int classes, int bytes) {
            out.w("<tr>");
            out.w("<td align='left' nowrap='true'>").safe(module).w("</td>");
            out.w("<td align='right' nowrap='true'>").safe(DF.format(classes)).w("</td>");
            out.w("<td align='right' nowrap='true'>").safe(DF.format(bytes)).w("</td>");
            out.w("</tr>\n");
        }

        private void summary(SpyWriter out, String str, int num) {
            out.w("<tr>");
            out.w("<td align='left' nowrap='true'>").safe(str).w("</td>");
            out.w("<td align='right' nowrap='true'>").safe(DF.format(num)).w("</td>");
            out.w("</tr>\n");
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            int totalClasses = 0;
            int totalBytes = 0;
            out.startTable(true);
            out.w("<tr>");
            out.thTitle("Class Loader");
            out.thTitle("Classes");
            out.thTitle("Bytes Loaded");
            out.w("</tr>");
            for (String moduleName : SPY_MAP.keySet()) {
                int[] counts = (int[])SPY_MAP.get(moduleName);
                this.row(out, moduleName, counts[0], counts[1]);
                totalClasses += counts[0];
                totalBytes += counts[1];
            }
            out.endTable();
            out.w("<p/>");
            out.startTable(true);
            out.trTitle("Summary", 2);
            this.summary(out, "Total Classes", totalClasses);
            this.summary(out, "Total Bytes Loaded", totalBytes);
            out.endTable();
        }
    }

    private static class SkipModuleValidationHolder {
        public static final Boolean SKIP_MODULE_VALIDATION = ModuleClassLoader.access$000();

        private SkipModuleValidationHolder() {
        }
    }
}

