/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.ModuleExtJar;
import com.tridium.sys.module.NModule;
import com.tridium.util.jar.ModuleEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class ModuleExtClassLoader
extends SecureClassLoader {
    protected ModuleExtJar extJar;
    static final Object NOT_FOUND = new Object();
    static final Logger log = Logger.getLogger("loader");
    private final Map<String, Object> cache = new Hashtable<String, Object>();
    private CodeSource codeSource;

    ModuleExtClassLoader(ModuleClassLoader parent, ModuleExtJar extJar, CodeSource codeSource) {
        super(parent);
        this.extJar = extJar;
        this.codeSource = codeSource;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.nload(name, resolve);
        if (c == null) {
            String msg = name;
            if (this.module() != null) {
                msg = this.module().modulePartName + ":" + name;
            }
            throw new ClassNotFoundException(msg);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> nload(String name, boolean resolve) {
        Object lock = this.moduleClassLoader().getLoadClassLock(name);
        if (ModuleClassLoader.legacyExtClassLoader) {
            lock = this.getClassLoadingLock(name);
        }
        Object object = lock;
        synchronized (object) {
            Object fromCache = this.cache.get(name);
            if (fromCache == NOT_FOUND) {
                return null;
            }
            Class<?> c = (Class<?>)fromCache;
            if (c == null) {
                c = this.nfind(name, resolve, true);
                if (log.isLoggable(Level.FINE)) {
                    String result = "NOT FOUND";
                    if (c != null) {
                        BModule m = Sys.getModuleForClass(c);
                        result = m != null ? m.getModuleName() : "{system}";
                    }
                    log.fine(this.module().modulePartName + ":" + name + " -> " + result);
                }
                if (c == null) {
                    this.cache.put(name, NOT_FOUND);
                    return null;
                }
                this.cache.put(name, c);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public URL getResource(String path) {
        URL url = this.getResourceImpl(path);
        if (url != null) {
            return url;
        }
        return ModuleExtClassLoader.getSystemResource(path);
    }

    URL getResourceImpl(String path) {
        ModuleEntry entry = this.module().moduleFile.getJarEntry(this.extJar.getEntryPath(path));
        if (entry != null) {
            return entry.getURL();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url != null) {
                URLConnection c = url.openConnection();
                c.connect();
                return c.getInputStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String path) throws IOException {
        Vector<URL> v = new Vector<URL>();
        URL res = this.getResourceImpl(path);
        if (res != null) {
            v.add(res);
        }
        return v.elements();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        return this.moduleClassLoader().getPermissions(cs);
    }

    Class<?> nfind(String name, boolean resolve, boolean checkParent) {
        Class<?> result;
        if (checkParent && (result = this.moduleClassLoader().nload(name, resolve)) != null) {
            return result;
        }
        String path = this.extJar.getEntryPath(name.replace('.', '/') + ".class");
        ModuleEntry entry = this.module().moduleFile.getJarEntry(path);
        if (entry != null) {
            try {
                byte[] buf;
                int len = (int)entry.getSize();
                try (InputStream in = entry.getInputStream();){
                    int n;
                    buf = new byte[len];
                    for (int count = 0; count < len; count += n) {
                        n = in.read(buf, count, len - count);
                        if (n >= 0) continue;
                        throw new IOException("Unexpected EOF");
                    }
                }
                if (!this.moduleClassLoader().verifyJarEntrySignature(entry)) {
                    return null;
                }
                if (ModuleClassLoader.legacyExtClassLoader) {
                    return this.defineClass(name, buf, 0, buf.length, this.codeSource);
                }
                return this.moduleClassLoader().defineExtClass(name, buf, 0, buf.length, this.codeSource);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected ModuleClassLoader moduleClassLoader() {
        return (ModuleClassLoader)this.getParent();
    }

    protected NModule module() {
        return this.moduleClassLoader().module;
    }
}

