/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.baja.xml.XElem;

public class ModuleExtJar {
    public String extFilename;
    public Map<String, String> entryPathsByResourcePath;
    public Set<String> resourcePaths;

    public ModuleExtJar(XElem elem) {
        this.extFilename = elem.get("name");
        this.entryPathsByResourcePath = new HashMap<String, String>();
        this.resourcePaths = new HashSet<String>();
        for (XElem entry : elem.elems("entry")) {
            String entryPath = entry.get("moduleEntryPath", null);
            String resourcePath = entry.get("resourcePath");
            if (entryPath != null) {
                this.entryPathsByResourcePath.put(resourcePath, entryPath);
            }
            this.resourcePaths.add(resourcePath);
        }
    }

    public String getEntryPath(String resourcePath) {
        String result = this.entryPathsByResourcePath.get(resourcePath);
        return result == null ? resourcePath : result;
    }
}

