/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.nre.security.KeyRingPermission;
import com.tridium.nre.security.policy.ICodeSourceInfo;
import com.tridium.nre.security.policy.JavaPermissionsFactory;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicy;
import com.tridium.nre.security.policy.NiagaraPolicyUtil;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.nre.security.policy.PermissionsCache;
import com.tridium.security.NiagaraPermissionGroupFactory;
import com.tridium.sys.Nre;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.module.AxModuleContent;
import com.tridium.sys.module.Dependency;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.ModuleExtJar;
import com.tridium.sys.module.ModuleManager;
import com.tridium.sys.registry.NRegistry;
import com.tridium.util.jar.ModuleFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BModule;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleIncompatibleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

public class NModule
implements ICodeSourceInfo {
    public ModuleFile moduleFile;
    protected String moduleName;
    protected AxModuleContent axContent;
    protected String modulePartName;
    protected RuntimeProfile runtimeProfile;
    protected Version bajaVersion = Version.ZERO;
    protected Optional<Long> releaseDate;
    protected Version vendorVersion = Version.ZERO;
    protected String description;
    protected String vendor;
    protected String preferredSymbol;
    protected Dependency[] depends;
    protected ModuleClassLoader classLoader;
    protected byte manifestSchemaVersion;
    protected Map<String, Object> types = new HashMap<String, Object>(63);
    protected Map<String, String> packages = new HashMap<String, String>(10);
    protected Object bmodule;
    private boolean checkTpk = false;
    boolean signed = false;
    protected PermissionCollection permissions = Policy.UNSUPPORTED_EMPTY_COLLECTION;
    protected Set<NiagaraPermissionGroup> requestedPermissions = Collections.emptySet();
    boolean isSystemJar;
    String[] typeList;
    ModuleExtJar[] extJars;
    Lexicon lexicon;
    final Map<String, Lexicon> lexicons = new HashMap<String, Lexicon>();

    void init(Supplier<BModule> bModuleSupplier) {
        if (this.bmodule == null) {
            this.checkRegistered();
            this.bmodule = bModuleSupplier.get();
            ((BModule)this.bmodule).addModulePart(this);
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModulePartName() {
        return this.modulePartName;
    }

    public String getPreferredSymbol() {
        return this.preferredSymbol;
    }

    public Version getBajaVersion() {
        return this.bajaVersion;
    }

    public String getVendor() {
        return this.vendor;
    }

    public RuntimeProfile getRuntimeProfile() {
        return this.runtimeProfile;
    }

    public Version getVendorVersion() {
        return this.vendorVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public BModule bmodule() {
        return (BModule)this.bmodule;
    }

    public Optional<Long> getReleaseDate() {
        return this.releaseDate;
    }

    public void checkLicensed() {
        AccessController.doPrivileged(() -> Nre.getLicenseManager()).checkModuleReleaseDate(this);
    }

    public void checkRegistered() throws ModuleIncompatibleException {
        try {
            ModuleInfo info = Sys.getRegistry().getModule(this.getModuleName(), this.getRuntimeProfile());
            if (!info.getModulePartName().equals(this.getModulePartName())) {
                throw new ModuleIncompatibleException(String.format("Module part name mismatch for %s:%s, %s != %s", this.getModuleName(), this.getRuntimeProfile(), this.getModulePartName(), info.getModulePartName()));
            }
            if (!info.getVendorVersion().equals(this.getVendorVersion())) {
                throw new ModuleIncompatibleException(String.format("Version mismatch for %s:%s, %s != %s", this.getModuleName(), this.getRuntimeProfile(), this.getVendorVersion(), info.getVendorVersion()));
            }
        }
        catch (ModuleNotFoundException mnfe) {
            throw new ModuleIncompatibleException(String.format("%s:%s not registered", this.getModuleName(), this.getRuntimeProfile()));
        }
    }

    public void checkBajaVersion(Version bajaVersion) throws ModuleIncompatibleException {
        if (bajaVersion != null && bajaVersion.compareTo(this.getBajaVersion()) > 0) {
            throw new ModuleIncompatibleException(this.getModulePartName() + "-" + bajaVersion);
        }
    }

    public void checkVendor(String vendor, Version vendorVersion) throws ModuleIncompatibleException {
        if (vendor != null && !vendor.equalsIgnoreCase(this.getVendor()) || vendorVersion != null && vendorVersion.compareTo(this.getVendorVersion()) > 0) {
            throw new ModuleIncompatibleException(this.getModulePartName() + "-" + vendor + "-" + vendorVersion);
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return AccessController.doPrivileged(() -> {
                if (this.isSystemJar) {
                    return Class.forName(className);
                }
                return Class.forName(className, true, this.classLoader);
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getException();
            }
            throw new BajaRuntimeException(e.getException());
        }
    }

    public URL getResource(String path) {
        return AccessController.doPrivileged(() -> {
            if (this.isSystemJar) {
                return ClassLoader.getSystemResource(path);
            }
            return this.classLoader.getResource(path);
        });
    }

    public ModuleClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String[] getTypeList() {
        if (this.typeList == null) {
            this.typeList = this.types.keySet().toArray(new String[0]);
            SortUtil.sort((Object[])this.typeList);
        }
        String[] copy = new String[this.typeList.length];
        System.arraycopy(this.typeList, 0, copy, 0, copy.length);
        return copy;
    }

    public boolean hasType(String typeName) {
        return this.types.containsKey(typeName);
    }

    public Type getType(String typeName) throws TypeException {
        Object val = this.types.get(typeName);
        if (val == null) {
            throw new TypeNotFoundException(this.moduleName + ":" + typeName);
        }
        if (val instanceof Type) {
            return (Type)val;
        }
        String className = (String)val;
        try {
            this.loadClass(className);
            val = this.types.get(typeName);
            if (val == null || !(val instanceof Type)) {
                throw new TypeException("Class loaded, but didn't register a type " + this.moduleName + ":" + typeName + "=" + className);
            }
            return (Type)val;
        }
        catch (TypeException ex) {
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            throw new TypeException("Class not found for type " + this.moduleName + ":" + typeName + "=" + className);
        }
        catch (ExceptionInInitializerError ex) {
            Throwable cause = ex.getException();
            if (cause == null) {
                cause = ex;
            }
            throw new TypeException(ex.toString() + " " + this.moduleName + ":" + typeName + "=" + className, cause);
        }
        catch (Throwable ex) {
            throw new TypeException(ex.toString() + " " + this.moduleName + ":" + typeName + "=" + className, ex);
        }
    }

    public void register(String typeName, Type type) {
        this.types.put(typeName, type);
    }

    public void register(String typeName, String className) {
        this.types.put(typeName, className);
    }

    public ZipFile getZipFile() {
        return this.moduleFile == null ? null : this.moduleFile.zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lexicon getLexicon(String lang) {
        Map<String, Lexicon> map = this.lexicons;
        synchronized (map) {
            Lexicon lexicon = this.lexicons.get(lang);
            if (lexicon == null) {
                lexicon = Lexicon.make(this.bmodule(), lang);
                this.lexicons.put(lang, lexicon);
            }
            return lexicon;
        }
    }

    public final Lexicon getLexicon() {
        if (this.lexicon == null || !this.lexicon.language.equals(Sys.getLanguage())) {
            this.lexicon = this.getLexicon(Sys.getLanguage());
        }
        return this.lexicon;
    }

    public String getUrl() {
        if (this.moduleFile == null) {
            return null;
        }
        try {
            return NiagaraPolicyUtil.canonicalizeCodeSource((URL)this.moduleFile.getFileURL());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return this.getModuleName();
    }

    public boolean isSigned() {
        return this.signed;
    }

    public File getFile() {
        return this.moduleFile.getFile();
    }

    public String getTypeClassName(String typeName) {
        Object x = this.types.get(typeName);
        if (x == null) {
            return null;
        }
        if (x instanceof String) {
            return (String)x;
        }
        return ((Type)x).getTypeClass().getName();
    }

    public boolean isSystemJar() {
        return this.isSystemJar;
    }

    public String toString() {
        return this.modulePartName + '-' + this.vendor + '-' + this.vendorVersion;
    }

    public void loadAllTypes() {
        for (String type : this.getTypeList()) {
            try {
                this.getType(type);
            }
            catch (TypeException ex) {
                ModuleManager.log.log(Level.SEVERE, "Cannot load type", ex);
            }
        }
    }

    public boolean isSynthetic() {
        return this.getZipFile() == null || this.getZipFile().getName().endsWith(".sjar");
    }

    public boolean isTransient() {
        return this.getZipFile() == null;
    }

    public boolean containsPackage(String packageName) {
        return this.packages.containsKey(packageName);
    }

    public int getManifestSchemaVersion() {
        return this.manifestSchemaVersion;
    }

    public boolean getCheckTpk() {
        return this.checkTpk;
    }

    PermissionCollection getModuleJavaPermissions() {
        return this.permissions;
    }

    Set<NiagaraPermissionGroup> getRequestedNiagaraPermissions() {
        return this.requestedPermissions;
    }

    public boolean hasRequestedPermissions() {
        return !this.requestedPermissions.isEmpty();
    }

    void readXml(XElem manifest) throws IOException, ParsingException {
        this.readAttributes(manifest);
        this.readDependencies(manifest);
        this.readTypes(manifest);
        this.readExts(manifest);
        this.readPermissions(manifest);
        this.__postReadXml();
    }

    private void readAttributes(XElem manifest) throws IOException {
        this.modulePartName = manifest.get("name");
        this.axContent = AxModuleContent.forModuleManifest(manifest);
        RuntimeProfile manifestProfile = RuntimeProfile.valueOf((String)manifest.get("runtimeProfile", null), null);
        this.runtimeProfile = manifestProfile == null ? this.axContent.getEquivalentRuntimeProfile() : manifestProfile;
        this.moduleName = manifest.get("moduleName", this.modulePartName);
        this.manifestSchemaVersion = manifest.get("moduleName", null) == null && manifest.get("runtimeProfile", null) == null ? (byte)3 : (byte)4;
        this.releaseDate = LicenseUtil.getDateAttributeValue(manifest, "releaseDate", true);
        this.bajaVersion = new Version(manifest.get("bajaVersion"));
        this.vendorVersion = new Version(manifest.get("vendorVersion"));
        this.description = manifest.get("description");
        this.vendor = manifest.get("vendor");
        this.preferredSymbol = manifest.get("preferredSymbol");
    }

    private void readDependencies(XElem manifest) throws IOException {
        XElem dependencies = manifest.elem("dependencies");
        if (dependencies == null) {
            return;
        }
        this.depends = (Dependency[])Arrays.stream(dependencies.elems("dependency")).map(d -> {
            String name = d.get("name");
            String bvs = d.get("bajaVersion", null);
            String vendor = d.get("vendor", null);
            String vvs = d.get("vendorVersion", null);
            Version bv = bvs == null ? null : new Version(bvs);
            Version vv = vvs == null ? null : new Version(vvs);
            return new Dependency(name, bv, vendor, vv);
        }).toArray(Dependency[]::new);
    }

    private void readTypes(XElem manifest) throws IOException {
        XElem parent = manifest.elem("types");
        if (parent == null) {
            return;
        }
        for (XElem t : parent.elems("type")) {
            String packageName;
            String name = t.get("name");
            String className = t.get("class");
            this.types.put(name, className);
            int lastIndexOfDot = className.lastIndexOf(46);
            String string = packageName = lastIndexOfDot == -1 ? "" : className.substring(0, lastIndexOfDot);
            if (this.packages.containsKey(packageName)) continue;
            this.packages.put(packageName, packageName);
        }
    }

    private void readExts(XElem manifest) throws IOException {
        XElem parent = manifest.elem("extFiles");
        if (parent == null) {
            return;
        }
        XElem[] extElems = parent.elems("extFile");
        this.extJars = new ModuleExtJar[extElems.length];
        for (int i = 0; i < extElems.length; ++i) {
            this.extJars[i] = new ModuleExtJar(extElems[i]);
        }
    }

    private void readPermissions(XElem manifest) throws IOException, ParsingException {
        if (this.moduleName.contains("*")) {
            throw new ModuleException("Invalid character '*' in module name.");
        }
        this.permissions = new PermissionsCache();
        this.permissions.add(new PropertyPermission("niagara." + this.moduleName + ".*", "read,write"));
        this.permissions.add((Permission)new KeyRingPermission(this.moduleName));
        this.permissions.add((Permission)new KeyRingPermission(this.moduleName + ".*"));
        XElem permissions = manifest.elem("permissions");
        if (permissions != null) {
            if (permissions.elem("java-permissions") != null) {
                this.checkTpk = true;
                Set permissionSet = JavaPermissionsFactory.parse((ICodeSourceInfo)this, (XElem)permissions, (NiagaraPolicy.PolicyType)NiagaraPolicyUtil.getPolicyType());
                permissionSet.forEach(this.permissions::add);
            }
            if (permissions.elem("niagara-permission-groups") != null) {
                this.requestedPermissions = NiagaraPermissionGroupFactory.parse(this, permissions, NiagaraPolicyUtil.getPolicyType());
            }
        }
        this.permissions.setReadOnly();
    }

    private void __postReadXml() {
        NRegistry registry = AccessController.doPrivileged(() -> Nre.getRegistryManager());
        if (registry == null) {
            return;
        }
        String[] invalidModules = registry.getInvalidModules();
        if (invalidModules == null) {
            return;
        }
        for (String invalidModule : invalidModules) {
            if (!this.moduleName.equals(invalidModule)) continue;
            this.types.clear();
            this.types = Collections.unmodifiableMap(this.types);
            this.typeList = null;
            throw new ModuleException("Unsupported " + this.moduleName + " module");
        }
    }
}

