/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.RegistryException;

public class RegistryChecksum {
    public static final long MAGIC = 7958534986241635693L;
    public static final int VERSION = 5;
    Map<String, ModuleSnapshot> modules;
    List<RuntimeProfile> enabledRuntimeProfiles;

    void checkUpToDate(File file) {
        String name = file.getName();
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - ".jar".length());
        } else if (name.endsWith(".sjar")) {
            name = name.substring(0, name.length() - ".sjar".length());
        } else {
            return;
        }
        ModuleSnapshot snapshot = this.modules.get(name);
        if (snapshot == null) {
            throw new RegistryException("Module added \"" + name + '\"');
        }
        if (snapshot.timestamp != file.lastModified()) {
            throw new RegistryException("Module changed \"" + name + '\"');
        }
        this.modules.remove(name);
    }

    void read(File file) throws Exception {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            if (in.readLong() != 7958534986241635693L) {
                throw new IOException("Invalid magic");
            }
            if (in.readInt() != 5) {
                throw new IOException("Invalid version");
            }
            int len = in.readInt();
            this.modules = new HashMap<String, ModuleSnapshot>(len * 3);
            for (int i = 0; i < len; ++i) {
                ModuleSnapshot m = new ModuleSnapshot();
                m.name = in.readUTF();
                m.timestamp = in.readLong();
                this.modules.put(m.name, m);
            }
            this.enabledRuntimeProfiles = Arrays.stream(in.readUTF().split(",")).map(RuntimeProfile::valueOf).collect(Collectors.toList());
        }
    }

    void write(File file) throws Exception {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            out.writeLong(7958534986241635693L);
            out.writeInt(5);
            int len = this.modules.size();
            out.writeInt(len);
            for (ModuleSnapshot m : this.modules.values()) {
                out.writeUTF(m.name);
                out.writeLong(m.timestamp);
            }
            out.writeUTF(this.enabledRuntimeProfiles.stream().map(Enum::name).collect(Collectors.joining(",")));
        }
    }

    static class ModuleSnapshot {
        String name;
        long timestamp;

        ModuleSnapshot() {
        }
    }
}

