/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.ComplexIntrospector;
import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.NType;
import java.util.Hashtable;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.TypeIntrospectionException;

public class ComplexType
extends NType {
    final ComplexSlotMap slotMap;
    protected NSlot[] slots;
    NProperty[] properties;
    NAction[] actions;
    NTopic[] topics;
    protected Hashtable<String, Slot> byName;
    BValue defaultInstance;
    int[] defaultFlags;

    public ComplexType(ComplexIntrospector introspector) {
        super(introspector);
        this.slotMap = introspector.slotMap;
        this.slots = introspector.slots;
        this.properties = introspector.properties;
        this.actions = introspector.actions;
        this.topics = introspector.topics;
        this.byName = new Hashtable(this.slots.length * 2 + 3);
        this.defaultFlags = new int[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            NSlot slot = this.slots[i];
            this.defaultFlags[i] = slot.flags;
            if (slot.declaringType == null) {
                slot.declaringType = this;
            }
            if (this.byName.put(slot.name, slot) == null) continue;
            throw new TypeIntrospectionException(this.typeClass, "Duplicate slots: " + slot.name);
        }
    }

    public ComplexType(ComplexType innerType) {
        super(innerType);
        this.slotMap = innerType.slotMap;
        this.slots = innerType.slots;
        this.properties = innerType.properties;
        this.actions = innerType.actions;
        this.topics = innerType.topics;
        this.byName = new Hashtable(this.slots.length * 2 + 3);
        this.defaultFlags = new int[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            NSlot slot = this.slots[i];
            this.defaultFlags[i] = slot.flags;
            if (slot.declaringType == null) {
                slot.declaringType = this;
            }
            if (this.byName.put(slot.name, slot) == null) continue;
            throw new TypeIntrospectionException(this.typeClass, "Duplicate slots: " + slot.name);
        }
    }

    @Override
    public BObject getInstance() {
        try {
            return this.slotMap.newBComplexInstance();
        }
        catch (NoSuchMethodError nsme) {
            throw new UnsupportedOperationException("Default constructor not available for " + this);
        }
    }

    public ComplexSlotMap newSlotMap() {
        return this.slotMap.newSlotMapInstance();
    }

    public Slot getSlot(String name) {
        return this.slotMap.getSlot(name);
    }

    public NSlot[] getFrozenSlots() {
        return (NSlot[])this.slots.clone();
    }

    public Property getProperty(String name) {
        return (Property)this.slotMap.getSlot(name);
    }

    public Property getFrozenProperty(String name) {
        return (Property)this.byName.get(name);
    }

    public NProperty[] getFrozenProperties() {
        return (NProperty[])this.properties.clone();
    }
}

