/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.DynamicTable;
import com.tridium.sys.schema.NProperty;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Topic;

final class PropertyCursor
implements SlotCursor<Property> {
    private int index = -1;
    private volatile boolean closed;
    private BComplex object;
    private NProperty[] frozen;
    private DynamicTable dynamic;
    private int count;
    private static final Log log = Log.getLog("baja.PropertyCursor");

    PropertyCursor(BComplex o, NProperty[] f, DynamicTable d) {
        this.object = o;
        this.frozen = f;
        this.dynamic = d;
        this.count = d == null ? f.length : f.length + d.count;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public final BObject target() {
        return this.object;
    }

    @Override
    public final Context getContext() {
        return null;
    }

    @Override
    public final boolean next() {
        return ++this.index < this.count && !this.closed;
    }

    @Override
    public final boolean nextObject() {
        while (this.next()) {
            block4: {
                try {
                    Property prop = this.property();
                    if (prop.getTypeAccess() != 7) {
                    }
                    break block4;
                }
                catch (RuntimeException e) {
                    if (!log.isTraceOn()) continue;
                    log.warning(e.getMessage(), e);
                }
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextComponent() {
        while (this.next()) {
            block4: {
                try {
                    Property prop = this.property();
                    if (prop.getTypeAccess() != 7) continue;
                    if (!this.object.get(prop).isComponent()) {
                    }
                    break block4;
                }
                catch (RuntimeException e) {
                    if (!log.isTraceOn()) continue;
                    log.warning(e.getMessage(), e);
                }
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean next(Class<?> cls) {
        while (this.next()) {
            block4: {
                try {
                    Property prop = this.property();
                    if (prop.getTypeAccess() != 7) continue;
                    if (!cls.isInstance(this.object.get(prop))) {
                    }
                    break block4;
                }
                catch (RuntimeException e) {
                    if (!log.isTraceOn()) continue;
                    log.warning(e.getMessage(), e);
                }
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public final Property slot() {
        this.checkClosed();
        if (this.index < this.frozen.length) {
            return this.frozen[this.index];
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.dynamic.slots[this.index - this.frozen.length];
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final Property property() {
        this.checkClosed();
        if (this.index < this.frozen.length) {
            return this.frozen[this.index];
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.dynamic.slots[this.index - this.frozen.length];
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final int getTypeAccess() {
        this.checkClosed();
        if (this.index < this.frozen.length) {
            return this.frozen[this.index].typeAccess;
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.dynamic.slots[this.index - this.frozen.length].typeAccess;
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final BValue get() {
        this.checkClosed();
        if (this.index < this.frozen.length) {
            return this.object.get(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.get(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final boolean getBoolean() {
        this.checkClosed();
        if (this.index < this.frozen.length) {
            return this.object.getBoolean(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.getBoolean(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final int getInt() {
        this.checkClosed();
        if (this.index < this.frozen.length) {
            return this.object.getInt(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.getInt(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final long getLong() {
        if (this.index < this.frozen.length) {
            return this.object.getLong(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.getLong(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final float getFloat() {
        if (this.index < this.frozen.length) {
            return this.object.getFloat(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.getFloat(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final double getDouble() {
        if (this.index < this.frozen.length) {
            return this.object.getDouble(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.getDouble(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final String getString() {
        if (this.index < this.frozen.length) {
            return this.object.getString(this.frozen[this.index]);
        }
        if (this.index - this.frozen.length < this.dynamic.count) {
            return this.object.getString(this.dynamic.slots[this.index - this.frozen.length]);
        }
        throw new CursorException("No more elements");
    }

    @Override
    public final Action action() {
        Property s = this.slot();
        if (s.isAction()) {
            return s.asAction();
        }
        throw new CursorException("not action");
    }

    @Override
    public final Topic topic() {
        this.checkClosed();
        Property s = this.slot();
        if (s.isTopic()) {
            return s.asTopic();
        }
        throw new CursorException("not topic");
    }

    private void checkClosed() {
        if (this.closed) {
            throw new CursorException("cursor was closed");
        }
    }
}

