/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.ComplexIntrospector;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NSyntheticAction;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.Utils;
import com.tridium.util.ArrayUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class SyntheticComplexType
extends ComplexType {
    private final Class<?> typeClass;

    public SyntheticComplexType(ComplexIntrospector introspector, Class<?> typeClass) {
        super(introspector);
        this.typeClass = typeClass;
    }

    @Override
    public BObject getInstance() {
        try {
            return (BObject)this.typeClass.newInstance();
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e);
        }
    }

    @Override
    public boolean isTransient() {
        return this.getModule().isTransient();
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public Property addProperty(String name, Type declaringType, int flags, BValue defaultValue, BFacets facets) {
        NProperty prop = new NProperty(name, flags, defaultValue, facets, true);
        prop.type = declaringType;
        prop.typeClass = declaringType.getTypeClass();
        prop.typeAccess = Utils.getTypeAccess(this.typeClass);
        prop.declaringType = this;
        prop.index = this.slots.length;
        if (this.byName.containsKey(name)) {
            NSlot existingSlot = (NSlot)this.byName.get(name);
            if (!(existingSlot instanceof NProperty)) {
                throw new DuplicateSlotException(prop);
            }
            NProperty existingProp = (NProperty)existingSlot;
            if (existingProp.declaringType == this) {
                throw new DuplicateSlotException(prop);
            }
            if (!defaultValue.getType().is(existingProp.getType())) {
                throw new IllegalArgumentException("Default value must match property type: " + existingProp.getType());
            }
            if (!prop.getType().is(existingProp.getType())) {
                throw new IllegalArgumentException("Property type does not match overridden property's type: " + existingProp.getType());
            }
            existingProp.flags = flags;
            existingProp.value = defaultValue;
            existingProp.facets = facets;
            existingProp.declaringType = this;
        } else {
            this.properties = ArrayUtil.addOne(this.properties, prop);
            this.defaultFlags = ArrayUtil.addOne(this.defaultFlags, flags);
            this.slots = ArrayUtil.addOne(this.slots, prop);
            this.byName.put(name, prop);
        }
        return prop;
    }

    public Action addAction(String name, int flags, BValue defaultValue, BFacets facets) {
        return this.addAction(name, flags, defaultValue, facets, null);
    }

    public Action addAction(String name, int flags, BValue defaultValue, BFacets facets, NSyntheticAction.SyntheticActionInvocationHandler handler) {
        NSyntheticAction action = new NSyntheticAction(flags, defaultValue, facets, handler);
        action.declaringType = this;
        action.index = this.slots.length;
        action.name = name;
        if (this.byName.containsKey(name)) {
            NSlot existingSlot = (NSlot)this.byName.get(name);
            if (!(existingSlot instanceof NAction)) {
                throw new DuplicateSlotException(action);
            }
            NAction existingAction = (NAction)existingSlot;
            if (defaultValue == null && existingAction.getParameterDefault() != null || defaultValue != null && existingAction.getParameterDefault() == null || defaultValue != null && existingAction.getParameterDefault() != null && !defaultValue.getType().is(existingAction.getParameterDefault().getType())) {
                throw new DuplicateSlotException(action);
            }
            existingAction.flags = flags;
            existingAction.parameterDefault = defaultValue;
            existingAction.facets = facets;
            existingAction.declaringType = this;
        }
        this.actions = ArrayUtil.addOne(this.actions, action);
        this.defaultFlags = ArrayUtil.addOne(this.defaultFlags, flags);
        this.slots = ArrayUtil.addOne(this.slots, action);
        this.byName.put(name, action);
        return action;
    }

    public Topic addTopic(String name, int flags, Type eventType, BFacets facets) {
        NTopic topic = new NTopic(flags, facets);
        topic.declaringType = this;
        topic.eventClass = eventType.getTypeClass();
        topic.index = this.slots.length;
        topic.name = name;
        if (this.byName.containsKey(name)) {
            NSlot existingSlot = (NSlot)this.byName.get(name);
            if (!(existingSlot instanceof NTopic)) {
                throw new DuplicateSlotException(topic);
            }
            NTopic existingTopic = (NTopic)existingSlot;
            if (!eventType.getTypeSpec().equals(existingTopic.getEventType().getTypeSpec())) {
                throw new DuplicateSlotException(topic);
            }
            existingTopic.flags = flags;
            existingTopic.eventClass = eventType.getTypeClass();
            existingTopic.eventType = eventType;
            existingTopic.facets = facets;
            existingTopic.declaringType = this;
        }
        this.topics = ArrayUtil.addOne(this.topics, topic);
        this.defaultFlags = ArrayUtil.addOne(this.defaultFlags, flags);
        this.slots = ArrayUtil.addOne(this.slots, topic);
        this.byName.put(name, topic);
        return topic;
    }
}

