/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.EnumIntrospector;
import com.tridium.sys.schema.EnumType;
import com.tridium.util.ArrayUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.baja.nre.util.IntHashMap;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BajaRuntimeException;

public class SyntheticEnumType
extends EnumType {
    Class<?> typeClass;

    public SyntheticEnumType(EnumIntrospector introspector, BFrozenEnum def, int[] ordinals, IntHashMap byOrdinal, Map<String, EnumType.Entry> byTag, Class<?> typeClass) {
        super(introspector, def, ordinals, byOrdinal, byTag);
        this.typeClass = typeClass;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    @Override
    public boolean isTransient() {
        return this.getModule().isTransient();
    }

    public void addEntry(int ordinal, String tag) {
        BFrozenEnum value;
        this.ordinals = ArrayUtil.addOne(this.ordinals, ordinal);
        if (this.byTag.containsKey(tag)) {
            throw new IllegalArgumentException("Tag already defined within enumeration.");
        }
        if (this.byOrdinal.containsKey(ordinal)) {
            throw new IllegalArgumentException("Tag already defined within enumeration.");
        }
        try {
            Constructor<?> cntr = this.typeClass.getConstructor(Integer.TYPE);
            value = (BFrozenEnum)cntr.newInstance(ordinal);
        }
        catch (NoSuchMethodException nsme) {
            throw new BajaRuntimeException("Missing enumeration constructor.", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new BajaRuntimeException("Unable to create enumeration instance.", ite);
        }
        catch (IllegalAccessException iae) {
            throw new BajaRuntimeException("Unable to create enumeration instance.", iae);
        }
        catch (InstantiationException ie) {
            throw new BajaRuntimeException("Unable to create enumeration instance.", ie);
        }
        if (this.defaultInstance == null) {
            this.defaultInstance = value;
        }
        EnumType.Entry entry = new EnumType.Entry(ordinal, tag, value);
        this.byOrdinal.put(ordinal, (Object)entry);
        this.byTag.put(tag, entry);
    }
}

