/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import com.tridium.logging.BILoggingService;
import com.tridium.logging.LogSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.spy.ISpyDir;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;

public class LogSetupSpy
extends Spy
implements ISpyDir {
    private LogSettings settings;
    private Map<String, Object> logToLevel = new HashMap<String, Object>();
    private BILoggingService loggingService;
    private Set<String> removedLogs = new HashSet<String>();
    private List<String> logs;
    private final String ROOT = ".level";
    private Boolean rootChange = false;
    private Level root_sev = null;
    private static final String[] childSpyName = new String[0];

    @Override
    public String[] list() {
        return childSpyName;
    }

    @Override
    public Spy find(String logpath) {
        String namePart = logpath;
        if (!logpath.equals("ErrorPage")) {
            namePart = SpyWriter.getNameWithoutCsrfToken(logpath);
        }
        String cmd = namePart;
        String log = null;
        Spy spyPage = null;
        int dash = namePart.indexOf(45);
        if (dash > 0) {
            cmd = namePart.substring(0, dash);
            log = namePart.substring(dash + 1);
        }
        switch (cmd) {
            case "DEFAULT": {
                spyPage = this.removeConfiguredLog(log);
                break;
            }
            case "OFF": {
                spyPage = this.change(log, Level.OFF);
                break;
            }
            case "SEVERE": {
                spyPage = this.change(log, Level.SEVERE);
                break;
            }
            case "WARNING": {
                spyPage = this.change(log, Level.WARNING);
                break;
            }
            case "INFO": {
                spyPage = this.change(log, Level.INFO);
                break;
            }
            case "CONFIG": {
                spyPage = this.change(log, Level.CONFIG);
                break;
            }
            case "FINE": {
                spyPage = this.change(log, Level.FINE);
                break;
            }
            case "FINER": {
                spyPage = this.change(log, Level.FINER);
                break;
            }
            case "FINEST": {
                spyPage = this.change(log, Level.FINEST);
                break;
            }
            case "ALL": {
                spyPage = this.change(log, Level.ALL);
                break;
            }
            default: {
                spyPage = new DefaultSpy("Desired Log Page Could Not Be Found !! ");
            }
        }
        return spyPage;
    }

    @Override
    public void write(SpyWriter out) {
        try {
            this.loggingService = Sys.getStation() != null ? (BILoggingService)((Object)Sys.getService(BILoggingService.TYPE)) : (BILoggingService)((Object)BOrd.make("workbench:/tools/workbench:LoggerConfigurationTool").get());
            this.settings = new LogSettings(this.loggingService.readLogSettings());
            this.logs = this.loggingService.getRegisteredLoggers();
            List<String> declared = this.settings.getDeclaredLogs();
            Collections.sort(this.logs, String.CASE_INSENSITIVE_ORDER);
            Iterator<String> reg_log_itr = this.logs.iterator();
            out.startTable(true);
            out.trTitle("Log Configuration", 12);
            out.w("<tr>");
            out.thTitle("Log").thTitle("Level").unsafe().thTitle(SpyWriter.createMutatorButton("spy:/logSetup/OFF", "OFF")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/SEVERE", "SEVERE")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/WARNING", "WARNING")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/INFO", "INFO")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/CONFIG", "CONFIG")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/FINE", "FINE")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/FINER", "FINER")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/FINEST", "FINEST")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/ALL", "ALL")).thTitle(SpyWriter.createMutatorButton("spy:/logSetup/DEFAULT", "DEFAULT")).w("</tr>");
            Level sev = this.settings.getLogLevel(declared.get(0));
            this.writeLogRow(".level", out, sev);
            while (reg_log_itr.hasNext()) {
                String logName = reg_log_itr.next();
                if (logName == null || logName.trim().equals("")) continue;
                sev = null;
                if (declared.contains(logName)) {
                    sev = this.settings.getLogLevel(logName);
                }
                this.writeLogRow(logName, out, sev);
            }
            out.endTable();
        }
        catch (Exception e) {
            try {
                this.find("ErrorPage").write(out);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void writeLogRow(String logName, SpyWriter out, Level sev) {
        out.tr();
        out.td(logName.equals(".level") ? "DEFAULT" : logName);
        out.td(sev == null ? "DEFAULT" : sev);
        this.writeLogCell(logName, out, sev, Level.OFF);
        this.writeLogCell(logName, out, sev, Level.SEVERE);
        this.writeLogCell(logName, out, sev, Level.WARNING);
        this.writeLogCell(logName, out, sev, Level.INFO);
        this.writeLogCell(logName, out, sev, Level.CONFIG);
        this.writeLogCell(logName, out, sev, Level.FINE);
        this.writeLogCell(logName, out, sev, Level.FINER);
        this.writeLogCell(logName, out, sev, Level.FINEST);
        this.writeLogCell(logName, out, sev, Level.ALL);
        this.writeLogCell(logName, out, sev, null);
        out.w("</tr>\n");
    }

    private void writeLogCell(String logName, SpyWriter out, Level configuredLevel, Level level) {
        out.w("<td align='center' nowrap='true'>");
        if (level == null && ".level".equals(logName)) {
            out.w("Not applicable");
        } else if (configuredLevel == level) {
            out.w("[X]");
        } else {
            out.w("[").mutatorButton("spy:/logSetup/" + (level == null ? "DEFAULT" : level.getName()) + (logName == null ? "" : "-" + logName), "_").w("]");
        }
        out.endTd();
    }

    public void saveChanges() {
        for (String string : this.removedLogs) {
            if (string.contains(":") || string.contains("=")) {
                this.settings.removeLogSettings(string.replace(":", "\\:").replace("=", "\\="));
                continue;
            }
            this.settings.removeLogSettings(string);
        }
        for (Map.Entry entry : this.logToLevel.entrySet()) {
            if (((String)entry.getKey()).contains(":") || ((String)entry.getKey()).contains("=")) {
                this.settings.setLogLevel(((String)entry.getKey()).replace(":", "\\:").replace("=", "\\="), Level.parse(entry.getValue().toString()));
                continue;
            }
            this.settings.setLogLevel((String)entry.getKey(), Level.parse(entry.getValue().toString()));
        }
        if (this.rootChange.booleanValue()) {
            this.settings.setLogLevel("", this.root_sev);
        }
        try {
            this.loggingService.reload(this.settings.getRawProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.removedLogs.clear();
    }

    private Spy removeConfiguredLog(String log) {
        if (log != null) {
            this.logToLevel.remove(log);
            this.removedLogs.add(log);
            this.saveChanges();
            return new MessageLogSetupSpy("The Log " + log + " has been set to default Log level");
        }
        for (int i = 0; i < this.logs.size(); ++i) {
            this.logToLevel.remove(this.logs.get(i));
            this.removedLogs.add(this.logs.get(i));
        }
        this.saveChanges();
        return new MessageLogSetupSpy("All the Logs have been set to default");
    }

    public Spy change(String log, Level severity) {
        if (log != null) {
            if (log.equals(".level")) {
                this.root_sev = severity;
                this.rootChange = true;
                this.saveChanges();
                return new MessageLogSetupSpy("Changed Default log to level '" + severity + "'.");
            }
            this.logToLevel.put(log, severity);
            this.saveChanges();
            return new MessageLogSetupSpy("Changed " + log + " log to level '" + severity + "'.");
        }
        for (int i = 0; i < this.logs.size(); ++i) {
            this.logToLevel.put(this.logs.get(i), severity);
        }
        this.saveChanges();
        return new MessageLogSetupSpy("All logs changed to level '" + severity + "'.");
    }

    private static class DefaultSpy
    extends LogSetupSpy {
        String message;

        public DefaultSpy(String message) {
            this.message = message;
        }

        @Override
        public void write(SpyWriter out) {
            out.write("<br><b>");
            out.write(this.message);
            out.write("</b><br><br>");
        }
    }

    private static class MessageLogSetupSpy
    extends LogSetupSpy {
        String message;

        public MessageLogSetupSpy(String message) {
            this.message = message;
        }

        @Override
        public void write(SpyWriter out) {
            out.write("<br><b>");
            out.write(this.message);
            out.write("</b><br><br>");
            super.write(out);
        }
    }
}

