/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public class SystemPropertiesSpy
extends Spy {
    private static final Set<String> SYSTEM_PROP_NAMES_TO_OBFUSCATE_VALUE = Collections.unmodifiableSet(Stream.of("orientdb_root_password").collect(Collectors.toSet()));
    private static final String OBFUSCATED_VALUE = "********";

    @Override
    public void write(SpyWriter out) throws IOException {
        AccessController.doPrivileged(() -> {
            ArrayList<Pair> pairs = new ArrayList<Pair>();
            Set<String> keySet = System.getProperties().stringPropertyNames();
            for (String strKey : keySet) {
                Pair pair = new Pair();
                pair.key = strKey;
                pair.value = SYSTEM_PROP_NAMES_TO_OBFUSCATE_VALUE.contains(strKey.toLowerCase()) ? OBFUSCATED_VALUE : AccessController.doPrivileged(() -> System.getProperty(strKey));
                pairs.add(pair);
            }
            Collections.sort(pairs);
            out.startProps("System Properties");
            for (Pair pairValue : pairs) {
                out.prop((Object)pairValue.key, pairValue.value);
            }
            out.endProps();
            return null;
        });
    }

    static class Pair
    implements Comparable<Pair> {
        String key;
        String value;

        Pair() {
        }

        @Override
        public int compareTo(Pair o) {
            return this.key.compareTo(o.key);
        }
    }
}

