/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.station;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.station.Station;
import java.io.File;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

public class StationManager
extends Thread {
    boolean isAlive = true;

    public StationManager() {
        super("Nre:Station");
    }

    public void kill() {
        this.isAlive = false;
        this.interrupt();
    }

    @Override
    public void run() {
        while (this.isAlive) {
            try {
                Thread.sleep(60000L);
                BIPlatform platform = Nre.getPlatform();
                if (!platform.isStationAutoSaveEnabled()) continue;
                long flushTime = platform.getStationAutoSaveFrequency();
                long delta = Clock.ticks() - Station.lastSaveAttemptTicks;
                if (delta <= flushTime) continue;
                Sys.getStation().save();
            }
            catch (InterruptedException platform) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        IndexPage index = new IndexPage();
        Nre.spySysManagers.add("stationManager", index);
        index.add("backups", new BackupPage());
    }

    public class BackupPage
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            File[] backups = Station.getBackups();
            if (backups.length == 0) {
                out.w("No backup files available");
                return;
            }
            out.startTable(true);
            out.trTitle("Station Backups", 4);
            out.w("<tr>").th("Age").th("Name").th("Timestamp").th("Size").w("</tr>\n");
            for (int i = 0; i < backups.length; ++i) {
                File b = backups[i];
                out.tr("" + i, b.getName(), BAbsTime.make(b.lastModified()), "" + b.length() / 1024L + "kb");
            }
            out.endTable();
        }
    }

    public class IndexPage
    extends SpyDir {
        @Override
        public void write(SpyWriter out) throws Exception {
            Object sl;
            int i;
            BStation s = Station.station;
            BIPlatform plat = Nre.getPlatform();
            if (s == null) {
                out.print("VM is not a station");
                return;
            }
            out.startProps("StationManager");
            out.prop((Object)"stationName", s.getStationName());
            out.prop((Object)"atSteadyState", Sys.atSteadyState());
            out.trTitle("Platform", 2);
            out.prop((Object)"type", plat.getType());
            out.prop((Object)"autoSaveEnabled", plat.isStationAutoSaveEnabled());
            out.prop((Object)"autoSaveFreq", plat.getStationAutoSaveFrequency() / 1000L + "sec");
            out.prop((Object)"saveBackupCount", plat.getStationSaveBackupCount());
            out.trTitle("Console", 2);
            out.prop((Object)"isAlive", Station.console.isAlive());
            out.prop((Object)"threadName", Station.console.getName());
            out.trTitle("Boot Debug", 2);
            out.prop((Object)"commandLine", Nre.commandLine);
            out.prop((Object)"bootFile", Station.bootFile);
            out.prop((Object)"bootTime", BAbsTime.make(Nre.bootTime));
            out.prop((Object)"bootFileLock", Station.bootFileLock);
            out.trTitle("Save Debug", 2);
            out.prop((Object)"lastSaveDuration", Station.getLastSaveDurationString());
            out.prop((Object)"lastSuccessfulSaveTime", Station.lastSuccessfulSaveTime);
            out.prop((Object)"lastSaveSpan", BRelTime.toString(Station.lastSaveSpan));
            out.prop((Object)"lastSaveFile", Station.lastSaveFile);
            out.prop((Object)"inSave", Station.inSave);
            out.trTitle("Backups", 2);
            out.propValueLink("backups", "backups", "List Backups");
            out.trTitle("SaveListeners", 2);
            for (i = 0; i < Station.saveListeners.size(); ++i) {
                sl = Station.saveListeners.get(i);
                out.prop((Object)sl.getClass().getName(), sl);
            }
            out.trTitle("RemoteListeners", 2);
            for (i = 0; i < Station.remoteListeners.size(); ++i) {
                sl = Station.remoteListeners.get(i);
                out.prop((Object)sl.getClass().getName(), sl);
            }
            out.endProps();
        }
    }
}

