/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.transfer.FileToFile;
import com.tridium.sys.transfer.TransferResult;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BSubSpaceFile;
import javax.baja.file.FilePath;

public class IntraFileSpaceMove
extends FileToFile {
    @Override
    public TransferResult transfer() throws Exception {
        this.init();
        this.name();
        this.move();
        return null;
    }

    public void move() throws Exception {
        if (IntraFileSpaceMove.isDebugOn()) {
            IntraFileSpaceMove.debug("IntraFileSpaceMove.move");
        }
        BFileSpace fs = this.targetDir.getFileSpace();
        FilePath targetPath = this.targetDir.getFilePath();
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            BIFile source = this.sourceFiles[i];
            FilePath from = source.getFilePath();
            if (source instanceof BSubSpaceFile) {
                ((BSubSpaceFile)source).close();
            }
            FilePath to = targetPath.merge(this.insertNames[i]);
            if (IntraFileSpaceMove.isDebugOn()) {
                IntraFileSpaceMove.debug(" " + from + " -> " + to);
            }
            if (this.targetDir.toString(null).equals("file:~trash ") || this.targetDir.toString(null).startsWith("file:~trash/")) {
                this.updateStatus(this.lexDeleting + " \"" + from.getName() + "\"...");
            } else {
                this.updateStatus(this.lexMoving + " \"" + from.getName() + "\"...");
            }
            fs.move(from, to, this.getContext());
        }
    }
}

