/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.schema.ComponentSlotMap;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;

public class ReplacingContext
extends BasicContext {
    private final Map<BOrd, Object> handles = new Hashtable<BOrd, Object>();

    public ReplacingContext() {
    }

    public ReplacingContext(Context base) {
        super(base);
    }

    public ReplacingContext(Context base, BFacets additionalFacets) {
        super(base, additionalFacets);
    }

    public boolean handlesEmpty() {
        return this.handles.isEmpty();
    }

    public void addAllHandles(BComponent component) {
        BOrd ord = component.getSlotPathOrd();
        if (ord != null) {
            this.addHandle(ord, component.getHandle());
            this.addAllChildHandles(component);
        }
    }

    public boolean hasHandle(BOrd ord) {
        return ord != null && this.handles.containsKey(ord);
    }

    public Object removeHandle(BOrd ord) {
        return this.handles.remove(ord);
    }

    public void restoreHandles(SlotPath parentPath, String name, BComponent component) {
        SlotPath componentPath = null;
        Object handle = component.getHandle();
        if ((handle == null || handle.toString().startsWith("copy-")) && (handle = this.removeHandle(BOrd.make(componentPath = ReplacingContext.getChildPath(parentPath, name)))) != null) {
            ReplacingContext.setHandle(component, handle);
        }
        SlotCursor<Property> c = component.getProperties();
        while (c.nextComponent()) {
            BComponent child = c.get().asComponent();
            if (componentPath == null) {
                componentPath = ReplacingContext.getChildPath(parentPath, name);
            }
            this.restoreHandles(componentPath, child.getName(), child);
        }
    }

    private void addAllChildHandles(BComponent component) {
        SlotCursor<Property> properties = component.getProperties();
        while (properties.nextComponent()) {
            BComponent child = properties.get().asComponent();
            this.addHandle(child);
            this.addAllChildHandles(child);
        }
    }

    private void addHandle(BComponent component) {
        Object handle = component.getHandle();
        if (handle != null) {
            this.addHandle(component.getSlotPathOrd(), handle);
        }
    }

    private void addHandle(BOrd ord, Object handle) {
        if (ord != null && handle != null) {
            this.handles.put(ord, handle);
        }
    }

    private static SlotPath getChildPath(SlotPath parentPath, String childName) {
        String[] parentNames = parentPath.getNames();
        String[] names = Arrays.copyOf(parentNames, parentNames.length + 1);
        names[parentNames.length] = childName;
        return new SlotPath("slot", names);
    }

    private static void setHandle(BComponent component, Object handle) {
        ((ComponentSlotMap)component.fw(1)).setHandle(handle);
    }
}

