/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.syslog;

import com.tridium.nre.syslog.Facility;
import com.tridium.nre.syslog.LogAdapter;
import com.tridium.nre.syslog.Severity;
import javax.baja.security.AuditEvent;

public class AuditAdapter {
    public String adaptPriority(AuditEvent auditEvent, Facility facility) {
        int code = (facility.getId() << 3) + this.adaptSeverity(auditEvent);
        return String.format("<%d>", code);
    }

    public int adaptSeverity(AuditEvent auditEvent) {
        if (auditEvent.getOperation().equalsIgnoreCase("Login Failure")) {
            return Severity.WARNING.getLevel();
        }
        if (auditEvent.getOperation().equalsIgnoreCase("Login") || auditEvent.getOperation().equalsIgnoreCase("Logout")) {
            return Severity.NOTICE.getLevel();
        }
        return Severity.INFO.getLevel();
    }

    public String adaptTimeStamp(AuditEvent auditEvent) {
        long millis = auditEvent.getTimestamp().getMillis();
        return LogAdapter.getFormattedDateFromMillis((long)millis);
    }
}

