/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.timezone;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneException;

public final class HistoricalTimeZoneDate {
    public static final short ANNUAL = -1;
    private static final short[] daysInMonth = new short[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private short theYear;
    private short theTimeOfDayIsExpressedIn;
    private BMonth theMonth;
    private HistoricalTimeZoneDay theDay;
    private BTime theTimeOfDay;

    public static String timePolicyToString(short tempTimePolicy) {
        switch (tempTimePolicy) {
            case 1: {
                return "Standard Time";
            }
            case 2: {
                return "Coordinated Universal Time";
            }
            case 0: {
                return "Wall Time";
            }
        }
        return "Unknown";
    }

    private HistoricalTimeZoneDate() {
    }

    public HistoricalTimeZoneDate(HistoricalTimeZoneDate RHS) {
        this.theYear = RHS.theYear;
        this.theMonth = BMonth.make(RHS.theMonth.getOrdinal());
        this.theDay = new HistoricalTimeZoneDay(RHS.getTheDay());
        this.theTimeOfDay = BTime.make(RHS.theTimeOfDay.getHour(), RHS.theTimeOfDay.getMinute(), RHS.theTimeOfDay.getSecond(), RHS.theTimeOfDay.getMillisecond());
        this.theTimeOfDayIsExpressedIn = RHS.theTimeOfDayIsExpressedIn;
    }

    public static HistoricalTimeZoneDate make() {
        return HistoricalTimeZoneDate.makeFromEpochMillis(System.currentTimeMillis());
    }

    public static HistoricalTimeZoneDate makeFromEpochMillis(long epochMillis) {
        HistoricalTimeZoneDate date = new HistoricalTimeZoneDate();
        GregorianCalendar desiredDate = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        desiredDate.clear();
        desiredDate.setTimeInMillis(epochMillis);
        date.theYear = (short)desiredDate.get(1);
        date.theMonth = BMonth.make((short)desiredDate.get(2));
        date.theDay = HistoricalTimeZoneDay.makeExactDay((short)desiredDate.get(5));
        date.theTimeOfDay = BTime.make(desiredDate.get(11), desiredDate.get(12), desiredDate.get(13), desiredDate.get(14));
        date.theTimeOfDayIsExpressedIn = (short)2;
        return date;
    }

    public static HistoricalTimeZoneDate make(short tempTheYear, BMonth tempTheMonth, HistoricalTimeZoneDay tempTheDay, BTime tempTheTimeOfDay, short tempTheTimeOfDayIsExpressedIn) {
        HistoricalTimeZoneDate date = new HistoricalTimeZoneDate();
        date.theYear = tempTheYear;
        date.theMonth = tempTheMonth;
        date.theDay = tempTheDay;
        date.theTimeOfDay = tempTheTimeOfDay;
        date.theTimeOfDayIsExpressedIn = tempTheTimeOfDayIsExpressedIn;
        return date;
    }

    public void update(short tempTheYear, BMonth tempTheMonth, HistoricalTimeZoneDay tempTheDay, BTime tempTheTimeOfDay, short tempTheTimeOfDayIsExpressedIn) {
        this.theYear = tempTheYear;
        this.theMonth = tempTheMonth;
        this.theDay = tempTheDay;
        this.theTimeOfDay = tempTheTimeOfDay;
        this.theTimeOfDayIsExpressedIn = tempTheTimeOfDayIsExpressedIn;
    }

    public void update(HistoricalTimeZoneDate tempTheDate) {
        this.update(tempTheDate.theYear, tempTheDate.theMonth, tempTheDate.theDay, tempTheDate.theTimeOfDay, tempTheDate.theTimeOfDayIsExpressedIn);
    }

    public static HistoricalTimeZoneDate makeYearStart(short desiredYear) {
        return HistoricalTimeZoneDate.make(desiredYear, BMonth.january, HistoricalTimeZoneDay.FIRST_DAY_OF_YEAR, BTime.MIDNIGHT, (short)0);
    }

    public static HistoricalTimeZoneDate makeYearEnd(short desiredYear) {
        return HistoricalTimeZoneDate.make(desiredYear, BMonth.december, HistoricalTimeZoneDay.LAST_DAY_OF_YEAR, BTime.make(23, 59, 59, 999), (short)0);
    }

    public static HistoricalTimeZoneDate makeYearMonthStart(short desiredYear, BMonth desiredMonth) {
        return HistoricalTimeZoneDate.make(desiredYear, desiredMonth, HistoricalTimeZoneDay.FIRST_DAY_OF_YEAR, BTime.MIDNIGHT, (short)0);
    }

    public static HistoricalTimeZoneDate makeYearMonthEnd(short desiredYear, BMonth desiredMonth) {
        short numDays = daysInMonth[desiredMonth.getOrdinal()];
        if (desiredMonth.equals(BMonth.february) && HistoricalTimeZoneDate.isLeapYear(desiredYear)) {
            numDays = (short)(numDays + 1);
        }
        return HistoricalTimeZoneDate.make(desiredYear, desiredMonth, HistoricalTimeZoneDay.makeExactDay(numDays), BTime.make(23, 59, 59, 999), (short)0);
    }

    public static HistoricalTimeZoneDate makeYearMonthDayStart(short desiredYear, BMonth desiredMonth, short desiredDay) throws TimeZoneException {
        short numDays = daysInMonth[desiredMonth.getOrdinal()];
        if (desiredMonth.equals(BMonth.february) && HistoricalTimeZoneDate.isLeapYear(desiredYear)) {
            numDays = (short)(numDays + 1);
        }
        if (desiredDay > numDays) {
            throw new TimeZoneException("ERROR: Requested an invalid day of the month.");
        }
        return HistoricalTimeZoneDate.make(desiredYear, desiredMonth, HistoricalTimeZoneDay.makeExactDay(desiredDay), BTime.MIDNIGHT, (short)0);
    }

    public static HistoricalTimeZoneDate makeYearMonthDayEnd(short desiredYear, BMonth desiredMonth, short desiredDay) throws TimeZoneException {
        short numDays = daysInMonth[desiredMonth.getOrdinal()];
        if (desiredMonth.equals(BMonth.february) && HistoricalTimeZoneDate.isLeapYear(desiredYear)) {
            numDays = (short)(numDays + 1);
        }
        if (desiredDay > numDays) {
            throw new TimeZoneException("ERROR: Requested an invalid day of the month.");
        }
        return HistoricalTimeZoneDate.make(desiredYear, desiredMonth, HistoricalTimeZoneDay.makeExactDay(desiredDay), BTime.make(23, 59, 59, 999), (short)0);
    }

    public static HistoricalTimeZoneDate makeAnnualDate(BMonth desiredMonth, HistoricalTimeZoneDay tempTheDay, BTime tempTheTimeOfDay, short tempTheTimeOfDayIsExpressedIn) {
        return HistoricalTimeZoneDate.make((short)-1, desiredMonth, tempTheDay, tempTheTimeOfDay, tempTheTimeOfDayIsExpressedIn);
    }

    public static HistoricalTimeZoneDate makeAnnualDate() {
        return HistoricalTimeZoneDate.makeAnnualDate(BMonth.january, HistoricalTimeZoneDay.makeExactDay((short)1), BTime.MIDNIGHT, (short)0);
    }

    public boolean equals(Object aRHS) {
        if (this == aRHS) {
            return true;
        }
        if (!(aRHS instanceof HistoricalTimeZoneDate)) {
            return false;
        }
        HistoricalTimeZoneDate RHS = (HistoricalTimeZoneDate)aRHS;
        return this.theYear == RHS.theYear && this.theMonth.equals(RHS.theMonth) && this.theDay.equals(RHS.theDay) && this.theTimeOfDay.equals(RHS.theTimeOfDay) && this.theTimeOfDayIsExpressedIn == RHS.theTimeOfDayIsExpressedIn;
    }

    public int hashCode() {
        return Objects.hash(this.theYear, this.theMonth, this.theDay, this.theTimeOfDay, this.theTimeOfDayIsExpressedIn);
    }

    public String toString() {
        if (this.theDay.getDayExpressedAs() == 0 && this.theDay.calendarDay != 0) {
            if (this.theYear == -1) {
                return "Annually on the " + this.theMonth.toString() + " " + this.theDay.toString() + " at " + this.theTimeOfDay.encodeToString() + " " + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
            }
            return this.theMonth.toString() + " " + this.theDay.toString() + ", " + this.theYear + " at " + this.theTimeOfDay.encodeToString() + " " + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
        }
        if (this.theYear == -1) {
            return "Annually on the " + this.theDay + " " + this.theMonth.toString() + " at " + this.theTimeOfDay.encodeToString() + " " + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
        }
        return this.theDay + " " + this.theMonth.toString() + ", " + this.theYear + " at " + this.theTimeOfDay.encodeToString() + " " + HistoricalTimeZoneDate.timePolicyToString(this.theTimeOfDayIsExpressedIn);
    }

    public StringTokenizer makeHistoricalTimeZoneDateFromString(StringTokenizer suspectTokens) {
        String token;
        this.theMonth = BMonth.january;
        this.theTimeOfDay = BTime.DEFAULT;
        this.theDay = HistoricalTimeZoneDay.make();
        this.theTimeOfDayIsExpressedIn = 0;
        int loopIteration = 0;
        block5: while (suspectTokens.hasMoreTokens() && (loopIteration = (int)((short)(loopIteration + 1))) < 4 && !(token = suspectTokens.nextToken()).startsWith("#")) {
            switch (loopIteration) {
                case 1: {
                    if (token.equalsIgnoreCase("Jan") || token.equalsIgnoreCase("January")) {
                        this.theMonth = BMonth.january;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Feb") || token.equalsIgnoreCase("February")) {
                        this.theMonth = BMonth.february;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Mar") || token.equalsIgnoreCase("March")) {
                        this.theMonth = BMonth.march;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Apr") || token.equalsIgnoreCase("April")) {
                        this.theMonth = BMonth.april;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("May")) {
                        this.theMonth = BMonth.may;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Jun") || token.equalsIgnoreCase("June")) {
                        this.theMonth = BMonth.june;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Jul") || token.equalsIgnoreCase("July")) {
                        this.theMonth = BMonth.july;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Aug") || token.equalsIgnoreCase("August")) {
                        this.theMonth = BMonth.august;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Sep") || token.equalsIgnoreCase("September")) {
                        this.theMonth = BMonth.september;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Oct") || token.equalsIgnoreCase("October")) {
                        this.theMonth = BMonth.october;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Nov") || token.equalsIgnoreCase("November")) {
                        this.theMonth = BMonth.november;
                        continue block5;
                    }
                    if (token.equalsIgnoreCase("Dec") || token.equalsIgnoreCase("December")) {
                        this.theMonth = BMonth.december;
                        continue block5;
                    }
                    this.theMonth = BMonth.january;
                    continue block5;
                }
                case 2: {
                    this.theDay = HistoricalTimeZoneDay.decodeFromString(token);
                    continue block5;
                }
                case 3: {
                    if (token.endsWith("s")) {
                        this.theTimeOfDayIsExpressedIn = 1;
                        token = token.substring(0, token.length() - 1);
                    } else if (token.endsWith("u") || token.endsWith("z") || token.endsWith("g")) {
                        this.theTimeOfDayIsExpressedIn = (short)2;
                        token = token.substring(0, token.length() - 1);
                    } else {
                        this.theTimeOfDayIsExpressedIn = 0;
                    }
                    long timeAsMillis = HistoricalTimeZoneDate.parseTime(token);
                    if (timeAsMillis == 86400000L) {
                        --timeAsMillis;
                    }
                    this.theTimeOfDay = BTime.make(BRelTime.make(timeAsMillis));
                    continue block5;
                }
            }
        }
        return suspectTokens;
    }

    public HistoricalTimeZoneDate convertToExactDate() throws TimeZoneException {
        if (this.theDay.getDayExpressedAs() != 0 && this.theDay.calendarDay != 0) {
            if (this.theYear == -1) {
                throw new TimeZoneException("ERROR: Cannot convert annual date without year");
            }
            Calendar newCal = this.toGregorianCalendar(this.theYear);
            this.theYear = (short)newCal.get(1);
            this.theMonth = BMonth.make(newCal.get(2));
            this.theDay.dayExpressedAs = (short)0;
            this.theDay.calendarDay = (short)newCal.get(5);
            this.theDay.dayOfWeek = BWeekday.make(newCal.get(7) - 1);
            this.theTimeOfDay = BTime.make(newCal.get(11), newCal.get(12), newCal.get(13), newCal.get(14));
        }
        return this;
    }

    public static long parseTime(String timeAsString) {
        String currentHour = "0";
        String currentMinute = "0";
        String currentSecond = "0";
        String currentMillis = "0";
        short utilIndex = (short)timeAsString.indexOf(":");
        if (utilIndex != -1) {
            currentHour = timeAsString.substring(0, utilIndex);
            if ((utilIndex = (short)(timeAsString = timeAsString.substring(utilIndex + 1)).indexOf(":")) != -1) {
                currentMinute = timeAsString.substring(0, utilIndex);
                if ((utilIndex = (short)(timeAsString = timeAsString.substring(utilIndex + 1)).indexOf(".")) != -1) {
                    currentSecond = timeAsString.substring(0, utilIndex);
                    currentMillis = timeAsString.substring(utilIndex + 1);
                } else {
                    currentSecond = timeAsString;
                }
            } else {
                currentMinute = timeAsString;
            }
        } else if (!timeAsString.equals("-")) {
            currentHour = timeAsString;
        }
        long timeInMillis = (long)Integer.parseInt(currentHour) * 3600000L;
        timeInMillis += (long)Integer.parseInt(currentMinute) * 60000L;
        timeInMillis += (long)Integer.parseInt(currentSecond) * 1000L;
        return timeInMillis += (long)Integer.parseInt(currentMillis);
    }

    private static boolean isLeapYear(short suspectYear) {
        boolean isLeapYear = suspectYear % 4 == 0;
        isLeapYear = isLeapYear && suspectYear % 100 != 0;
        isLeapYear = isLeapYear || suspectYear % 400 == 0;
        return isLeapYear;
    }

    public HistoricalTimeZoneDate convertAnnualDateForYear(short theYear) throws TimeZoneException {
        boolean thisIsAnnual;
        boolean bl = thisIsAnnual = this.theYear == -1;
        if (!thisIsAnnual) {
            throw new TimeZoneException("ERROR: convertAnnualDateForYear cannot convert NON-ANNUAL dates");
        }
        HistoricalTimeZoneDate returnValue = new HistoricalTimeZoneDate(this);
        returnValue.setTheYear(theYear);
        return returnValue.convertToExactDate();
    }

    public Calendar toGregorianCalendar(short targetYear) {
        GregorianCalendar newCal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        newCal.clear();
        newCal.set(1, targetYear);
        newCal.set(2, this.theMonth.getOrdinal());
        newCal.setLenient(false);
        short dayExpressedAs = this.theDay.getDayExpressedAs();
        short calendarDay = this.theDay.getCalendarDay();
        if (dayExpressedAs == 0 && calendarDay != 0) {
            newCal.set(5, this.theDay.getCalendarDay());
        } else if ((dayExpressedAs == 1 || dayExpressedAs == 2) && calendarDay != 0) {
            newCal.set(5, this.theDay.getCalendarDay());
            while (newCal.get(7) != this.theDay.getDayOfWeek().getOrdinal() + 1) {
                if (dayExpressedAs == 1) {
                    ((Calendar)newCal).add(5, 1);
                    continue;
                }
                ((Calendar)newCal).add(5, -1);
            }
        } else if (dayExpressedAs == 4 || dayExpressedAs == 5) {
            newCal.set(5, ((Calendar)newCal).getActualMaximum(5));
            while (newCal.get(7) != this.theDay.getDayOfWeek().getOrdinal() + 1) {
                ((Calendar)newCal).add(5, -1);
            }
        } else {
            int day = 0;
            if (dayExpressedAs == 0) {
                day = 1;
            } else if (dayExpressedAs == 1) {
                day = 8;
            } else if (dayExpressedAs == 2) {
                day = 15;
            } else if (dayExpressedAs == 3) {
                day = 22;
            }
            newCal.set(5, day);
            while (newCal.get(7) != this.theDay.getDayOfWeek().getOrdinal() + 1) {
                ((Calendar)newCal).add(5, 1);
            }
        }
        newCal.set(11, this.theTimeOfDay.getHour());
        newCal.set(12, this.theTimeOfDay.getMinute());
        newCal.set(13, this.theTimeOfDay.getSecond());
        newCal.set(14, this.theTimeOfDay.getMillisecond());
        return newCal;
    }

    public static boolean canBeCompared(HistoricalTimeZoneDate LHS, HistoricalTimeZoneDate RHS) {
        if (LHS.theYear != -1 && RHS.theYear != -1 && LHS.theYear != RHS.theYear) {
            return true;
        }
        if (LHS.theMonth != RHS.theMonth) {
            return true;
        }
        if (LHS.theDay.dayExpressedAs == 0 && LHS.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (LHS.theDay.calendarDay < RHS.theDay.calendarDay) {
                return true;
            }
            if (LHS.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return true;
            }
        }
        if (LHS.theDay.dayExpressedAs == 0 && LHS.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (LHS.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return true;
            }
            if (LHS.theDay.calendarDay > RHS.theDay.calendarDay) {
                return true;
            }
        }
        return RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0 && LHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0 && LHS.theDay.calendarDay != RHS.theDay.calendarDay;
    }

    public boolean occursAfterAbsolute(HistoricalTimeZoneDate RHS) throws TimeZoneException {
        Calendar RHSCal;
        if (this.theYear == -1 && RHS.theYear == -1) {
            throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 annual dates, use occursAfterForYear instead");
        }
        if (this.theYear != -1 && RHS.theYear != -1) {
            if (this.theYear < RHS.theYear) {
                return false;
            }
            if (this.theYear > RHS.theYear) {
                return true;
            }
        }
        if (this.theMonth.getMonthOfYear() < RHS.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theMonth.getMonthOfYear() > RHS.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isAfter(RHS.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return true;
            }
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return false;
            }
        }
        short targetYear = this.theYear == -1 ? RHS.theYear : this.theYear;
        boolean thisIsExact = this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0;
        boolean RHSIsExact = RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0;
        Calendar thisCal = !thisIsExact ? this.toGregorianCalendar(targetYear) : null;
        Calendar calendar = RHSCal = !RHSIsExact ? RHS.toGregorianCalendar(targetYear) : null;
        if (!thisIsExact && !RHSIsExact) {
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
            }
            return thisCal.after(RHSCal);
        }
        if (!thisIsExact) {
            if (thisCal.get(5) < RHS.theDay.calendarDay) {
                return false;
            }
            if (thisCal.get(5) > RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
            }
            if (thisCal.get(11) < RHS.theTimeOfDay.getHour()) {
                return false;
            }
            if (thisCal.get(11) > RHS.theTimeOfDay.getHour()) {
                return true;
            }
            if (thisCal.get(12) < RHS.theTimeOfDay.getMinute()) {
                return false;
            }
            if (thisCal.get(12) > RHS.theTimeOfDay.getMinute()) {
                return true;
            }
            if (thisCal.get(13) < RHS.theTimeOfDay.getSecond()) {
                return false;
            }
            if (thisCal.get(13) > RHS.theTimeOfDay.getSecond()) {
                return true;
            }
            return thisCal.get(14) > RHS.theTimeOfDay.getMillisecond();
        }
        if (this.theDay.calendarDay < RHSCal.get(5)) {
            return false;
        }
        if (this.theDay.calendarDay > RHSCal.get(5)) {
            return true;
        }
        if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + RHS);
            throw new TimeZoneException("ERROR: occursAfterAbsolute comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < RHSCal.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getHour() > RHSCal.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() < RHSCal.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() > RHSCal.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() < RHSCal.get(13)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() > RHSCal.get(13)) {
            return true;
        }
        return this.theTimeOfDay.getMillisecond() > RHSCal.get(14);
    }

    public boolean occursBeforeAbsolute(HistoricalTimeZoneDate RHS) throws TimeZoneException {
        Calendar RHSCal;
        if (this.theYear == -1 && RHS.theYear == -1) {
            throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 annual dates, use occursAfterForYear instead");
        }
        if (this.theYear != -1 && RHS.theYear != -1) {
            if (this.theYear < RHS.theYear) {
                return true;
            }
            if (this.theYear > RHS.theYear) {
                return false;
            }
        }
        if (this.theMonth.getMonthOfYear() < RHS.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theMonth.getMonthOfYear() > RHS.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isBefore(RHS.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return true;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return false;
            }
        }
        short targetYear = this.theYear == -1 ? RHS.theYear : this.theYear;
        boolean thisIsExact = this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0;
        boolean RHSIsExact = RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0;
        Calendar thisCal = !thisIsExact ? this.toGregorianCalendar(targetYear) : null;
        Calendar calendar = RHSCal = !RHSIsExact ? RHS.toGregorianCalendar(targetYear) : null;
        if (!thisIsExact && !RHSIsExact) {
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
            }
            return thisCal.before(RHSCal);
        }
        if (!thisIsExact) {
            if (thisCal.get(5) < RHS.theDay.calendarDay) {
                return true;
            }
            if (thisCal.get(5) > RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
            }
            if (thisCal.get(11) < RHS.theTimeOfDay.getHour()) {
                return true;
            }
            if (thisCal.get(11) > RHS.theTimeOfDay.getHour()) {
                return false;
            }
            if (thisCal.get(12) < RHS.theTimeOfDay.getMinute()) {
                return true;
            }
            if (thisCal.get(12) > RHS.theTimeOfDay.getMinute()) {
                return false;
            }
            if (thisCal.get(13) < RHS.theTimeOfDay.getSecond()) {
                return true;
            }
            if (thisCal.get(13) > RHS.theTimeOfDay.getSecond()) {
                return false;
            }
            return thisCal.get(14) < RHS.theTimeOfDay.getMillisecond();
        }
        if (this.theDay.calendarDay < RHSCal.get(5)) {
            return true;
        }
        if (this.theDay.calendarDay > RHSCal.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + RHS);
            throw new TimeZoneException("ERROR: occursBeforeAbsolute comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < RHSCal.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getHour() > RHSCal.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() < RHSCal.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() > RHSCal.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() < RHSCal.get(13)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() > RHSCal.get(13)) {
            return false;
        }
        return this.theTimeOfDay.getMillisecond() < RHSCal.get(14);
    }

    public boolean occursOnAbsolute(HistoricalTimeZoneDate RHS) throws TimeZoneException {
        Calendar RHSCal;
        if (this.theYear == -1 && RHS.theYear == -1) {
            throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 annual dates, use occursOnForYear instead");
        }
        if (this.theYear != -1 && RHS.theYear != -1 && this.theYear != RHS.theYear) {
            return false;
        }
        if (this.theMonth.getMonthOfYear() != RHS.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay != RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.equivalent(RHS.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return false;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return false;
            }
        }
        short targetYear = this.theYear == -1 ? RHS.theYear : this.theYear;
        boolean thisIsExact = this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0;
        boolean RHSIsExact = RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0;
        Calendar thisCal = !thisIsExact ? this.toGregorianCalendar(targetYear) : null;
        Calendar calendar = RHSCal = !RHSIsExact ? RHS.toGregorianCalendar(targetYear) : null;
        if (!thisIsExact && !RHSIsExact) {
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
            }
            return thisCal.equals(RHSCal);
        }
        if (!thisIsExact) {
            if (thisCal.get(5) != RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
            }
            return thisCal.get(11) == RHS.theTimeOfDay.getHour() && thisCal.get(12) == RHS.theTimeOfDay.getMinute() && thisCal.get(13) == RHS.theTimeOfDay.getSecond() && thisCal.get(14) == RHS.theTimeOfDay.getMillisecond();
        }
        if (this.theDay.calendarDay != RHSCal.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + RHS);
            throw new TimeZoneException("ERROR: occursOnAbsolute comparing 2 times expressed differently");
        }
        return this.theTimeOfDay.getHour() == RHSCal.get(11) && this.theTimeOfDay.getMinute() == RHSCal.get(12) && this.theTimeOfDay.getSecond() == RHSCal.get(13) && this.theTimeOfDay.getMillisecond() == RHSCal.get(14);
    }

    public boolean occursAfterOrOnAbsolute(HistoricalTimeZoneDate RHS) throws TimeZoneException {
        try {
            return this.occursOnAbsolute(RHS) || this.occursAfterAbsolute(RHS);
        }
        catch (TimeZoneException e) {
            if (e.getMessage().startsWith("ERROR")) {
                throw e;
            }
            throw new TimeZoneException("ERROR: occursAfterOrOnAbsolute comparing 2 annual dates, use occursAfterOrOnForYear instead");
        }
    }

    public boolean occursBeforeOrOnAbsolute(HistoricalTimeZoneDate RHS) throws TimeZoneException {
        try {
            return this.occursOnAbsolute(RHS) || this.occursBeforeAbsolute(RHS);
        }
        catch (TimeZoneException e) {
            if (e.getMessage().startsWith("ERROR")) {
                throw e;
            }
            throw new TimeZoneException("ERROR: occursBeforeOrOnAbsolute comparing 2 annual dates, use occursBeforeOrOnForYear instead");
        }
    }

    public boolean occursAfterForYear(HistoricalTimeZoneDate RHS, short targetYear) throws TimeZoneException {
        Calendar RHSCal;
        boolean RHSIsAnnual;
        boolean thisIsAnnual = this.theYear == -1;
        boolean bl = RHSIsAnnual = RHS.theYear == -1;
        if (!thisIsAnnual && !RHSIsAnnual) {
            if (this.theYear != RHS.theYear) {
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterAbsolute instead");
            }
            if (targetYear != this.theYear) {
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 absolute dates for a different year than their own");
            }
        } else if (thisIsAnnual && !RHSIsAnnual ? targetYear != RHS.theYear : !thisIsAnnual && RHSIsAnnual && targetYear != this.theYear) {
            throw new TimeZoneException("ERROR: occursAfterForYear comparing absolute date for a different year than its own");
        }
        if (!thisIsAnnual || !RHSIsAnnual) {
            return this.occursAfterAbsolute(RHS);
        }
        if (this.theMonth.getMonthOfYear() < RHS.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theMonth.getMonthOfYear() > RHS.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isAfter(RHS.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return true;
            }
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return false;
            }
        }
        boolean thisIsExact = this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0;
        boolean RHSIsExact = RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0;
        Calendar thisCal = !thisIsExact ? this.toGregorianCalendar(targetYear) : null;
        Calendar calendar = RHSCal = !RHSIsExact ? RHS.toGregorianCalendar(targetYear) : null;
        if (!thisIsExact && !RHSIsExact) {
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
            }
            return thisCal.after(RHSCal);
        }
        if (!thisIsExact) {
            if (thisCal.get(5) < RHS.theDay.calendarDay) {
                return false;
            }
            if (thisCal.get(5) > RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
            }
            if (thisCal.get(11) < RHS.theTimeOfDay.getHour()) {
                return false;
            }
            if (thisCal.get(11) > RHS.theTimeOfDay.getHour()) {
                return true;
            }
            if (thisCal.get(12) < RHS.theTimeOfDay.getMinute()) {
                return false;
            }
            if (thisCal.get(12) > RHS.theTimeOfDay.getMinute()) {
                return true;
            }
            if (thisCal.get(13) < RHS.theTimeOfDay.getSecond()) {
                return false;
            }
            if (thisCal.get(13) > RHS.theTimeOfDay.getSecond()) {
                return true;
            }
            return thisCal.get(14) > RHS.theTimeOfDay.getMillisecond();
        }
        if (this.theDay.calendarDay < RHSCal.get(5)) {
            return false;
        }
        if (this.theDay.calendarDay > RHSCal.get(5)) {
            return true;
        }
        if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + RHS);
            throw new TimeZoneException("ERROR: occursAfterForYear comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < RHSCal.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getHour() > RHSCal.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() < RHSCal.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() > RHSCal.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() < RHSCal.get(13)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() > RHSCal.get(13)) {
            return true;
        }
        return this.theTimeOfDay.getMillisecond() > RHSCal.get(14);
    }

    public boolean occursBeforeForYear(HistoricalTimeZoneDate RHS, short targetYear) throws TimeZoneException {
        Calendar RHSCal;
        boolean RHSIsAnnual;
        boolean thisIsAnnual = this.theYear == -1;
        boolean bl = RHSIsAnnual = RHS.theYear == -1;
        if (!thisIsAnnual && !RHSIsAnnual) {
            if (this.theYear != RHS.theYear) {
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterAbsolute instead");
            }
            if (targetYear != this.theYear) {
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 absolute dates for a different year than their own");
            }
        } else if (thisIsAnnual && !RHSIsAnnual ? targetYear != RHS.theYear : !thisIsAnnual && RHSIsAnnual && targetYear != this.theYear) {
            throw new TimeZoneException("ERROR: occursBeforeForYear comparing absolute date for a different year than its own");
        }
        if (!thisIsAnnual || !RHSIsAnnual) {
            return this.occursBeforeAbsolute(RHS);
        }
        if (this.theMonth.getMonthOfYear() < RHS.theMonth.getMonthOfYear()) {
            return true;
        }
        if (this.theMonth.getMonthOfYear() > RHS.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.isBefore(RHS.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return true;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return true;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return false;
            }
        }
        boolean thisIsExact = this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0;
        boolean RHSIsExact = RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0;
        Calendar thisCal = !thisIsExact ? this.toGregorianCalendar(targetYear) : null;
        Calendar calendar = RHSCal = !RHSIsExact ? RHS.toGregorianCalendar(targetYear) : null;
        if (!thisIsExact && !RHSIsExact) {
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
            }
            return thisCal.before(RHSCal);
        }
        if (!thisIsExact) {
            if (thisCal.get(5) < RHS.theDay.calendarDay) {
                return true;
            }
            if (thisCal.get(5) > RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
            }
            if (thisCal.get(11) < RHS.theTimeOfDay.getHour()) {
                return true;
            }
            if (thisCal.get(11) > RHS.theTimeOfDay.getHour()) {
                return false;
            }
            if (thisCal.get(12) < RHS.theTimeOfDay.getMinute()) {
                return true;
            }
            if (thisCal.get(12) > RHS.theTimeOfDay.getMinute()) {
                return false;
            }
            if (thisCal.get(13) < RHS.theTimeOfDay.getSecond()) {
                return true;
            }
            if (thisCal.get(13) > RHS.theTimeOfDay.getSecond()) {
                return false;
            }
            return thisCal.get(14) < RHS.theTimeOfDay.getMillisecond();
        }
        if (this.theDay.calendarDay < RHSCal.get(5)) {
            return true;
        }
        if (this.theDay.calendarDay > RHSCal.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + RHS);
            throw new TimeZoneException("ERROR: occursBeforeForYear comparing 2 times expressed differently");
        }
        if (this.theTimeOfDay.getHour() < RHSCal.get(11)) {
            return true;
        }
        if (this.theTimeOfDay.getHour() > RHSCal.get(11)) {
            return false;
        }
        if (this.theTimeOfDay.getMinute() < RHSCal.get(12)) {
            return true;
        }
        if (this.theTimeOfDay.getMinute() > RHSCal.get(12)) {
            return false;
        }
        if (this.theTimeOfDay.getSecond() < RHSCal.get(13)) {
            return true;
        }
        if (this.theTimeOfDay.getSecond() > RHSCal.get(13)) {
            return false;
        }
        return this.theTimeOfDay.getMillisecond() < RHSCal.get(14);
    }

    public boolean occursOnForYear(HistoricalTimeZoneDate RHS, short targetYear) throws TimeZoneException {
        Calendar RHSCal;
        boolean RHSIsAnnual;
        boolean thisIsAnnual = this.theYear == -1;
        boolean bl = RHSIsAnnual = RHS.theYear == -1;
        if (!thisIsAnnual && !RHSIsAnnual) {
            if (this.theYear != RHS.theYear) {
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterAbsolute instead");
            }
            if (targetYear != this.theYear) {
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 absolute dates for a different year than their own");
            }
        } else if (thisIsAnnual && !RHSIsAnnual ? targetYear != RHS.theYear : !thisIsAnnual && RHSIsAnnual && targetYear != this.theYear) {
            throw new TimeZoneException("ERROR: occursOnForYear comparing absolute date for a different year than its own");
        }
        if (!thisIsAnnual || !RHSIsAnnual) {
            return this.occursOnAbsolute(RHS);
        }
        if (this.theMonth.getMonthOfYear() != RHS.theMonth.getMonthOfYear()) {
            return false;
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0) {
            if (this.theDay.calendarDay != RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
            }
            return this.theTimeOfDay.equivalent(RHS.theTimeOfDay);
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 1) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay + 7) {
                return false;
            }
        }
        if (this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0 && RHS.theDay.dayExpressedAs == 2) {
            if (this.theDay.calendarDay < RHS.theDay.calendarDay - 7) {
                return false;
            }
            if (this.theDay.calendarDay > RHS.theDay.calendarDay) {
                return false;
            }
        }
        boolean thisIsExact = this.theDay.dayExpressedAs == 0 && this.theDay.calendarDay != 0;
        boolean RHSIsExact = RHS.theDay.dayExpressedAs == 0 && RHS.theDay.calendarDay != 0;
        Calendar thisCal = !thisIsExact ? this.toGregorianCalendar(targetYear) : null;
        Calendar calendar = RHSCal = !RHSIsExact ? RHS.toGregorianCalendar(targetYear) : null;
        if (!thisIsExact && !RHSIsExact) {
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
            }
            return thisCal.equals(RHSCal);
        }
        if (!thisIsExact) {
            if (thisCal.get(5) != RHS.theDay.calendarDay) {
                return false;
            }
            if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
                System.out.println("Can't compare: " + this + " to " + RHS);
                throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
            }
            return thisCal.get(11) == RHS.theTimeOfDay.getHour() && thisCal.get(12) == RHS.theTimeOfDay.getMinute() && thisCal.get(13) == RHS.theTimeOfDay.getSecond() && thisCal.get(14) == RHS.theTimeOfDay.getMillisecond();
        }
        if (this.theDay.calendarDay == RHSCal.get(5)) {
            return false;
        }
        if (this.theTimeOfDayIsExpressedIn != RHS.theTimeOfDayIsExpressedIn) {
            System.out.println("Can't compare: " + this + " to " + RHS);
            throw new TimeZoneException("ERROR: occursOnForYear comparing 2 times expressed differently");
        }
        return this.theTimeOfDay.getHour() == RHSCal.get(11) && this.theTimeOfDay.getMinute() == RHSCal.get(12) && this.theTimeOfDay.getSecond() == RHSCal.get(13) && this.theTimeOfDay.getMillisecond() == RHSCal.get(14);
    }

    public boolean occursAfterOrOnForYear(HistoricalTimeZoneDate RHS, short targetYear) throws TimeZoneException {
        try {
            return this.occursOnForYear(RHS, targetYear) || this.occursAfterForYear(RHS, targetYear);
        }
        catch (TimeZoneException e) {
            if (e.getMessage().startsWith("ERROR")) {
                throw e;
            }
            throw new TimeZoneException("ERROR: occursAfterOrOnForYear comparing 2 absolute dates that don't fall on the same year, use OccursAfterOrOnAbsolute instead");
        }
    }

    public boolean occursBeforeOrOnForYear(HistoricalTimeZoneDate RHS, short targetYear) throws TimeZoneException {
        try {
            return this.occursOnForYear(RHS, targetYear) || this.occursBeforeForYear(RHS, targetYear);
        }
        catch (TimeZoneException e) {
            if (e.getMessage().startsWith("ERROR")) {
                throw e;
            }
            throw new TimeZoneException("ERROR: occursBeforeOrOnForYear comparing 2 absolute dates that don't fall on the same year, use OccursBeforeOrOnAbsolute instead");
        }
    }

    public HistoricalTimeZoneDay getTheDay() {
        return this.theDay;
    }

    public BMonth getTheMonth() {
        return this.theMonth;
    }

    public short getTheTimeOfDayIsExpressedAs() {
        return this.theTimeOfDayIsExpressedIn;
    }

    public BTime getTheTimeOfDay() {
        return this.theTimeOfDay;
    }

    public short getTheYear() {
        return this.theYear;
    }

    private void setTheYear(short theYear) {
        this.theYear = theYear;
    }

    public HistoricalTimeZoneDate setTheTimeOfDayIsExpressedAs(short tempExpressedAs) {
        this.theTimeOfDayIsExpressedIn = tempExpressedAs;
        return this;
    }

    public static final class HistoricalTimeZoneDay {
        public static final HistoricalTimeZoneDay FIRST_DAY_OF_YEAR = HistoricalTimeZoneDay.makeExactDay((short)1);
        public static final HistoricalTimeZoneDay LAST_DAY_OF_YEAR = HistoricalTimeZoneDay.makeExactDay((short)31);
        private short dayExpressedAs;
        private short calendarDay;
        private BWeekday dayOfWeek;

        public static String encodePolicy(short tempPolicy, short day) {
            if (tempPolicy == 2 && day != 0) {
                return "First";
            }
            if (tempPolicy == 1 && day != 0) {
                return "First";
            }
            if (tempPolicy == 0 && day != 0) {
                return "Exact";
            }
            if (tempPolicy == 0) {
                return "First";
            }
            if (tempPolicy == 1) {
                return "Second";
            }
            if (tempPolicy == 2) {
                return "Third";
            }
            if (tempPolicy == 3) {
                return "Fourth";
            }
            if (tempPolicy == 4) {
                return "Fifth";
            }
            if (tempPolicy == 5) {
                return "Last";
            }
            return "Undefined";
        }

        public static String encodeDay(short tempDay) {
            switch (tempDay) {
                case 0: {
                    return "Sunday";
                }
                case 1: {
                    return "Monday";
                }
                case 2: {
                    return "Tuesday";
                }
                case 3: {
                    return "Wednesday";
                }
                case 4: {
                    return "Thursday";
                }
                case 5: {
                    return "Friday";
                }
                case 6: {
                    return "Saturday";
                }
            }
            return "Undefined";
        }

        private HistoricalTimeZoneDay() {
        }

        public HistoricalTimeZoneDay(HistoricalTimeZoneDay RHS) {
            this.calendarDay = RHS.calendarDay;
            this.dayExpressedAs = RHS.dayExpressedAs;
            this.dayOfWeek = RHS.dayOfWeek != null ? BWeekday.make(RHS.dayOfWeek.getOrdinal()) : BWeekday.sunday;
        }

        public static HistoricalTimeZoneDay decodeFromString(String dayAsString) {
            short bufCalendarDay;
            int bufDayExpressedAs = 0;
            BWeekday bufWeekday = BWeekday.sunday;
            if (dayAsString.length() <= 2) {
                return HistoricalTimeZoneDay.makeExactDay((short)Integer.parseInt(dayAsString));
            }
            short utilIndex = (short)dayAsString.indexOf("<=");
            if (utilIndex != -1) {
                String utilToken = dayAsString.substring(utilIndex + 2);
                bufDayExpressedAs = 2;
                bufCalendarDay = (short)Integer.parseInt(utilToken);
            } else {
                utilIndex = (short)dayAsString.indexOf(">=");
                if (utilIndex != -1) {
                    String utilToken = dayAsString.substring(utilIndex + 2);
                    bufDayExpressedAs = 1;
                    bufCalendarDay = (short)Integer.parseInt(utilToken);
                } else {
                    if (dayAsString.startsWith("first")) {
                        bufDayExpressedAs = 0;
                    } else if (dayAsString.startsWith("second")) {
                        bufDayExpressedAs = 1;
                    } else if (dayAsString.startsWith("third")) {
                        bufDayExpressedAs = 2;
                    } else if (dayAsString.startsWith("fourth")) {
                        bufDayExpressedAs = 3;
                    } else if (dayAsString.startsWith("fifth")) {
                        bufDayExpressedAs = 4;
                    } else if (dayAsString.startsWith("last")) {
                        bufDayExpressedAs = 5;
                    }
                    bufCalendarDay = 0;
                }
            }
            if (dayAsString.indexOf("Sun") != -1) {
                bufWeekday = BWeekday.sunday;
            } else if (dayAsString.indexOf("Mon") != -1) {
                bufWeekday = BWeekday.monday;
            } else if (dayAsString.indexOf("Tue") != -1) {
                bufWeekday = BWeekday.tuesday;
            } else if (dayAsString.indexOf("Wed") != -1) {
                bufWeekday = BWeekday.wednesday;
            } else if (dayAsString.indexOf("Thu") != -1) {
                bufWeekday = BWeekday.thursday;
            } else if (dayAsString.indexOf("Fri") != -1) {
                bufWeekday = BWeekday.friday;
            } else if (dayAsString.indexOf("Sat") != -1) {
                bufWeekday = BWeekday.saturday;
            }
            return HistoricalTimeZoneDay.make(bufCalendarDay, (short)bufDayExpressedAs, bufWeekday);
        }

        public static HistoricalTimeZoneDay make() {
            return HistoricalTimeZoneDay.makeExactDay((short)1);
        }

        public static HistoricalTimeZoneDay make(short tempCalendarDay, short tempDayExpressedAs, BWeekday tempDayOfWeek) {
            HistoricalTimeZoneDay day = new HistoricalTimeZoneDay();
            day.calendarDay = tempCalendarDay;
            day.dayExpressedAs = tempDayExpressedAs;
            day.dayOfWeek = tempDayOfWeek;
            return day;
        }

        public void update(short tempCalendarDay, short tempDayExpressedAs, BWeekday tempDayOfWeek) {
            this.calendarDay = tempCalendarDay;
            this.dayExpressedAs = tempDayExpressedAs;
            this.dayOfWeek = tempDayOfWeek;
        }

        public void update(HistoricalTimeZoneDay tempTheDay) {
            this.update(tempTheDay.calendarDay, tempTheDay.dayExpressedAs, tempTheDay.dayOfWeek);
        }

        public static HistoricalTimeZoneDay makeExactDay(short theDesiredDay) {
            return HistoricalTimeZoneDay.make(theDesiredDay, (short)0, BWeekday.sunday);
        }

        public static HistoricalTimeZoneDay makeOnOrAfter(BWeekday theDesiredWeekday, short theDesiredDay) {
            return HistoricalTimeZoneDay.make(theDesiredDay, (short)1, theDesiredWeekday);
        }

        public static HistoricalTimeZoneDay makeOnOrBefore(BWeekday theDesiredWeekday, short theDesiredDay) {
            return HistoricalTimeZoneDay.make(theDesiredDay, (short)2, theDesiredWeekday);
        }

        public static HistoricalTimeZoneDay makeNthWeekday(short theWeek, BWeekday theDesiredWeekday) {
            return HistoricalTimeZoneDay.make((short)0, theWeek, theDesiredWeekday);
        }

        public boolean equals(Object aRHS) {
            if (this == aRHS) {
                return true;
            }
            if (!(aRHS instanceof HistoricalTimeZoneDay)) {
                return false;
            }
            HistoricalTimeZoneDay RHS = (HistoricalTimeZoneDay)aRHS;
            return this.dayExpressedAs == RHS.dayExpressedAs && this.dayOfWeek == RHS.dayOfWeek && this.calendarDay == RHS.calendarDay;
        }

        public int hashCode() {
            return Objects.hash(this.dayExpressedAs, this.dayOfWeek, this.calendarDay);
        }

        public String toString() {
            if (this.dayExpressedAs == 0 && this.calendarDay != 0) {
                return "" + this.calendarDay;
            }
            if (this.dayExpressedAs == 2 && this.calendarDay != 0) {
                return HistoricalTimeZoneDay.encodePolicy(this.dayExpressedAs, this.calendarDay) + " " + HistoricalTimeZoneDay.encodeDay((short)this.dayOfWeek.getOrdinal()) + " on or before " + this.calendarDay + " in";
            }
            if (this.dayExpressedAs == 1 && this.calendarDay != 0) {
                return HistoricalTimeZoneDay.encodePolicy(this.dayExpressedAs, this.calendarDay) + " " + HistoricalTimeZoneDay.encodeDay((short)this.dayOfWeek.getOrdinal()) + " on or after " + this.calendarDay + " in";
            }
            if (this.dayExpressedAs == 0 || this.dayExpressedAs == 1 || this.dayExpressedAs == 2 || this.dayExpressedAs == 3 || this.dayExpressedAs == 4 || this.dayExpressedAs == 5) {
                return HistoricalTimeZoneDay.encodePolicy(this.dayExpressedAs, this.calendarDay) + " " + HistoricalTimeZoneDay.encodeDay((short)this.dayOfWeek.getOrdinal()) + " in";
            }
            return "Invalid Policy";
        }

        public short getCalendarDay() {
            return this.calendarDay;
        }

        public short getDayExpressedAs() {
            return this.dayExpressedAs;
        }

        public BWeekday getDayOfWeek() {
            return this.dayOfWeek;
        }
    }
}

