/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.FIELD_WIDTH", value="55")}), @NiagaraProperty(name="delay", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="retryInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(15)")}), @NiagaraProperty(name="lastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="lastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="nextExecuteTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")})})
@NiagaraActions(value={@NiagaraAction(name="schedule"), @NiagaraAction(name="execute", flags=16), @NiagaraAction(name="cancel")})
public abstract class BRetryableAction
extends BVector {
    @Generated
    public static final Property status = BRetryableAction.newProperty(3, BStatus.ok, null);
    @Generated
    public static final Property faultCause = BRetryableAction.newProperty(3, "", BFacets.make("fieldWidth", 55));
    @Generated
    public static final Property delay = BRetryableAction.newProperty(0, BRelTime.makeSeconds(30), BFacets.make("min", BRelTime.DEFAULT));
    @Generated
    public static final Property retryInterval = BRetryableAction.newProperty(0, BRelTime.makeMinutes(5), BFacets.make("min", BRelTime.makeSeconds(15)));
    @Generated
    public static final Property lastSuccess = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    @Generated
    public static final Property lastAttempt = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    @Generated
    public static final Property nextExecuteTime = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    @Generated
    public static final Action schedule = BRetryableAction.newAction(0, null);
    @Generated
    public static final Action execute = BRetryableAction.newAction(16, null);
    @Generated
    public static final Action cancel = BRetryableAction.newAction(0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRetryableAction.class);
    private Clock.Ticket ticket = Clock.expiredTicket;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    @Generated
    public void setDelay(BRelTime v) {
        this.set(delay, (BValue)v, null);
    }

    @Generated
    public BRelTime getRetryInterval() {
        return (BRelTime)this.get(retryInterval);
    }

    @Generated
    public void setRetryInterval(BRelTime v) {
        this.set(retryInterval, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    @Generated
    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    @Generated
    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextExecuteTime() {
        return (BAbsTime)this.get(nextExecuteTime);
    }

    @Generated
    public void setNextExecuteTime(BAbsTime v) {
        this.set(nextExecuteTime, (BValue)v, null);
    }

    @Generated
    public void schedule() {
        this.invoke(schedule, null, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public void cancel() {
        this.invoke(cancel, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.isRetryCondition()) {
            this.schedule();
        }
    }

    public final void doSchedule() {
        BAbsTime time = Clock.time();
        BAbsTime nextExecute = this.getNextExecuteTime();
        if (nextExecute.isNull() || this.ticket.isExpired()) {
            this.cancelTicket();
            BAbsTime when = time.add(this.getDelay());
            this.ticket = Clock.schedule((BComponent)this, when, execute, null);
            this.setNextExecuteTime(when);
        }
    }

    public final void doExecute() {
        try {
            this.setLastAttempt(Clock.time());
            this.cancelTicket();
            this.doExecution();
            this.configSuccess();
        }
        catch (Exception x) {
            this.configFail(x);
        }
    }

    protected abstract void doExecution() throws Exception;

    public final void doCancel() {
        this.stopRetrying();
        this.canceled();
    }

    protected void canceled() {
    }

    protected final void configSuccess() {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setNextExecuteTime(BAbsTime.NULL);
        this.setLastSuccess(Clock.time());
    }

    private void configFail(Exception x) {
        String msg = x.getMessage();
        if (msg == null) {
            msg = "Execution failed.";
            x.printStackTrace();
        }
        this.setStatus(BStatus.fault);
        this.setFaultCause(msg);
        this.scheduleRetry();
    }

    protected void scheduleRetry() {
        this.cancelTicket();
        BAbsTime when = Clock.time().add(this.getRetryInterval());
        this.ticket = Clock.schedule((BComponent)this, when, execute, null);
        this.setNextExecuteTime(when);
    }

    protected final void stopRetrying() {
        this.cancelTicket();
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setNextExecuteTime(BAbsTime.NULL);
    }

    protected final void cancelTicket() {
        this.ticket.cancel();
        this.ticket = Clock.expiredTicket;
    }

    public final boolean isRetryCondition() {
        return !this.getNextExecuteTime().isNull() || this.getLastAttempt().isAfter(this.getLastSuccess());
    }
}

