/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class CoalescedBatchResolve {
    private BOrd[] ords;
    private final BatchResolve batchResolve;
    private Map<BOrd, Integer> map;
    private static final BOrd[] EMPTY_ORD_ARRAY = new BOrd[0];
    private static final Logger LOG = Logger.getLogger(CoalescedBatchResolve.class.getName());
    private static final boolean DISABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.baja.disableViewQueryCoalesce"));

    public CoalescedBatchResolve(BOrd[] ords) {
        if (DISABLED || ords.length == 1) {
            if (LOG.isLoggable(Level.FINE)) {
                if (DISABLED) {
                    LOG.fine("disabled: " + ords.length);
                } else {
                    LOG.fine("no savings: " + ords.length);
                }
            }
            this.batchResolve = new BatchResolve(ords);
            return;
        }
        ords = (BOrd[])ords.clone();
        this.ords = ords;
        boolean requiresMap = false;
        LinkedHashMap<BOrd, Integer> map = new LinkedHashMap<BOrd, Integer>();
        for (BOrd ord : ords) {
            BOrd key = CoalescedBatchResolve.getKey(CoalescedBatchResolve.getOrdQuery(ord), ord);
            Integer index = (Integer)map.get(key);
            if (index == null) {
                map.put(key, map.size());
                continue;
            }
            requiresMap = true;
        }
        if (requiresMap) {
            this.map = map;
            this.batchResolve = new BatchResolve(map.keySet().toArray(EMPTY_ORD_ARRAY));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("savings: " + ords.length + " > " + this.batchResolve.size());
            }
        } else {
            this.batchResolve = new BatchResolve(ords);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no savings: " + ords.length);
            }
        }
    }

    public int size() {
        if (this.map == null) {
            return this.batchResolve.size();
        }
        return this.ords.length;
    }

    public boolean isResolved(int index) {
        if (this.map == null) {
            return this.batchResolve.isResolved(index);
        }
        BOrd ord = this.ords[index];
        OrdQuery[] queries = CoalescedBatchResolve.getOrdQuery(ord);
        BOrd key = CoalescedBatchResolve.getKey(queries, ord);
        return this.batchResolve.isResolved(this.map.get(key));
    }

    public Throwable getException(int index) {
        if (this.map == null) {
            return this.batchResolve.getException(index);
        }
        BOrd ord = this.ords[index];
        OrdQuery[] queries = CoalescedBatchResolve.getOrdQuery(ord);
        BOrd key = CoalescedBatchResolve.getKey(queries, ord);
        return this.batchResolve.getException(this.map.get(key));
    }

    public OrdTarget getTarget(int index) {
        if (this.map == null) {
            return this.batchResolve.getTarget(index);
        }
        BOrd ord = this.ords[index];
        OrdQuery[] queries = CoalescedBatchResolve.getOrdQuery(ord);
        ViewQuery viewQuery = CoalescedBatchResolve.getViewQuery(queries);
        BOrd key = CoalescedBatchResolve.getKey(queries, ord);
        OrdTarget targetWithoutViewQuery = this.batchResolve.getTarget(this.map.get(key));
        if (viewQuery == null) {
            return targetWithoutViewQuery;
        }
        return OrdTarget.makeWithViewQuery(targetWithoutViewQuery, viewQuery);
    }

    public CoalescedBatchResolve resolve(BObject base) {
        return this.resolve(base, null);
    }

    public CoalescedBatchResolve resolve(BObject base, Context cx) {
        this.batchResolve.resolve(base, cx);
        return this;
    }

    private static BOrd getKey(OrdQuery[] queries, BOrd ord) {
        if (queries == null) {
            return ord;
        }
        int n = queries.length - 1;
        if (n >= 0 && queries[n] instanceof ViewQuery) {
            return BOrd.make(queries, 0, queries.length - 1);
        }
        return ord;
    }

    private static OrdQuery[] getOrdQuery(BOrd ord) {
        try {
            ord = ord.normalize();
            return ord.parse();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Cannot getOrdQuery: " + ord, e);
            }
            return null;
        }
    }

    private static ViewQuery getViewQuery(OrdQuery[] queries) {
        if (queries == null) {
            return null;
        }
        int n = queries.length - 1;
        if (n >= 0 && queries[n] instanceof ViewQuery) {
            return (ViewQuery)queries[n];
        }
        return null;
    }
}

