/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Iterator;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.IterableCursor;

public class IteratorCursor<T extends BObject>
implements IterableCursor<T> {
    private final BObject target;
    private final Iterator<T> values;
    private BObject current;
    private final Context context;
    private volatile boolean closed;

    public IteratorCursor(BObject target, Iterator<T> values) {
        this(target, values, null);
    }

    public IteratorCursor(BObject target, Iterator<T> values, Context context) {
        this.target = target;
        this.values = values;
        this.context = context;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public BObject target() {
        return this.target;
    }

    @Override
    public boolean next() {
        if (this.values.hasNext() && !this.closed) {
            this.current = (BObject)this.values.next();
            return true;
        }
        this.current = null;
        return false;
    }

    public boolean nextObject() {
        while (this.next()) {
            if (this.current instanceof BBoolean || this.current instanceof BInteger || this.current instanceof BFloat || this.current instanceof BString) continue;
            return true;
        }
        return false;
    }

    @Override
    public final T get() {
        if (this.closed) {
            throw new CursorException("cursor was closed");
        }
        BObject localObject = this.getValue(this.current);
        return (T)localObject;
    }

    protected BObject getValue(BObject o) {
        return o;
    }
}

