/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.io.PrintWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.file.BSubSpaceFile;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.LexiconText;

public class ObjectUtil {
    public static final String MODULE_DEPENDENCY_FACET_KEY = "stationModuleDependencies";
    private static TypeInfo bogSpaceTypeInfo = null;
    private static final LexiconText RANGE_TEXT = LexiconText.make("baja", "minMaxRange");
    private static final Logger LOG = Logger.getLogger("baja");
    public static final boolean SERVER_MIN_MAX_CHECK_DISABLED = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.serverMinMaxChecks.disabled"));
    public static final Set<TypeInfo> DEFAULT_MIN_MAX_CHECK_EXCLUDED_TYPES = Collections.singleton(BBoolean.TYPE.getTypeInfo());
    public static final Set<TypeInfo> MIN_MAX_CHECK_EXCLUDED_TYPES;

    public static String generateUniqueName(String defName, NameContainer container) {
        char c;
        int i;
        if (!container.contains(defName)) {
            return defName;
        }
        int divIndex = -1;
        int i2 = defName.length() - 1;
        while (i2 >= 0 && Character.isDigit(defName.charAt(i2))) {
            divIndex = i2--;
        }
        String base = defName;
        int num = 1;
        if (divIndex > 0) {
            base = defName.substring(0, divIndex);
            num = Integer.parseInt(defName.substring(divIndex)) + 1;
            for (i = divIndex; i < defName.length() - 1 && (c = defName.charAt(i)) == '0'; ++i) {
                base = base + '0';
            }
        } else if (divIndex == 0) {
            base = "";
            num = Integer.parseInt(defName) + 1;
            for (i = divIndex; i < defName.length() - 1 && (c = defName.charAt(i)) == '0'; ++i) {
                base = base + '0';
            }
        }
        i = num;
        while (true) {
            if (i - num > 100000) {
                throw new IllegalStateException("NameContainer not functioning");
            }
            String name = base + i;
            if (!container.contains(name)) {
                return name;
            }
            ++i;
        }
    }

    public static String generateUniqueSlotName(String defName, NameContainer container) {
        char c;
        int i;
        if (!container.contains(defName)) {
            return defName;
        }
        defName = SlotPath.unescape(defName);
        int divIndex = -1;
        int i2 = defName.length() - 1;
        while (i2 >= 0 && Character.isDigit(defName.charAt(i2))) {
            divIndex = i2--;
        }
        String base = defName;
        int num = 1;
        if (divIndex > 0) {
            base = defName.substring(0, divIndex);
            num = Integer.parseInt(defName.substring(divIndex)) + 1;
            for (i = divIndex; i < defName.length() - 1 && (c = defName.charAt(i)) == '0'; ++i) {
                base = base + '0';
            }
        } else if (divIndex == 0) {
            base = "";
            num = Integer.parseInt(defName) + 1;
            for (i = divIndex; i < defName.length() - 1 && (c = defName.charAt(i)) == '0'; ++i) {
                base = base + '0';
            }
        }
        i = num;
        while (true) {
            if (i - num > 100000) {
                throw new IllegalStateException("NameContainer not functioning");
            }
            String name = SlotPath.escape(base + i);
            if (!container.contains(name)) {
                return name;
            }
            ++i;
        }
    }

    public static String stripDigitsFromEnd(String s) {
        int x = s.length() - 1;
        boolean strip = false;
        while (Character.isDigit(s.charAt(x)) || s.charAt(x) == '$') {
            if (x == 0) {
                return s;
            }
            strip = true;
            --x;
        }
        if (!strip) {
            return s;
        }
        return s.substring(0, x + 1);
    }

    public static BOrd getGuideHelpOrd(TypeInfo type) {
        String module = type.getModuleName();
        String base = type.getLexicon(null).get("help.guide.base");
        StringBuilder s = new StringBuilder();
        if (base == null || base.length() == 0) {
            s.append("local:|module://").append(module).append("/doc/");
        } else if (base.startsWith("module:")) {
            s.append("local:|").append(base);
        } else {
            s.append(base);
        }
        if (s.charAt(s.length() - 1) != '/') {
            s.append('/');
        }
        s.append(module).append('-').append(type.getTypeName()).append(".html");
        return BOrd.make(s.toString());
    }

    public static BOrd getGuideHelpOrd(BObject object) {
        return ObjectUtil.getGuideHelpOrd(object.getType().getTypeInfo());
    }

    public static BOrd toSpyRelative(BObject target) {
        BINavNode node;
        String navPath;
        if (target instanceof BINavNode && (navPath = ObjectUtil.toNavPath(node = (BINavNode)((Object)target), BNavRoot.INSTANCE)) != null) {
            return BOrd.make("spy:/nav" + navPath);
        }
        return null;
    }

    public static BOrd toSpyLocal(BObject target) {
        BINavNode node;
        String navPath;
        if (target instanceof BINavNode && (navPath = ObjectUtil.toNavPath(node = (BINavNode)((Object)target), BNavRoot.INSTANCE)) != null) {
            return BOrd.make("local:|spy:/nav" + navPath);
        }
        return null;
    }

    public static BOrd toSpyRemote(BObject target) {
        String navPath;
        BISpaceNode node;
        BISession session;
        if (target instanceof BISpaceNode && (session = (node = (BISpaceNode)((Object)target)).getSession()) != null && (navPath = ObjectUtil.toNavPath(node, session)) != null) {
            return BOrd.make(session.getNavOrd() + "|spy:/nav/localhost" + navPath);
        }
        return null;
    }

    static String toNavPath(BINavNode target, Object stop) {
        ArrayList<String> list = new ArrayList<String>();
        TypeInfo bog = Sys.getRegistry().getType("file:BogFile");
        TypeInfo vSpace = Sys.getRegistry().getType("baja:VirtualComponentSpace");
        TypeInfo foxVSpace = Sys.getRegistry().getType("fox:FoxVirtualSpace");
        while (target != null && target != stop) {
            BINavNode parent = target.getNavParent();
            if (target instanceof BComponentSpace || target.getType().is(bog) || parent != null && (parent.getType().is(vSpace) || parent.getType().is(foxVSpace))) {
                target = target.getNavParent();
                continue;
            }
            String name = target.getNavName();
            if (name == null) {
                return null;
            }
            if (name.length() > 0) {
                list.add(name);
            }
            target = parent;
        }
        StringBuilder s = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            String name = (String)list.get(i);
            s.append('/').append(SlotPath.escape(name));
        }
        return s.toString();
    }

    public static void dump(BComplex complex) {
        PrintWriter out = new PrintWriter(System.out);
        ObjectUtil.dump(out, complex);
        out.flush();
    }

    public static void dump(PrintWriter out, BComplex complex) {
        ObjectUtil.dump(null, out, complex, false);
    }

    public static void dumpComponents(BComplex complex) {
        PrintWriter out = new PrintWriter(System.out);
        ObjectUtil.dumpComponents(out, complex);
        out.flush();
    }

    public static void dumpComponents(PrintWriter out, BComplex complex) {
        ObjectUtil.dump(null, out, complex, true);
    }

    private static void dump(String indent, PrintWriter out, BComplex complex, boolean componentsOnly) {
        if (indent == null) {
            indent = "";
        }
        out.print(indent);
        out.print(complex.getName());
        out.print(" [" + complex.getType() + "] ");
        if (complex.isComponent()) {
            out.print(" h=" + complex.asComponent().getHandle());
        }
        out.println();
        String subIndent = indent + "  ";
        SlotCursor<Property> cursor = complex.getProperties();
        while (cursor.next()) {
            BValue child = cursor.get();
            if (componentsOnly && !(child instanceof BComponent)) continue;
            if (child instanceof BComplex) {
                ObjectUtil.dump(subIndent, out, (BComplex)child, componentsOnly);
                continue;
            }
            out.print(subIndent);
            out.print(cursor.property().getName());
            out.print(": ");
            out.println(cursor.get());
        }
    }

    public static BFacets appendModuleDependencyFacets(BFacets origFacets, Stream<String> moduleNames) {
        HashSet distinctModuleNames = new HashSet();
        Stream<String> existingModuleNames = ObjectUtil.getModuleDependenciesFromFacets(origFacets);
        existingModuleNames.forEach(moduleName -> distinctModuleNames.add(moduleName));
        moduleNames.forEach(moduleName -> distinctModuleNames.add(moduleName));
        StringBuilder sb = new StringBuilder();
        distinctModuleNames.forEach(moduleName -> {
            if (sb.length() == 0) {
                sb.append((String)moduleName);
            } else {
                sb.append(';').append((String)moduleName);
            }
        });
        BFacets newFacets = BFacets.makeRemove(origFacets, MODULE_DEPENDENCY_FACET_KEY);
        if (sb.length() > 0) {
            newFacets = BFacets.make(newFacets, MODULE_DEPENDENCY_FACET_KEY, BString.make(sb.toString()));
        }
        return newFacets;
    }

    public static Stream<String> getModuleDependenciesFromFacets(BFacets facets) {
        String encodedModuleNames = facets.gets(MODULE_DEPENDENCY_FACET_KEY, null);
        if (encodedModuleNames == null || encodedModuleNames.isEmpty()) {
            return Stream.empty();
        }
        return Arrays.stream(encodedModuleNames.split(";"));
    }

    public static final void checkForLegalChild(BComponent parent, BValue child, Context cx) {
        if (!child.getType().is(BIRestrictedComponent.TYPE)) {
            return;
        }
        BComponentSpace space = parent.getComponentSpace();
        if (space == null || space.isProxyComponentSpace()) {
            return;
        }
        BStation station = ObjectUtil.getStation(space);
        if (station == null) {
            return;
        }
        if (Sys.getStation() == station && Sys.isStationStarted() || ObjectUtil.isLoadedBogSpace(space)) {
            ((BIRestrictedComponent)((Object)child)).checkParentForRestrictedComponent(parent, cx);
        }
    }

    public static final BStation getStation(BComponentSpace space) {
        BComponent[] children;
        BComponent root = space.getRootComponent();
        if (root == null) {
            return null;
        }
        if (root.getType().is(BStation.TYPE)) {
            return (BStation)root;
        }
        if (root.getType().equals(BUnrestrictedFolder.TYPE) && root.getPropertyCount() == 1 && (children = root.getChildComponents()).length == 1 && children[0].getType().is(BStation.TYPE)) {
            return (BStation)children[0];
        }
        return null;
    }

    public static <T> Optional<T> getDefaultAgentInstanceOfClass(BObject object, Class<T> clazz) {
        try {
            return Optional.of(object.getAgents().filter(agent -> {
                Class<?> typeClass = agent.getAgentType().getTypeSpec().getResolvedType().getTypeClass();
                return clazz.isAssignableFrom(typeClass);
            }).getDefault().getInstance());
        }
        catch (NoSuchAgentException ignored) {
            return Optional.empty();
        }
    }

    private static final boolean isLoadedBogSpace(BComponentSpace space) {
        if (bogSpaceTypeInfo == null) {
            bogSpaceTypeInfo = BTypeSpec.make("file", "BogSpace").getTypeInfo();
        }
        if (space.getType().is(bogSpaceTypeInfo)) {
            return ((BSubSpaceFile)space.getNavParent()).getSubSpace() != null;
        }
        return false;
    }

    public static void checkMinMaxFacetsOnValue(BValue newValue, BFacets facets, Context context) {
        BObject maxFacet;
        if (SERVER_MIN_MAX_CHECK_DISABLED || facets == null || newValue == null || MIN_MAX_CHECK_EXCLUDED_TYPES.stream().anyMatch(t -> newValue.getType().is((TypeInfo)t)) || newValue instanceof BNumber && Double.isNaN(((BNumber)newValue).getDouble())) {
            return;
        }
        BObject minFacet = facets.get("min");
        if (minFacet instanceof BIComparable) {
            if (newValue instanceof BString) {
                String newValueStr = newValue.toString();
                if (minFacet instanceof BNumber && newValueStr != null && newValueStr.length() < ((BNumber)minFacet).getInt()) {
                    BasicContext cx = new BasicContext(context, facets);
                    String minFacetStr = minFacet.toString(cx);
                    BObject maxFacet2 = facets.get("max");
                    String range = maxFacet2 == null ? "" : RANGE_TEXT.getText(cx, new String[]{minFacetStr, maxFacet2.toString(cx)});
                    throw new LocalizableRuntimeException("baja", "stringValueTooShort", new String[]{BInteger.make(newValueStr.length()).toString(cx), minFacetStr, range});
                }
            } else if (newValue instanceof BIComparable) {
                int compareResult;
                try {
                    compareResult = ((BIComparable)((Object)newValue)).compareTo(minFacet);
                }
                catch (Throwable t2) {
                    compareResult = 0;
                }
                if (compareResult < 0) {
                    BasicContext cx = new BasicContext(context, facets);
                    String minFacetStr = minFacet.toString(cx);
                    BObject maxFacet3 = facets.get("max");
                    String range = maxFacet3 == null ? "" : RANGE_TEXT.getText(cx, new String[]{minFacetStr, maxFacet3.toString(cx)});
                    throw new LocalizableRuntimeException("baja", "valueTooLow", new String[]{newValue.toString(cx), minFacetStr, range});
                }
            }
        }
        if ((maxFacet = facets.get("max")) instanceof BIComparable) {
            if (newValue instanceof BString) {
                String newValueStr = newValue.toString();
                if (maxFacet instanceof BNumber && newValueStr != null && newValueStr.length() > ((BNumber)maxFacet).getInt()) {
                    BasicContext cx = new BasicContext(context, facets);
                    String maxFacetStr = maxFacet.toString(cx);
                    String range = minFacet == null ? "" : RANGE_TEXT.getText(cx, new String[]{minFacet.toString(cx), maxFacetStr});
                    throw new LocalizableRuntimeException("baja", "stringValueTooLong", new String[]{BInteger.make(newValueStr.length()).toString(cx), maxFacetStr, range});
                }
            } else if (newValue instanceof BIComparable) {
                int compareResult;
                try {
                    compareResult = ((BIComparable)((Object)newValue)).compareTo(maxFacet);
                }
                catch (Throwable t3) {
                    compareResult = 0;
                }
                if (compareResult > 0) {
                    BasicContext cx = new BasicContext(context, facets);
                    String maxFacetStr = maxFacet.toString(cx);
                    String range = minFacet == null ? "" : RANGE_TEXT.getText(cx, new String[]{minFacet.toString(cx), maxFacetStr});
                    throw new LocalizableRuntimeException("baja", "valueTooHigh", new String[]{newValue.toString(cx), maxFacetStr, range});
                }
            }
        }
    }

    public static OrdTarget resolveAndCheckRead(BOrd ord, BObject base, Context cx) {
        OrdTarget target = ord.resolve(base, cx);
        if (!target.canRead()) {
            throw new UnresolvedException(ord.toString());
        }
        return target;
    }

    static {
        Set<TypeInfo> excludedTypes = null;
        try {
            String excludedTypesString = AccessController.doPrivileged(() -> System.getProperty("niagara.serverMinMaxChecks.excludedTypes"));
            if (excludedTypesString != null) {
                String[] excludedTypeSpecs;
                excludedTypes = new HashSet<TypeInfo>();
                for (String excludedTypeSpec : excludedTypeSpecs = excludedTypesString.split(";")) {
                    try {
                        excludedTypes.add(BTypeSpec.make(excludedTypeSpec).getTypeInfo());
                    }
                    catch (Throwable t) {
                        LOG.severe("Could not load excluded type for server MIN/MAX facet checks: " + excludedTypeSpec);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (excludedTypes == null) {
            excludedTypes = DEFAULT_MIN_MAX_CHECK_EXCLUDED_TYPES;
        }
        MIN_MAX_CHECK_EXCLUDED_TYPES = Collections.unmodifiableSet(excludedTypes);
    }

    public static class NameContainerList
    extends ArrayList<String>
    implements NameContainer {
        @Override
        public boolean contains(String name) {
            return super.contains(name);
        }
    }

    public static interface NameContainer {
        public boolean contains(String var1);
    }
}

